/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.swing.editor;

import java.awt.Cursor;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JEditorPane;
import javax.swing.JPopupMenu;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import ru.turikhay.tlauncher.ui.alert.Alert;
import ru.turikhay.tlauncher.ui.loc.Localizable;
import ru.turikhay.tlauncher.ui.loc.LocalizableMenuItem;
import ru.turikhay.tlauncher.ui.swing.editor.ExtendedImageView;
import ru.turikhay.tlauncher.ui.swing.editor.HyperlinkProcessor;

public class ExtendedHTMLEditorKit
extends HTMLEditorKit {
    public static final ExtendedHTMLFactory extendedFactory = new ExtendedHTMLFactory();
    public final ExtendedLinkController linkController = new ExtendedLinkController();
    private HyperlinkProcessor hlProc = HyperlinkProcessor.defaultProcessor;
    private boolean processPopup = true;
    private static final Cursor HAND = Cursor.getPredefinedCursor(12);
    private String popupHref;
    private final JPopupMenu popup = new JPopupMenu();

    public ExtendedHTMLEditorKit() {
        LocalizableMenuItem copy = new LocalizableMenuItem("browser.hyperlink.popup.copy");
        copy.addActionListener(e -> Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(this.popupHref), null));
        this.popup.add(copy);
        LocalizableMenuItem show = new LocalizableMenuItem("browser.hyperlink.popup.show");
        show.addActionListener(e -> Alert.showMessage(Localizable.get("browser.hyperlink.popup.show.alert.title"), "", this.popupHref));
        this.popup.add(show);
    }

    @Override
    public ViewFactory getViewFactory() {
        return extendedFactory;
    }

    @Override
    public void install(JEditorPane pane) {
        super.install(pane);
        for (MouseListener listener : pane.getMouseListeners()) {
            if (!(listener instanceof HTMLEditorKit.LinkController) && !(listener instanceof ExtendedLinkController)) continue;
            pane.removeMouseListener(listener);
            pane.removeMouseMotionListener((MouseMotionListener)((Object)listener));
        }
        pane.addMouseListener(this.linkController);
        pane.addMouseMotionListener(this.linkController);
    }

    public final HyperlinkProcessor getHyperlinkProcessor() {
        return this.hlProc;
    }

    public final void setHyperlinkProcessor(HyperlinkProcessor processor) {
        this.hlProc = processor == null ? HyperlinkProcessor.defaultProcessor : processor;
    }

    public final boolean getProcessPopup() {
        return this.processPopup;
    }

    public final void setProcessPopup(boolean process) {
        this.processPopup = process;
    }

    private static HTML.Tag getTag(Element elem) {
        AttributeSet attrs = elem.getAttributes();
        Object elementName = attrs.getAttribute("$ename");
        Object o = elementName != null ? null : attrs.getAttribute(StyleConstants.NameAttribute);
        return o instanceof HTML.Tag ? (HTML.Tag)o : null;
    }

    private static String getAnchorHref(MouseEvent e) {
        AttributeSet anchor;
        Object hrefObject;
        Object anchorAttr;
        JEditorPane editor = (JEditorPane)e.getSource();
        if (!(editor.getDocument() instanceof HTMLDocument)) {
            return null;
        }
        HTMLDocument hdoc = (HTMLDocument)editor.getDocument();
        Element elem = hdoc.getCharacterElement(editor.viewToModel(e.getPoint()));
        HTML.Tag tag = ExtendedHTMLEditorKit.getTag(elem);
        if (tag == HTML.Tag.CONTENT && (anchorAttr = elem.getAttributes().getAttribute(HTML.Tag.A)) instanceof AttributeSet && (hrefObject = (anchor = (AttributeSet)anchorAttr).getAttribute(HTML.Attribute.HREF)) instanceof String) {
            return (String)hrefObject;
        }
        return null;
    }

    public class ExtendedLinkController
    extends MouseAdapter {
        @Override
        public void mouseClicked(MouseEvent e) {
            String href;
            JEditorPane editor = (JEditorPane)e.getSource();
            if ((editor.isEnabled() || editor.isDisplayable()) && (href = ExtendedHTMLEditorKit.getAnchorHref(e)) != null) {
                JPopupMenu menu = null;
                switch (e.getButton()) {
                    case 3: {
                        if (!ExtendedHTMLEditorKit.this.processPopup) break;
                        ExtendedHTMLEditorKit.this.popupHref = href;
                        menu = ExtendedHTMLEditorKit.this.popup;
                        break;
                    }
                    default: {
                        menu = ExtendedHTMLEditorKit.this.hlProc.process(href);
                    }
                }
                if (menu != null) {
                    menu.show(editor, e.getX(), e.getY());
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            JEditorPane editor = (JEditorPane)e.getSource();
            if (editor.isEnabled() || editor.isDisplayable()) {
                editor.setCursor(ExtendedHTMLEditorKit.getAnchorHref(e) == null ? Cursor.getDefaultCursor() : HAND);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            JEditorPane editor = (JEditorPane)e.getSource();
            if (editor.isEnabled() || editor.isDisplayable()) {
                editor.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    public static class ExtendedHTMLFactory
    extends HTMLEditorKit.HTMLFactory {
        @Override
        public View create(Element elem) {
            HTML.Tag kind = ExtendedHTMLEditorKit.getTag(elem);
            return kind == HTML.Tag.IMG ? new ExtendedImageView(elem) : super.create(elem);
        }
    }
}

