/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.swing.editor;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.io.IOException;
import java.net.URL;
import java.util.Locale;
import javax.swing.JEditorPane;
import javax.swing.text.html.StyleSheet;
import ru.turikhay.tlauncher.ui.loc.LocalizableLabel;
import ru.turikhay.tlauncher.ui.swing.editor.ExtendedHTMLEditorKit;
import ru.turikhay.tlauncher.ui.swing.extended.ExtendedLabel;
import ru.turikhay.tlauncher.ui.theme.Theme;
import ru.turikhay.util.SwingUtil;

public class EditorPane
extends JEditorPane {
    private final ExtendedHTMLEditorKit html = new ExtendedHTMLEditorKit();

    public EditorPane(Font font) {
        if (font == null) {
            this.setFont(new ExtendedLabel().getFont());
        } else {
            this.setFont(font);
        }
        this.getDocument().putProperty("IgnoreCharsetDirective", Boolean.TRUE);
        this.setMargin(new Insets(0, 0, 0, 0));
        this.setEditorKit(this.html);
        this.setEditable(false);
        this.setOpaque(false);
    }

    public EditorPane() {
        this(new LocalizableLabel().getFont());
    }

    public EditorPane(URL initialPage) throws IOException {
        this();
        this.setPage(initialPage);
    }

    public EditorPane(String url) throws IOException {
        this();
        this.setPage(url);
    }

    public EditorPane(String type, String text) {
        this();
        this.setContentType(type);
        this.setText(text);
    }

    public EditorPane(String text, int width) {
        this("text/html", text);
        this.setPreferredSize(new Dimension(width, SwingUtil.getPrefHeight(this, width)));
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.html != null) {
            Color color = Theme.getTheme().getForeground();
            String textColor = String.format(Locale.ROOT, "#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
            font = this.getFont();
            StyleSheet css = new StyleSheet();
            css.importStyleSheet(this.getClass().getResource("styles.css"));
            css.addRule("body { font-family: " + font.getFamily() + "; font-size: " + font.getSize() + "pt; color: " + textColor + "; } a { color: " + textColor + "; text-decoration: underline; }");
            this.html.setStyleSheet(css);
            this.setEditorKit(this.html);
        }
    }
}

