/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.swing.combobox;

import java.awt.Graphics;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.border.Border;
import javax.swing.text.JTextComponent;

class IconTextComponentHelper {
    private Border mBorder;
    private Icon mIcon;
    private Border mOrigBorder;
    private final JTextComponent mTextComponent;

    IconTextComponentHelper(JTextComponent component) {
        this.mTextComponent = component;
        this.mBorder = this.mOrigBorder = component.getBorder();
    }

    Border getBorder() {
        return this.mBorder;
    }

    void onPaintComponent(Graphics g) {
        if (this.mIcon != null) {
            this.mIcon.paintIcon(this.mTextComponent, g, 6, 2);
        }
    }

    void onSetBorder(Border border) {
        this.mOrigBorder = border;
        if (this.mIcon == null) {
            this.mBorder = border;
        } else {
            Border margin = BorderFactory.createEmptyBorder(0, this.mIcon.getIconWidth() + 4, 0, 0);
            this.mBorder = BorderFactory.createCompoundBorder(border, margin);
        }
    }

    void onSetIcon(Icon icon) {
        this.mIcon = icon;
        this.resetBorder();
    }

    private void resetBorder() {
        this.mTextComponent.setBorder(this.mOrigBorder);
    }
}

