/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.swing.combobox;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Document;
import ru.turikhay.tlauncher.ui.swing.combobox.IconText;
import ru.turikhay.tlauncher.ui.swing.combobox.IconTextComponent;

class FilterEditor<T>
extends BasicComboBoxEditor {
    private final IconTextComponent textField = new IconTextComponent();
    boolean editing;
    private final Function<T, IconText> displayTextFunction;
    private final Consumer<Boolean> editingChangeListener;
    private Object selected;
    private Caret caret;
    private final Caret EMPTY_CARET = new DefaultCaret(){

        @Override
        public void paint(Graphics g) {
        }

        @Override
        public boolean isVisible() {
            return false;
        }

        @Override
        public boolean isSelectionVisible() {
            return false;
        }
    };

    FilterEditor(Function<T, IconText> displayTextFunction, Consumer<Boolean> editingChangeListener) {
        this.displayTextFunction = displayTextFunction;
        this.editingChangeListener = editingChangeListener;
        this.inhibitSelectingOnFocusGain();
    }

    public void updateState() {
        this.setItem(this.selected);
    }

    public void addChar() {
        if (!this.editing) {
            this.enableEditingMode();
        }
    }

    private void inhibitSelectingOnFocusGain() {
        this.textField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                SwingUtilities.invokeLater(() -> {
                    Document doc = FilterEditor.this.textField.getDocument();
                    if (doc != null) {
                        FilterEditor.this.textField.setCaretPosition(doc.getLength());
                    }
                });
            }
        });
    }

    private void enableEditingMode() {
        this.editing = true;
        this.textField.setText("");
        this.textField.setIcon(null);
        this.editingChangeListener.accept(true);
        this.restoreCaret();
    }

    void hideCaret() {
        this.caret = this.textField.getCaret();
        this.textField.setCaret(this.EMPTY_CARET);
    }

    void restoreCaret() {
        if (this.caret != null) {
            this.textField.setCaret(this.caret);
        }
    }

    public void reset() {
        if (this.editing) {
            this.editing = false;
            this.editingChangeListener.accept(false);
            this.hideCaret();
        }
    }

    @Override
    public Component getEditorComponent() {
        return this.textField;
    }

    public JTextField getTextField() {
        return this.textField;
    }

    @Override
    public void setItem(Object anObject) {
        if (!this.editing) {
            Object t = anObject;
            IconText text = this.displayTextFunction.apply(t);
            this.textField.setText(text.getText());
            this.textField.setIcon(text.getIcon());
        }
        this.selected = anObject;
    }

    @Override
    public Object getItem() {
        return this.selected;
    }

    public boolean isEditing() {
        return this.editing;
    }
}

