/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.swing.combobox;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import ru.turikhay.tlauncher.ui.swing.combobox.FilterEditor;
import ru.turikhay.tlauncher.ui.swing.combobox.IconText;
import ru.turikhay.util.async.AsyncThread;

public class ComboBoxFilter<T> {
    private final JComboBox<T> comboBox;
    private final Supplier<List<T>> valueProvider;
    private final BiPredicate<T, String> filter;
    private final Function<T, IconText> textFunction;
    private T selectedItem;
    private FilterEditor<T> filterEditor;
    private final AtomicInteger modelCounter = new AtomicInteger();

    private ComboBoxFilter(JComboBox<T> comboBox, Supplier<List<T>> valueProvider, BiPredicate<T, String> filter, Function<T, IconText> textFunction) {
        this.comboBox = comboBox;
        this.valueProvider = valueProvider;
        this.filter = filter;
        this.textFunction = textFunction;
    }

    private void init() {
        this.prepareComboFiltering();
        this.initComboPopupListener();
        this.initComboKeyListener();
    }

    public void updateState() {
        this.filterEditor.updateState();
    }

    private void prepareComboFiltering() {
        for (T item : this.valueProvider.get()) {
            this.comboBox.addItem(item);
        }
        this.filterEditor = new FilterEditor<T>(this.textFunction, editing -> {
            if (editing.booleanValue()) {
                this.selectedItem = this.comboBox.getSelectedItem();
            } else {
                this.comboBox.setSelectedItem(this.selectedItem);
                this.filterEditor.setItem(this.selectedItem);
            }
        });
        JTextField filterLabel = this.filterEditor.getTextField();
        filterLabel.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                SwingUtilities.invokeLater(() -> {
                    ComboBoxFilter.this.comboBox.showPopup();
                    ComboBoxFilter.this.filterEditor.hideCaret();
                });
            }

            @Override
            public void focusLost(FocusEvent e) {
                ComboBoxFilter.this.resetFilterComponent();
            }
        });
        this.comboBox.setEditor(this.filterEditor);
        this.comboBox.setEditable(true);
    }

    private void initComboKeyListener() {
        this.filterEditor.getTextField().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                char keyChar = e.getKeyChar();
                if (!Character.isDefined(keyChar)) {
                    return;
                }
                int keyCode = e.getKeyCode();
                switch (keyCode) {
                    case 10: {
                        ComboBoxFilter.this.selectedItem = ComboBoxFilter.this.comboBox.getSelectedItem();
                        ComboBoxFilter.this.resetFilterComponent();
                        return;
                    }
                    case 27: {
                        ComboBoxFilter.this.filterEditor.hideCaret();
                        return;
                    }
                }
                ComboBoxFilter.this.filterEditor.addChar();
                if (!ComboBoxFilter.this.comboBox.isPopupVisible()) {
                    ComboBoxFilter.this.comboBox.showPopup();
                }
                SwingUtilities.invokeLater(() -> {
                    if (ComboBoxFilter.this.filterEditor.isEditing()) {
                        ComboBoxFilter.this.applyFilter();
                    } else {
                        ComboBoxFilter.this.resetFilterComponent();
                    }
                });
            }
        });
    }

    private void initComboPopupListener() {
        this.comboBox.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                Object item = ComboBoxFilter.this.comboBox.getSelectedItem();
                ComboBoxFilter.this.resetFilterComponent();
                if (item != null) {
                    ComboBoxFilter.this.comboBox.setSelectedItem(item);
                }
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                ComboBoxFilter.this.resetFilterComponent();
            }
        });
    }

    private void resetFilterComponent() {
        if (!this.filterEditor.isEditing()) {
            return;
        }
        this.modelCounter.incrementAndGet();
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.comboBox.getModel();
        model.removeAllElements();
        for (T item : this.valueProvider.get()) {
            model.addElement(item);
        }
        this.filterEditor.reset();
    }

    private void applyFilter() {
        int currentUse = this.modelCounter.incrementAndGet();
        String term = this.filterEditor.getTextField().getText();
        AsyncThread.execute(() -> {
            ArrayList<T> matchingItems = new ArrayList<T>();
            for (T item : this.valueProvider.get()) {
                if (!this.filter.test(item, term)) continue;
                matchingItems.add(item);
            }
            SwingUtilities.invokeLater(() -> {
                if (this.modelCounter.get() != currentUse) {
                    return;
                }
                DefaultComboBoxModel model = (DefaultComboBoxModel)this.comboBox.getModel();
                model.removeAllElements();
                matchingItems.forEach(model::addElement);
            });
        });
    }

    public static <T> ComboBoxFilter<T> decorate(JComboBox<T> comboBox, Supplier<List<T>> valueProvider, Function<T, IconText> textFunction, BiPredicate<T, String> filter) {
        ComboBoxFilter<T> decorator = new ComboBoxFilter<T>(comboBox, valueProvider, filter, textFunction);
        super.init();
        return decorator;
    }
}

