/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.swing;

import java.awt.Component;
import java.awt.Font;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import net.minecraft.launcher.updater.LatestVersionSyncInfo;
import net.minecraft.launcher.updater.VersionSyncInfo;
import net.minecraft.launcher.versions.ReleaseType;
import ru.turikhay.tlauncher.TLauncher;
import ru.turikhay.tlauncher.minecraft.auth.Account;
import ru.turikhay.tlauncher.ui.TLauncherFrame;
import ru.turikhay.tlauncher.ui.images.ImageIcon;
import ru.turikhay.tlauncher.ui.images.Images;
import ru.turikhay.tlauncher.ui.loc.Localizable;
import ru.turikhay.tlauncher.ui.theme.Theme;
import ru.turikhay.util.U;

public class VersionCellRenderer
implements ListCellRenderer<VersionSyncInfo> {
    public static final VersionSyncInfo LOADING = VersionSyncInfo.createEmpty();
    public static final VersionSyncInfo EMPTY = VersionSyncInfo.createEmpty();
    private final DefaultListCellRenderer defaultRenderer = new DefaultListCellRenderer();
    private final int averageColor = U.shiftColor(Theme.getTheme().getForeground(), -128, 64, 128).getRGB();
    private static final ImageIcon ELY_ICON = Images.getIcon16("logo-ely");
    private static final ImageIcon MOJANG_ICON = Images.getIcon16("logo-mojang");
    private static final ImageIcon MCLEAKS_ICON = Images.getIcon16("logo-mcleaks");

    @Override
    public Component getListCellRendererComponent(JList<? extends VersionSyncInfo> list, VersionSyncInfo value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel mainText = (JLabel)this.defaultRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        mainText.setFont(mainText.getFont().deriveFont(TLauncherFrame.getFontSize()));
        mainText.setAlignmentY(0.5f);
        if (value == null) {
            mainText.setText("(null)");
        } else if (value.equals(LOADING)) {
            mainText.setText(Localizable.get("versions.loading"));
        } else if (value.equals(EMPTY)) {
            mainText.setText(Localizable.get("versions.notfound.tip"));
        } else {
            int prefWidth;
            String label = VersionCellRenderer.getLabelFor(value);
            int width = mainText.getFontMetrics(mainText.getFont()).stringWidth(label);
            if (this.getShowVersionsFor() != null && TLauncher.getInstance().getLibraryManager().hasLibrariesExplicitly(value, this.getShowVersionsFor().toString())) {
                ImageIcon icon = VersionCellRenderer.getIconFor(this.getShowVersionsFor());
                mainText.setIcon(icon);
                if (icon != null) {
                    width += icon.getIconWidth() + mainText.getIconTextGap();
                }
            }
            if ((prefWidth = list.getFixedCellWidth()) > 0 && width >= prefWidth) {
                int curWidth;
                float fontSize = mainText.getFont().getSize2D();
                Font curFont = null;
                while (fontSize > 9.0f && (curWidth = mainText.getFontMetrics(curFont = mainText.getFont().deriveFont(fontSize -= 1.0f)).stringWidth(label)) > prefWidth) {
                }
                if (curFont != null) {
                    mainText.setFont(curFont);
                }
            }
            if (!value.isInstalled()) {
                mainText.setBackground(U.shiftColor(mainText.getBackground(), mainText.getBackground().getRGB() < this.averageColor ? 32 : -32));
            }
            mainText.setText(label);
        }
        return mainText;
    }

    public static ImageIcon getIconFor(Account.AccountType accountType) {
        ImageIcon icon = null;
        switch (accountType) {
            case ELY: 
            case ELY_LEGACY: {
                icon = ELY_ICON;
                break;
            }
            case MOJANG: {
                icon = MOJANG_ICON;
                break;
            }
            case MCLEAKS: {
                icon = MCLEAKS_ICON;
                break;
            }
        }
        return icon;
    }

    public static String getLabelFor(VersionSyncInfo value) {
        String label;
        String id;
        if (value == null) {
            return "(null)";
        }
        if (value.equals(LOADING)) {
            return Localizable.get("versions.loading");
        }
        if (value.equals(EMPTY)) {
            return Localizable.get("versions.notfound.tip");
        }
        LatestVersionSyncInfo asLatest = value instanceof LatestVersionSyncInfo ? (LatestVersionSyncInfo)value : null;
        ReleaseType type = value.getAvailableVersion().getReleaseType();
        if (value.hasRemote()) {
            if (asLatest == null) {
                id = value.getID();
                label = "version." + (Object)((Object)type);
            } else {
                id = asLatest.getVersionID();
                label = "version.latest." + (Object)((Object)type);
            }
            label = Localizable.nget(label);
            if (type != null) {
                switch (type) {
                    case OLD_BETA: {
                        id = id.substring(1);
                        break;
                    }
                    case OLD_ALPHA: {
                        id = id.startsWith("a") ? id.substring(1) : id;
                    }
                }
            }
        } else {
            label = null;
            id = value.getID();
        }
        StringBuilder text = new StringBuilder();
        if (label != null) {
            text.append(label).append(' ');
        }
        text.append(id);
        return text.toString();
    }

    public Account.AccountType getShowVersionsFor() {
        return null;
    }
}

