/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.swing;

import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.StringUtils;
import ru.turikhay.tlauncher.ui.loc.Localizable;
import ru.turikhay.tlauncher.ui.swing.EmptyAction;
import ru.turikhay.tlauncher.ui.text.ExtendedTextField;

public class TextPopup
extends MouseAdapter {
    @Override
    public void mouseClicked(MouseEvent e) {
        JPopupMenu popup;
        Object source;
        if (e.getModifiers() == 4 && (source = e.getSource()) instanceof JTextComponent && (popup = this.getPopup(e, (JTextComponent)source)) != null) {
            popup.show(e.getComponent(), e.getX(), e.getY() - popup.getSize().height);
        }
    }

    protected JPopupMenu getPopup(MouseEvent e, final JTextComponent comp) {
        boolean isSelected;
        if (!comp.isEnabled()) {
            return null;
        }
        boolean isEditable = comp.isEditable();
        boolean bl = isSelected = comp.getSelectedText() != null;
        boolean hasValue = comp instanceof ExtendedTextField ? ((ExtendedTextField)comp).getValue() != null : StringUtils.isNotEmpty((CharSequence)comp.getText());
        boolean pasteAvailable = isEditable && Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null).isDataFlavorSupported(DataFlavor.stringFlavor);
        JPopupMenu menu = new JPopupMenu();
        Action cut = isEditable && hasValue ? TextPopup.selectAction(comp, "cut-to-clipboard", "cut") : null;
        final Action copy = TextPopup.selectAction(comp, "copy-to-clipboard", "copy");
        Action paste = pasteAvailable ? TextPopup.selectAction(comp, "paste-from-clipboard", "paste", e1 -> {
            if (comp instanceof ExtendedTextField) {
                ((ExtendedTextField)comp).onFocusGained();
            }
        }) : null;
        final Action selectAll = hasValue ? TextPopup.selectAction(comp, "select-all", "selectAll") : null;
        EmptyAction copyAll = selectAll != null && copy != null ? new EmptyAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                selectAll.actionPerformed(e);
                copy.actionPerformed(e);
                comp.setSelectionStart(comp.getSelectionEnd());
            }
        } : null;
        if (cut != null) {
            menu.add(cut).setText(Localizable.get("popup.cut"));
        }
        if (isSelected && copy != null) {
            menu.add(copy).setText(Localizable.get("popup.copy"));
        }
        if (paste != null) {
            menu.add(paste).setText(Localizable.get("popup.paste"));
        }
        if (selectAll != null) {
            if (menu.getComponentCount() > 0 && !(menu.getComponent(menu.getComponentCount() - 1) instanceof JPopupMenu.Separator)) {
                menu.addSeparator();
            }
            menu.add(selectAll).setText(Localizable.get("popup.selectall"));
        }
        if (copyAll != null) {
            menu.add(copyAll).setText(Localizable.get("popup.copyall"));
        }
        if (menu.getComponentCount() == 0) {
            return null;
        }
        if (menu.getComponent(0) instanceof JPopupMenu.Separator) {
            menu.remove(0);
        }
        if (menu.getComponent(menu.getComponentCount() - 1) instanceof JPopupMenu.Separator) {
            menu.remove(menu.getComponentCount() - 1);
        }
        return menu;
    }

    private static Action selectAction(JTextComponent comp, String general, String fallback, final ActionListener listener) {
        Action action = comp.getActionMap().get(general);
        if (action == null) {
            action = comp.getActionMap().get(fallback);
        }
        if (action != null && listener != null) {
            final Action a = action;
            return new Action(){

                @Override
                public Object getValue(String key) {
                    return a.getValue(key);
                }

                @Override
                public void putValue(String key, Object value) {
                    a.putValue(key, value);
                }

                @Override
                public void setEnabled(boolean b) {
                    a.setEnabled(b);
                }

                @Override
                public boolean isEnabled() {
                    return a.isEnabled();
                }

                @Override
                public void addPropertyChangeListener(PropertyChangeListener listener2) {
                    a.addPropertyChangeListener(listener2);
                }

                @Override
                public void removePropertyChangeListener(PropertyChangeListener listener2) {
                    a.removePropertyChangeListener(listener2);
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    listener.actionPerformed(e);
                    a.actionPerformed(e);
                }
            };
        }
        return action;
    }

    private static Action selectAction(JTextComponent comp, String general, String fallback) {
        return TextPopup.selectAction(comp, general, fallback, null);
    }
}

