/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.swing;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.apache.commons.lang3.StringUtils;
import ru.turikhay.tlauncher.configuration.Configuration;
import ru.turikhay.tlauncher.ui.loc.Localizable;
import ru.turikhay.tlauncher.ui.loc.LocalizableComponent;
import ru.turikhay.tlauncher.ui.swing.extended.BorderPanel;
import ru.turikhay.tlauncher.ui.swing.extended.ExtendedLabel;
import ru.turikhay.util.IntegerArray;
import ru.turikhay.util.SwingUtil;

public class Dragger
extends BorderPanel
implements LocalizableComponent {
    private static final List<SoftReference<Dragger>> draggers = new ArrayList<SoftReference<Dragger>>();
    private static final Color enabledColor = new Color(0, 0, 0, 32);
    private static final Color disabledColor = new Color(0, 0, 0, 16);
    private static Configuration config;
    private static Point maxPoint;
    private static boolean ready;
    private final JComponent parent;
    private final String key;
    private final ExtendedLabel label;
    private String tooltip;

    public Dragger(JComponent parent, String name) {
        if (parent == null) {
            throw new NullPointerException("parent");
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (StringUtils.isEmpty((CharSequence)name)) {
            throw new IllegalArgumentException("name is empty");
        }
        this.parent = parent;
        this.key = "dragger." + name;
        DraggerMouseListener listener = new DraggerMouseListener();
        this.setCursor(SwingUtil.getCursor(13));
        this.label = new ExtendedLabel();
        this.label.addMouseListener(listener);
        this.setCenter(this.label);
        if (!ready) {
            draggers.add(new SoftReference<Dragger>(this));
        }
        this.setEnabled(true);
    }

    @Override
    public void paint(Graphics g0) {
        Graphics2D g = (Graphics2D)g0;
        g.setColor(this.isEnabled() ? enabledColor : disabledColor);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        super.paintComponent(g);
    }

    @Override
    public void setEnabled(boolean b) {
        this.tooltip = b ? "dragger.label" : null;
        this.updateLocale();
        super.setEnabled(b);
    }

    private void dragComponent(int x, int y) {
        if (ready) {
            if (x + this.parent.getWidth() > Dragger.maxPoint.x) {
                x = Dragger.maxPoint.x - this.parent.getWidth();
            }
            if (x < 0) {
                x = 0;
            }
            if (y + this.parent.getHeight() > Dragger.maxPoint.y) {
                y = Dragger.maxPoint.y - this.parent.getHeight();
            }
            if (y < 0) {
                y = 0;
            }
            this.parent.setLocation(x, y);
            config.set(this.key, new IntegerArray(x, y));
        }
    }

    public void updateCoords() {
        this.dragComponent(this.parent.getX(), this.parent.getY());
    }

    public void loadCoords() {
        IntegerArray arr;
        try {
            arr = IntegerArray.parseIntegerArray(config.get(this.key));
            if (arr.size() != 2) {
                throw new IllegalArgumentException("illegal size");
            }
        }
        catch (Exception var3) {
            var3.printStackTrace();
            return;
        }
        this.dragComponent(arr.get(0), arr.get(1));
    }

    private void ready() {
        this.updateLocale();
        this.loadCoords();
    }

    @Override
    public void updateLocale() {
        this.label.setToolTipText(Localizable.get(this.tooltip));
    }

    public static synchronized void ready(Configuration config, Point maxPoint) {
        if (!ready) {
            if (config == null) {
                throw new NullPointerException("config");
            }
            if (maxPoint == null) {
                throw new NullPointerException("maxPoint");
            }
            ready = true;
            for (SoftReference<Dragger> draggerRef : draggers) {
                Dragger dragger = draggerRef.get();
                if (dragger == null) continue;
                dragger.ready();
            }
        }
    }

    public static synchronized void update() {
        for (SoftReference<Dragger> draggerRef : draggers) {
            Dragger dragger = draggerRef.get();
            if (dragger == null) continue;
            dragger.updateCoords();
        }
    }

    public class DraggerMouseListener
    extends MouseAdapter {
        private final int[] startPoint = new int[2];

        @Override
        public void mousePressed(MouseEvent e) {
            if (Dragger.this.isEnabled()) {
                this.startPoint[0] = e.getX();
                this.startPoint[1] = e.getY();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (Dragger.this.isEnabled()) {
                Dragger.this.dragComponent(Dragger.this.parent.getX() + e.getX() - this.startPoint[0], Dragger.this.parent.getY() + e.getY() - this.startPoint[1]);
            }
        }
    }
}

