/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.swing;

import java.awt.Component;
import java.lang.ref.SoftReference;
import java.util.Objects;
import org.apache.commons.lang3.Validate;
import ru.turikhay.tlauncher.ui.block.Blockable;
import ru.turikhay.tlauncher.ui.swing.DelayedComponentLoader;
import ru.turikhay.util.SwingUtil;

public class DelayedComponent<T extends Component>
implements Blockable {
    private final DelayedComponentLoader<T> componentLoader;
    private SoftReference<T> componentRef;
    private Object blockObj;

    public DelayedComponent(DelayedComponentLoader<T> componentLoader) {
        this.componentLoader = componentLoader;
    }

    public T get() {
        Component comp;
        if (this.componentRef != null && (comp = (Component)this.componentRef.get()) != null) {
            return (T)comp;
        }
        return (T)SwingUtil.waitAndReturn(this::loadComponent);
    }

    public boolean isLoaded() {
        return this.componentRef != null && this.componentRef.get() != null;
    }

    public void load() {
        this.get();
    }

    private T loadComponent() {
        Component comp = (Component)Validate.notNull(this.componentLoader.loadComponent());
        this.componentRef = new SoftReference<Component>(comp);
        this.componentLoader.onComponentLoaded(comp);
        return (T)comp;
    }

    @Override
    public void block(Object var1) {
        this.blockObj = var1;
    }

    @Override
    public void unblock(Object var1) {
        if (Objects.equals(this.blockObj, var1)) {
            this.blockObj = null;
        }
    }
}

