/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.support;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.tlauncher.logger.Log4j2ContextHelper;
import ru.turikhay.tlauncher.pasta.Pasta;
import ru.turikhay.tlauncher.pasta.PastaResult;
import ru.turikhay.tlauncher.ui.alert.Alert;
import ru.turikhay.tlauncher.ui.explorer.FileExplorer;
import ru.turikhay.tlauncher.ui.frames.ProcessFrame;
import ru.turikhay.tlauncher.ui.support.OpenLinkFrame;
import ru.turikhay.util.StringUtil;
import ru.turikhay.util.sysinfo.SystemInfo;
import ru.turikhay.util.sysinfo.SystemInfoReporter;

public class SendInfoFrame
extends ProcessFrame<SendInfoResponse> {
    private static final Logger LOGGER = LogManager.getLogger(SendInfoFrame.class);
    private final SystemInfoReporter systemInfoReporter;

    public SendInfoFrame(SystemInfoReporter systemInfoReporter) {
        this.systemInfoReporter = systemInfoReporter;
        this.setTitlePath("support.sending.title", new Object[0]);
        this.getHead().setText("support.sending.head");
        this.setIcon("compress");
        this.pack();
    }

    public final void submit() {
        this.submit(new ProcessFrame.Process(){

            protected SendInfoResponse get() throws Exception {
                if (SendInfoFrame.this.systemInfoReporter != null) {
                    SystemInfo systemInfo;
                    try {
                        systemInfo = SendInfoFrame.this.systemInfoReporter.getReport().get(5L, TimeUnit.SECONDS);
                    }
                    catch (Exception ignored) {
                        systemInfo = null;
                    }
                    if (systemInfo != null) {
                        systemInfo.getLines().forEach(arg_0 -> ((Logger)LOGGER).info(arg_0));
                    }
                }
                Pasta pasta = new Pasta();
                pasta.setData(Log4j2ContextHelper.getCurrentLogFile());
                PastaResult result = pasta.paste();
                if (result instanceof PastaResult.PastaUploaded) {
                    return new SendInfoResponse(((PastaResult.PastaUploaded)result).getURL().toString());
                }
                if (result instanceof PastaResult.PastaFailed) {
                    throw new IOException(((PastaResult.PastaFailed)result).getError());
                }
                throw new InternalError("unknown result type");
            }
        });
    }

    @Override
    protected void onSucceeded(ProcessFrame.Process process, SendInfoResponse result) {
        super.onSucceeded(process, result);
        String link = result.getLink();
        SwingUtilities.invokeLater(() -> new OpenLinkFrame(link).showAtCenter());
    }

    @Override
    protected void onFailed(ProcessFrame.Process process, Exception e) {
        super.onFailed(process, e);
        if (Alert.showLocQuestion("support.sending.error")) {
            FileExplorer explorer;
            try {
                explorer = FileExplorer.newExplorer();
            }
            catch (Exception error) {
                Alert.showLocError("support.saving.error", error);
                return;
            }
            explorer.setSelectedFile(new File("diagnostic.log"));
            if (explorer.showSaveDialog(this) != 0) {
                return;
            }
            if (explorer.getSelectedFile() != null) {
                File file = explorer.getSelectedFile();
                try (InputStreamReader reader = Log4j2ContextHelper.getCurrentLogFile().read();
                     OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
                    IOUtils.copy((Reader)reader, (Writer)writer);
                }
                catch (Exception error) {
                    Alert.showLocError("support.saving.error", error);
                    return;
                }
                Alert.showLocMessage("support.saving.success", file);
            }
        }
    }

    public static final class SendInfoResponse {
        private final String link;

        SendInfoResponse(String link) {
            this.link = StringUtil.requireNotBlank(link);
        }

        public String getLink() {
            return this.link;
        }
    }
}

