/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.support;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import ru.turikhay.tlauncher.ui.frames.ProcessFrame;
import ru.turikhay.tlauncher.ui.frames.VActionFrame;
import ru.turikhay.tlauncher.ui.images.Images;
import ru.turikhay.tlauncher.ui.loc.Localizable;
import ru.turikhay.tlauncher.ui.loc.LocalizableButton;
import ru.turikhay.tlauncher.ui.loc.LocalizableCheckbox;
import ru.turikhay.tlauncher.ui.support.ContactUsFrame;
import ru.turikhay.tlauncher.ui.support.SendInfoFrame;
import ru.turikhay.tlauncher.ui.swing.extended.ExtendedLabel;
import ru.turikhay.tlauncher.ui.swing.extended.ExtendedPanel;
import ru.turikhay.util.OS;
import ru.turikhay.util.SwingUtil;
import ru.turikhay.util.sysinfo.OSHISystemInfoReporter;
import ru.turikhay.util.sysinfo.SystemInfoReporter;

public class PreSupportFrame
extends VActionFrame {
    private final ExtendedLabel whatIsDiagnosticLabel = new ExtendedLabel();
    private final LocalizableCheckbox sendDiagnosticCheckbox;
    private final ExtendedPanel checkboxPanel;
    private final SystemInfoReporter systemInfoReporter;
    private final SendInfoFrame sendInfoFrame;

    public PreSupportFrame() {
        this.whatIsDiagnosticLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                OS.openLink(Localizable.get("support.pre.diag.url"));
            }
        });
        this.whatIsDiagnosticLabel.setIcon(Images.getIcon24("lightbulb-o"));
        this.whatIsDiagnosticLabel.setCursor(Cursor.getPredefinedCursor(12));
        this.sendDiagnosticCheckbox = new LocalizableCheckbox("support.pre.diag.checkbox");
        this.sendDiagnosticCheckbox.setSelected(true);
        this.checkboxPanel = new ExtendedPanel();
        this.checkboxPanel.setInsets(new Insets(0, 0, 0, 0));
        FlowLayout layout = new FlowLayout(0);
        layout.setHgap(0);
        layout.setVgap(0);
        this.checkboxPanel.setLayout(layout);
        this.checkboxPanel.add((Component)this.sendDiagnosticCheckbox);
        this.checkboxPanel.add((Component)this.whatIsDiagnosticLabel);
        this.systemInfoReporter = OSHISystemInfoReporter.createIfAvailable().orElse(null);
        if (this.systemInfoReporter != null) {
            this.systemInfoReporter.queueReport();
        }
        this.sendInfoFrame = new SendInfoFrame(this.systemInfoReporter){

            @Override
            protected void onSucceeded(ProcessFrame.Process process, SendInfoFrame.SendInfoResponse result) {
                super.onSucceeded(process, result);
                PreSupportFrame.this.setVisible(false);
            }

            @Override
            protected void onFailed(ProcessFrame.Process process, Exception e) {
                super.onFailed(process, e);
                PreSupportFrame.this.sendDiagnosticCheckbox.setSelected(false);
                PreSupportFrame.this.setVisible(true);
            }
        };
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                PreSupportFrame.this.whatIsDiagnosticLabel.requestFocus();
            }
        });
        this.setTitlePath("support.pre.title", new Object[0]);
        this.getHead().setIcon(Images.getIcon24("life-ring"));
        this.getHead().setText("support.pre.title");
        this.getBodyText().setText("support.pre.body");
        this.getFooter().setLayout(new GridBagLayout());
        this.getFooter().removeAll();
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.anchor = 21;
        c.fill = 2;
        this.getFooter().add((Component)this.checkboxPanel, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        LocalizableButton continueButton = new LocalizableButton("support.pre.continue");
        continueButton.setPreferredSize(new Dimension(1, SwingUtil.magnify(50)));
        continueButton.addActionListener(e -> this.onContinued());
        c.gridwidth = 0;
        this.getFooter().add((Component)continueButton, c);
        this.pack();
        this.whatIsDiagnosticLabel.setToolTipText(Localizable.get("support.pre.diag.whatisit"));
    }

    protected void onContinued() {
        if (this.sendDiagnosticCheckbox.isSelected()) {
            this.sendInfoFrame.submit();
        } else {
            new ContactUsFrame().showAtCenter();
        }
        this.setVisible(false);
    }
}

