/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.support;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.tlauncher.TLauncher;
import ru.turikhay.tlauncher.configuration.Configuration;
import ru.turikhay.tlauncher.configuration.LangConfiguration;
import ru.turikhay.tlauncher.configuration.SimpleConfiguration;
import ru.turikhay.tlauncher.ui.alert.Alert;
import ru.turikhay.util.FileUtil;

public final class ContributorsAlert {
    private static final Logger LOGGER = LogManager.getLogger(ContributorsAlert.class);
    private static JsonObject contributors;
    private static SimpleConfiguration proofreaders;

    private static void showIt() throws Exception {
        if (TLauncher.getInstance() == null) {
            return;
        }
        if (contributors == null) {
            contributors = (JsonObject)new JsonParser().parse((Reader)new InputStreamReader(ContributorsAlert.class.getResourceAsStream("/lang/_contrib.json"), FileUtil.getCharset()));
        }
        if (proofreaders == null) {
            proofreaders = new SimpleConfiguration(ContributorsAlert.class.getResource("/lang/_proofr.properties"));
        }
        Configuration settings = TLauncher.getInstance().getSettings();
        Locale locale = settings.getLocale();
        boolean hasUpgraded = TLauncher.getVersion().greaterThanOrEqualTo(settings.getVersion("update.asked"));
        boolean contributorsHaveBeenShownBefore = locale.toString().equals(settings.get("contributors"));
        settings.set("contributors", locale.toString());
        settings.set("update.asked", TLauncher.getVersion());
        if (hasUpgraded && !contributorsHaveBeenShownBefore) {
            String proofreader;
            Locale ruLocale = LangConfiguration.ru_RU;
            boolean isUssr = ruLocale != null && settings.isLikelyRussianSpeakingLocale();
            ArrayList<String> contributorList = new ArrayList<String>();
            int others = 0;
            JsonArray contribArray = (JsonArray)contributors.get(locale.toString());
            if (contribArray == null) {
                return;
            }
            for (Object elem : contribArray.getAsJsonArray()) {
                if (elem.getAsJsonPrimitive().isNumber()) {
                    others = elem.getAsInt();
                    break;
                }
                contributorList.add(elem.getAsString());
            }
            if (contributorList.isEmpty()) {
                return;
            }
            StringBuilder b = new StringBuilder();
            b.append("<b>Legacy Launcher</b> ");
            b.append(isUssr ? "\u043f\u0435\u0440\u0435\u0432\u0435\u0434\u0451\u043d \u043d\u0430" : "is translated to");
            b.append(" <b>");
            b.append(locale.getDisplayName(locale));
            b.append("</b> ");
            b.append(isUssr ? "\u0431\u043b\u0430\u0433\u043e\u0434\u0430\u0440\u044f" : "thanks to");
            b.append(" ");
            if (contributorList.size() > 1) {
                b.append(isUssr ? "\u044d\u0442\u0438\u043c \u043b\u044e\u0434\u044f\u043c" : "these people");
                b.append(":\n");
                for (String contributor : contributorList) {
                    b.append("\n\u2022 <b>").append(contributor).append("</b>");
                }
                if (others > 0) {
                    b.append("\n ... and ").append(others).append(" others");
                }
            } else {
                b.append("<b>").append((String)contributorList.get(0)).append("</b>!");
            }
            if ((proofreader = proofreaders.get(locale.toString())) != null) {
                b.append("\n\n");
                b.append(isUssr ? "\u041f\u0435\u0440\u0435\u0434 \u0432\u044b\u043f\u0443\u0441\u043a\u043e\u043c \u043f\u0435\u0440\u0435\u0432\u043e\u0434 \u043f\u0440\u043e\u0432\u0435\u0440\u0438\u043b \u0442\u043e\u0432\u0430\u0440\u0438\u0449" : "Translation proofreading is done by");
                b.append(" <b>");
                b.append(proofreader);
                b.append("</b>");
            }
            Alert.showMessage(isUssr ? "\u041f\u0435\u0440\u0435\u0432\u043e\u0434" : "Translation", b.toString());
        }
    }

    public static void showAlert() {
        try {
            ContributorsAlert.showIt();
        }
        catch (Exception e) {
            LOGGER.error("Couldn't show window", (Throwable)e);
        }
    }

    private ContributorsAlert() {
    }
}

