/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.support;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import ru.turikhay.tlauncher.TLauncher;
import ru.turikhay.tlauncher.configuration.Configuration;
import ru.turikhay.tlauncher.ui.frames.VActionFrame;
import ru.turikhay.tlauncher.ui.images.Images;
import ru.turikhay.tlauncher.ui.loc.LocalizableButton;
import ru.turikhay.util.OS;
import ru.turikhay.util.SwingUtil;
import ru.turikhay.util.U;

public class ContactUsFrame
extends VActionFrame {
    private static final List<SupportService> supportServices = Arrays.asList(ContactUsFrame.cisOnly("vk", "https://llaun.ch/support/vk"), ContactUsFrame.cisOnly("discord", "https://llaun.ch/support/discord/ru"), ContactUsFrame.notCis("discord", "https://llaun.ch/support/discord/intl"), ContactUsFrame.any("mail", "envelope-open", "mailto:" + TLauncher.getSupportEmail()));

    public ContactUsFrame() {
        this.setTitlePath("support.contact.title", new Object[0]);
        this.getHead().setIcon(Images.getIcon32("pencil-square"));
        this.getHead().setText("support.contact.title");
        this.getBodyText().setText("support.contact.body");
        this.getFooter().removeAll();
        this.getFooter().setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        for (int i = 0; i < supportServices.size(); ++i) {
            SupportService supportService = supportServices.get(i);
            if (!supportService.isApplicable()) continue;
            if (i == supportServices.size() - 1) {
                c.gridwidth = 0;
            }
            this.getFooter().add((Component)supportService.createButton(), c);
            if (++c.gridx % 2 != 0) continue;
            c.gridx = 0;
            ++c.gridy;
        }
        this.pack();
        this.setDefaultCloseOperation(2);
    }

    static SupportService cisOnly(String name, String url) {
        return new SupportService(name, "logo-" + name, url, LangValidator.ONLY_CIS);
    }

    static SupportService notCis(String name, String url) {
        return new SupportService(name, "logo-" + name, url, LangValidator.NOT_CIS);
    }

    static SupportService any(String name, String icon, String url) {
        return new SupportService(name, icon, url, LangValidator.ANY);
    }

    static SupportService any(String name, String url) {
        return new SupportService(name, "logo-" + name, url, LangValidator.ANY);
    }

    private static class SupportService {
        final String name;
        final String icon;
        final URL url;
        final LangValidator lang;

        SupportService(String name, String icon, String url, LangValidator lang) {
            this.name = name;
            this.icon = icon;
            this.url = U.makeURL(url, true);
            this.lang = lang;
        }

        LocalizableButton createButton() {
            LocalizableButton b = new LocalizableButton("support.contact.buttons." + this.name);
            b.setIcon(Images.getIcon24(this.icon));
            b.setPreferredSize(new Dimension(1, SwingUtil.magnify(50)));
            b.addActionListener(e -> OS.openLink(this.url));
            return b;
        }

        boolean isApplicable() {
            return this.lang.isValidFor(TLauncher.getInstance().getSettings().getLocale().toString());
        }
    }

    private static interface LangValidator {
        public static final LangValidator ONLY_CIS = Configuration::isLikelyRussianSpeakingLocale;
        public static final LangValidator NOT_CIS = locale -> !ONLY_CIS.isValidFor(locale);
        public static final LangValidator ANY = locale -> true;

        public boolean isValidFor(String var1);
    }
}

