/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.settings;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.minecraft.launcher.versions.ReleaseType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.tlauncher.TLauncher;
import ru.turikhay.tlauncher.configuration.Configuration;
import ru.turikhay.tlauncher.managers.VersionLists;
import ru.turikhay.tlauncher.stats.Stats;
import ru.turikhay.tlauncher.ui.FlatLaf;
import ru.turikhay.tlauncher.ui.alert.Alert;
import ru.turikhay.tlauncher.ui.block.Blocker;
import ru.turikhay.tlauncher.ui.converter.ActionOnLaunchConverter;
import ru.turikhay.tlauncher.ui.converter.DirectionConverter;
import ru.turikhay.tlauncher.ui.converter.LoggerTypeConverter;
import ru.turikhay.tlauncher.ui.converter.SeparateDirsConverter;
import ru.turikhay.tlauncher.ui.editor.EditorCheckBox;
import ru.turikhay.tlauncher.ui.editor.EditorComboBox;
import ru.turikhay.tlauncher.ui.editor.EditorFieldChangeListener;
import ru.turikhay.tlauncher.ui.editor.EditorFieldHandler;
import ru.turikhay.tlauncher.ui.editor.EditorFieldListener;
import ru.turikhay.tlauncher.ui.editor.EditorFileField;
import ru.turikhay.tlauncher.ui.editor.EditorGroupHandler;
import ru.turikhay.tlauncher.ui.editor.EditorHandler;
import ru.turikhay.tlauncher.ui.editor.EditorPair;
import ru.turikhay.tlauncher.ui.editor.EditorResolutionField;
import ru.turikhay.tlauncher.ui.editor.TabbedEditorPanel;
import ru.turikhay.tlauncher.ui.explorer.FileExplorer;
import ru.turikhay.tlauncher.ui.explorer.FilteredFileExplorer;
import ru.turikhay.tlauncher.ui.explorer.ImageFileExplorer;
import ru.turikhay.tlauncher.ui.explorer.MediaFileExplorer;
import ru.turikhay.tlauncher.ui.images.Images;
import ru.turikhay.tlauncher.ui.loc.Localizable;
import ru.turikhay.tlauncher.ui.loc.LocalizableButton;
import ru.turikhay.tlauncher.ui.loc.LocalizableComponent;
import ru.turikhay.tlauncher.ui.loc.LocalizableMenuItem;
import ru.turikhay.tlauncher.ui.loc.LocalizableStringConverter;
import ru.turikhay.tlauncher.ui.login.LoginException;
import ru.turikhay.tlauncher.ui.login.LoginForm;
import ru.turikhay.tlauncher.ui.scenes.DefaultScene;
import ru.turikhay.tlauncher.ui.settings.GPUComboBox;
import ru.turikhay.tlauncher.ui.settings.HTMLPage;
import ru.turikhay.tlauncher.ui.settings.JREComboBox;
import ru.turikhay.tlauncher.ui.settings.MemorySlider;
import ru.turikhay.tlauncher.ui.settings.SettingsFontSlider;
import ru.turikhay.tlauncher.ui.settings.SettingsLocaleComboBox;
import ru.turikhay.tlauncher.ui.support.ContributorsAlert;
import ru.turikhay.tlauncher.ui.swing.extended.BorderPanel;
import ru.turikhay.tlauncher.ui.swing.extended.ExtendedButton;
import ru.turikhay.util.Direction;
import ru.turikhay.util.IntegerArray;
import ru.turikhay.util.OS;
import ru.turikhay.util.SwingUtil;

public class SettingsPanel
extends TabbedEditorPanel
implements LoginForm.LoginProcessListener,
LocalizableComponent {
    private static final Logger LOGGER = LogManager.getLogger(SettingsPanel.class);
    final DefaultScene scene;
    private final TabbedEditorPanel.EditorPanelTab minecraftTab;
    public final EditorFieldHandler directory;
    public final EditorFieldHandler useSeparateDir;
    public final EditorFieldHandler resolution;
    public final EditorFieldHandler fullscreen;
    public final EditorFieldHandler jre;
    public final EditorFieldHandler memory;
    public final EditorFieldHandler gpu;
    public final EditorGroupHandler versionHandler;
    public final EditorFieldHandler oldVersionsHandler;
    public final EditorGroupHandler extraHandler;
    public final EditorFieldHandler launcherResolution;
    public final EditorFieldHandler laf;
    public final EditorFieldHandler font;
    public final EditorFieldHandler background;
    public final EditorFieldHandler loginFormDirection;
    public final EditorFieldHandler logger;
    public final EditorFieldHandler crashManager;
    public final EditorFieldHandler fullCommand;
    public final EditorFieldHandler launchAction;
    public final EditorGroupHandler alertUpdates;
    public final EditorFieldHandler allowNoticeDisable;
    public final EditorFieldHandler switchToBeta;
    public final EditorFieldHandler locale;
    public final HTMLPage about;
    private final BorderPanel buttonPanel;
    private final JPopupMenu popup;
    private final LocalizableMenuItem infoItem;
    private final LocalizableMenuItem defaultItem;
    private EditorHandler selectedHandler;
    public boolean ready = false;
    private boolean hideUponSave = true;

    public SettingsPanel(DefaultScene sc) {
        super(tipTheme, new Insets(5, 10, 10, 10));
        FileExplorer dirExplorer;
        this.container.setNorth(null);
        this.setMagnifyGaps(false);
        if (this.tabPane.getExtendedUI() != null) {
            this.tabPane.getExtendedUI().setTheme(settingsTheme);
        }
        this.scene = sc;
        FocusListener warning = new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                SettingsPanel.this.setError("settings.warning");
            }

            @Override
            public void focusLost(FocusEvent e) {
                SettingsPanel.this.setMessage(null);
            }
        };
        FocusListener restart = new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                SettingsPanel.this.setError("settings.restart");
            }

            @Override
            public void focusLost(FocusEvent e) {
                SettingsPanel.this.setMessage(null);
            }
        };
        this.minecraftTab = new TabbedEditorPanel.EditorPanelTab("settings.tab.minecraft");
        try {
            dirExplorer = FileExplorer.newExplorer();
            dirExplorer.setFileSelectionMode(1);
            dirExplorer.setFileHidingEnabled(false);
        }
        catch (Exception e2) {
            dirExplorer = null;
        }
        this.directory = new EditorFieldHandler("minecraft.gamedir", new EditorFileField("settings.client.gamedir.prompt", dirExplorer, false, false), warning);
        this.directory.addListener(new EditorFieldChangeListener(){

            @Override
            protected void onChange(String oldValue, String newValue) {
                if (SettingsPanel.this.ready) {
                    try {
                        SettingsPanel.this.tlauncher.getManager().getComponent(VersionLists.class).updateLocal();
                    }
                    catch (IOException var4) {
                        Alert.showLocError("settings.client.gamedir.noaccess", var4);
                        return;
                    }
                    SettingsPanel.this.tlauncher.getVersionManager().asyncRefresh();
                    SettingsPanel.this.tlauncher.getProfileManager().recreate();
                }
            }
        });
        this.useSeparateDir = new EditorFieldHandler("minecraft.gamedir.separate", new EditorComboBox<Configuration.SeparateDirs>(new SeparateDirsConverter(true), Configuration.SeparateDirs.values()));
        this.minecraftTab.add(new EditorPair("settings.client.gamedir.label", this.directory, this.useSeparateDir));
        this.resolution = new EditorFieldHandler("minecraft.size", new EditorResolutionField("settings.client.resolution.width", "settings.client.resolution.height", this.global.getDefaultClientWindowSize(), false));
        this.fullscreen = new EditorFieldHandler("minecraft.fullscreen", new EditorCheckBox("settings.client.resolution.fullscreen"));
        this.minecraftTab.add(new EditorPair("settings.client.resolution.label", this.resolution, this.fullscreen));
        this.minecraftTab.nextPane();
        List<ReleaseType> releaseTypes = ReleaseType.getDefinable();
        ArrayList<EditorHandler> versions = new ArrayList<EditorHandler>(releaseTypes.size());
        versions.add(new EditorFieldHandler("minecraft.versions.sub." + (Object)((Object)ReleaseType.SubType.REMOTE), new EditorCheckBox("settings.versions.sub." + (Object)((Object)ReleaseType.SubType.REMOTE))));
        versions.add(EditorPair.NEXT_COLUMN);
        for (int i = 0; i < releaseTypes.size(); ++i) {
            ReleaseType imgExplorer = releaseTypes.get(i);
            versions.add(new EditorFieldHandler("minecraft.versions." + (Object)((Object)imgExplorer), new EditorCheckBox("settings.versions." + (Object)((Object)imgExplorer))));
            if (i % 2 != 1) continue;
            versions.add(EditorPair.NEXT_COLUMN);
        }
        this.oldVersionsHandler = new EditorFieldHandler("minecraft.versions.sub." + (Object)((Object)ReleaseType.SubType.OLD_RELEASE), new EditorCheckBox("settings.versions.sub." + (Object)((Object)ReleaseType.SubType.OLD_RELEASE)));
        versions.add(this.oldVersionsHandler);
        versions.add(new EditorFieldHandler("minecraft.versions.only-installed", new EditorCheckBox("settings.versions.only-installed")));
        this.versionHandler = new EditorGroupHandler(versions);
        this.versionHandler.addListener(new EditorFieldChangeListener(){

            @Override
            protected void onChange(String oldvalue, String newvalue) {
                TLauncher.getInstance().getVersionManager().updateVersionList();
            }
        });
        this.minecraftTab.add(new EditorPair("settings.versions.label", versions));
        this.minecraftTab.nextPane();
        this.jre = new EditorFieldHandler("minecraft.jre.type", new JREComboBox(this));
        this.minecraftTab.add(new EditorPair("settings.jre.type.label", this.jre));
        MemorySlider memorySlider = new MemorySlider(sc.loginForm.tlauncher.getMemoryAllocationService());
        this.minecraftTab.nextPane();
        this.memory = new EditorFieldHandler("minecraft.xmx", memorySlider, warning);
        this.minecraftTab.add(new EditorPair("settings.java.memory.label", this.memory));
        if (!this.tlauncher.getGpuManager().isEmpty()) {
            this.minecraftTab.nextPane();
            this.gpu = new EditorFieldHandler("minecraft.gpu", new GPUComboBox(this));
            this.minecraftTab.add(new EditorPair("settings.gpu.label", this.gpu));
        } else {
            this.gpu = null;
        }
        this.minecraftTab.nextPane();
        ArrayList<EditorHandler> extraHandlerList = new ArrayList<EditorHandler>();
        extraHandlerList.add(new EditorFieldHandler("ely.globally", new EditorCheckBox("settings.ely", true)));
        extraHandlerList.add(EditorPair.NEXT_COLUMN);
        extraHandlerList.add(new EditorFieldHandler("minecraft.servers.promoted.ingame", new EditorCheckBox("settings.promotion.ingame", true)));
        if (OS.LINUX.isCurrent()) {
            extraHandlerList.add(EditorPair.NEXT_COLUMN);
            extraHandlerList.add(new EditorFieldHandler("minecraft.gamemode", new EditorCheckBox("settings.gamemode", true)));
        }
        this.extraHandler = new EditorGroupHandler(extraHandlerList);
        this.minecraftTab.add(new EditorPair("settings.extra.label", extraHandlerList));
        this.minecraftTab.nextPane();
        this.add(this.minecraftTab);
        TabbedEditorPanel.EditorPanelTab tlauncherTab = new TabbedEditorPanel.EditorPanelTab("settings.tab.tlauncher");
        this.launcherResolution = new EditorFieldHandler("gui.size", new EditorResolutionField("settings.client.resolution.width", "settings.client.resolution.height", this.global.getDefaultLauncherWindowSize(), false));
        this.launcherResolution.addListener(new EditorFieldListener(){

            @Override
            protected void onChange(EditorHandler handler, String oldValue, String newValue) {
                if (SettingsPanel.this.ready) {
                    IntegerArray arr = IntegerArray.parseIntegerArray(newValue);
                    SettingsPanel.this.tlauncher.getFrame().setSize(arr.get(0), arr.get(1));
                }
            }
        });
        tlauncherTab.add(new EditorPair("settings.clientres.label", this.launcherResolution));
        this.font = new EditorFieldHandler("gui.font", new SettingsFontSlider(), restart);
        tlauncherTab.add(new EditorPair("settings.fontsize.label", this.font));
        this.loginFormDirection = new EditorFieldHandler("gui.direction.loginform", new EditorComboBox<Direction>(new DirectionConverter(), Direction.values()));
        this.loginFormDirection.addListener(new EditorFieldChangeListener(){

            @Override
            protected void onChange(String oldValue, String newValue) {
                if (SettingsPanel.this.ready) {
                    SettingsPanel.this.tlauncher.getFrame().mp.defaultScene.updateDirection();
                }
            }
        });
        tlauncherTab.add(new EditorPair("settings.direction.label", this.loginFormDirection));
        this.laf = new EditorFieldHandler("gui.laf.v1.state", new EditorComboBox<String>(new LocalizableStringConverter<String>("settings.laf.state"){

            @Override
            protected String toPath(String var1) {
                return var1;
            }

            @Override
            public String fromString(String var1) {
                return var1;
            }

            @Override
            public String toValue(String var1) {
                return var1;
            }

            @Override
            public Class<String> getObjectClass() {
                return String.class;
            }
        }, this.getLafStates()));
        this.laf.addListener(new EditorFieldChangeListener(){

            @Override
            protected void onChange(String oldValue, String newValue) {
                if (SettingsPanel.this.ready && newValue != null) {
                    Alert.showLocWarning("", "settings.laf.restart", null);
                }
            }
        });
        tlauncherTab.add(new EditorPair("settings.laf.label", this.laf));
        boolean mediaFxAvailable = sc.getMainPane().background.getMediaFxBackground() != null;
        FilteredFileExplorer backgroundExplorer = null;
        try {
            backgroundExplorer = mediaFxAvailable ? MediaFileExplorer.newExplorer() : ImageFileExplorer.newExplorer();
        }
        catch (Exception e3) {
            LOGGER.warn("Could not load FileExplorer", (Throwable)e3);
        }
        this.background = new EditorFieldHandler("gui.background", new EditorFileField("settings.slide.list.prompt." + (mediaFxAvailable ? "media" : "image"), backgroundExplorer, true, true));
        this.background.addListener(new EditorFieldChangeListener(){

            @Override
            protected void onChange(String oldValue, String newValue) {
                if (SettingsPanel.this.ready) {
                    SettingsPanel.this.tlauncher.getFrame().mp.background.loadBackground();
                }
            }
        });
        tlauncherTab.add(new EditorPair("settings.slide.list.label", this.background));
        tlauncherTab.nextPane();
        this.logger = new EditorFieldHandler("gui.logger", new EditorComboBox<Configuration.LoggerType>(new LoggerTypeConverter(), Configuration.LoggerType.values()));
        this.logger.addListener(new EditorFieldChangeListener(){

            @Override
            protected void onChange(String oldvalue, String newvalue) {
                if (newvalue != null) {
                    SettingsPanel.this.tlauncher.reloadLoggerUI();
                }
            }
        });
        tlauncherTab.add(new EditorPair("settings.logger.label", this.logger));
        this.fullCommand = new EditorFieldHandler("gui.logger.fullcommand", new EditorCheckBox("settings.logger.fullcommand"));
        tlauncherTab.add(new EditorPair("settings.logger.fullcommand.label", this.fullCommand));
        this.launchAction = new EditorFieldHandler("minecraft.onlaunch", new EditorComboBox<Configuration.ActionOnLaunch>(new ActionOnLaunchConverter(), Configuration.ActionOnLaunch.values()));
        tlauncherTab.add(new EditorPair("settings.launch-action.label", this.launchAction));
        this.crashManager = new EditorFieldHandler("minecraft.crash", new EditorCheckBox("settings.crash.enable"));
        tlauncherTab.add(new EditorPair("settings.crash.label", this.crashManager));
        tlauncherTab.nextPane();
        ArrayList<EditorHandler> defReleaseTypeHandlers = new ArrayList<EditorHandler>();
        for (ReleaseType releaseType : new ReleaseType[]{ReleaseType.RELEASE, ReleaseType.SNAPSHOT, ReleaseType.MODIFIED}) {
            defReleaseTypeHandlers.add(new EditorFieldHandler("gui.alerton." + (Object)((Object)releaseType), new EditorCheckBox("settings.alert-on." + (Object)((Object)releaseType))));
            defReleaseTypeHandlers.add(EditorPair.NEXT_COLUMN);
        }
        this.alertUpdates = new EditorGroupHandler(defReleaseTypeHandlers);
        tlauncherTab.add(new EditorPair("settings.alert-on.label", defReleaseTypeHandlers));
        tlauncherTab.nextPane();
        this.allowNoticeDisable = new EditorFieldHandler("notice.enabled", new EditorCheckBox("notice.enable"));
        this.allowNoticeDisable.addListener(new EditorFieldChangeListener(){

            @Override
            protected void onChange(String oldValue, String newValue) {
                if (SettingsPanel.this.ready) {
                    Stats.noticeStatusUpdated(Boolean.parseBoolean(newValue));
                    SettingsPanel.this.tlauncher.getFrame().getNotices().selectRandom();
                    Alert.showLocMessage("notice.enable.alert." + newValue);
                }
            }
        });
        tlauncherTab.add(new EditorPair("notice.enable.label", this.allowNoticeDisable));
        tlauncherTab.nextPane();
        this.switchToBeta = new EditorFieldHandler("bootstrap.switchToBeta", new EditorCheckBox("settings.switch-to-beta"));
        this.switchToBeta.addListener(new EditorFieldChangeListener(){

            @Override
            protected void onChange(String oldValue, String newValue) {
                if (SettingsPanel.this.ready) {
                    Alert.showMessage("", Localizable.get("settings.restart"));
                }
            }
        });
        Optional<Boolean> canSwitchToBetaBranch = TLauncher.getInstance().getCapability("can_switch_to_beta_branch", Boolean.class);
        if (canSwitchToBetaBranch.isPresent()) {
            tlauncherTab.add(new EditorPair("settings.switch-to-beta.label", this.switchToBeta));
            tlauncherTab.nextPane();
            if (!canSwitchToBetaBranch.filter(v -> v == Boolean.TRUE).isPresent()) {
                Blocker.block(this.switchToBeta, "cant_switch_to_beta_branch");
                this.switchToBeta.setPath(null);
                this.switchToBeta.setValue(true);
            }
        }
        this.locale = new EditorFieldHandler("locale", new SettingsLocaleComboBox(this));
        this.locale.addListener(new EditorFieldChangeListener(){

            @Override
            protected void onChange(String oldvalue, String newvalue) {
                if (SettingsPanel.this.ready) {
                    if (SettingsPanel.this.tlauncher.getFrame() != null) {
                        SettingsPanel.this.tlauncher.getFrame().updateLocales();
                    }
                    ContributorsAlert.showAlert();
                    SettingsPanel.this.hideUponSave = false;
                }
            }
        });
        tlauncherTab.add(new EditorPair("settings.lang.label", this.locale));
        this.add(tlauncherTab);
        TabbedEditorPanel.EditorPanelTab aboutTab = new TabbedEditorPanel.EditorPanelTab("settings.tab.about");
        aboutTab.setSavingEnabled(false);
        this.about = new HTMLPage("about.html");
        aboutTab.add((Component)this.about);
        this.add(aboutTab);
        LocalizableButton saveButton = new LocalizableButton("settings.save");
        saveButton.setFont(saveButton.getFont().deriveFont(1));
        saveButton.addActionListener(e -> {
            if (!this.saveValues()) {
                return;
            }
            if (this.hideUponSave) {
                this.scene.setSidePanel(null);
            } else {
                this.hideUponSave = true;
            }
        });
        LocalizableButton defaultButton = new LocalizableButton("settings.default");
        defaultButton.addActionListener(e -> {
            if (Alert.showLocQuestion("settings.default.warning")) {
                this.resetValues();
            }
        });
        ExtendedButton homeButton = new ExtendedButton();
        homeButton.setIcon(Images.getIcon24("home"));
        homeButton.addActionListener(e -> {
            this.updateValues();
            this.scene.setSidePanel(null);
        });
        Dimension size1 = homeButton.getPreferredSize();
        if (size1 != null) {
            homeButton.setPreferredSize(new Dimension(SwingUtil.magnify(40), size1.height));
        }
        this.buttonPanel = new BorderPanel();
        this.buttonPanel.setCenter(SettingsPanel.sepPan(saveButton, defaultButton));
        this.buttonPanel.setEast(SettingsPanel.uSepPan(homeButton));
        this.tabPane.addChangeListener(new ChangeListener(){
            private final String aboutBlock = "abouttab";

            @Override
            public void stateChanged(ChangeEvent e) {
                if (SettingsPanel.this.tabPane.getSelectedComponent() instanceof TabbedEditorPanel.EditorScrollPane && !((TabbedEditorPanel.EditorScrollPane)SettingsPanel.this.tabPane.getSelectedComponent()).getTab().getSavingEnabled()) {
                    Blocker.blockComponents("abouttab", SettingsPanel.this.buttonPanel);
                } else {
                    Blocker.unblockComponents("abouttab", SettingsPanel.this.buttonPanel);
                }
            }
        });
        this.container.setSouth(this.buttonPanel);
        this.popup = new JPopupMenu();
        this.infoItem = new LocalizableMenuItem("settings.popup.info");
        this.infoItem.setEnabled(false);
        this.popup.add(this.infoItem);
        this.defaultItem = new LocalizableMenuItem("settings.popup.default");
        this.defaultItem.addActionListener(e -> {
            if (this.selectedHandler != null) {
                this.resetValue(this.selectedHandler);
            }
        });
        this.popup.add(this.defaultItem);
        for (final EditorHandler handler : this.handlers) {
            JComponent handlerComponent = handler.getComponent();
            if (handlerComponent == null) continue;
            handlerComponent.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getButton() == 3) {
                        SettingsPanel.this.callPopup(e, handler);
                    }
                }
            });
        }
        this.updateValues();
        this.updateLocale();
    }

    private String[] getLafStates() {
        if (!FlatLaf.getStates().isEmpty()) {
            return FlatLaf.getStates().toArray(new String[0]);
        }
        String existingValue = this.tlauncher.getSettings().get("gui.laf.v1.state");
        if (existingValue != null) {
            return new String[]{existingValue};
        }
        return new String[]{null};
    }

    public void updateValues() {
        boolean globalUnSaveable = !this.global.isSaveable();
        Iterator iterator = this.handlers.iterator();
        if (!this.tlauncher.isNoticeDisablingAllowed()) {
            this.allowNoticeDisable.getComponent().setEnabled(false);
        }
        while (iterator.hasNext()) {
            EditorHandler handler = (EditorHandler)iterator.next();
            String path = handler.getPath();
            if (path != null) {
                String value = this.global.get(path);
                handler.updateValue(value);
                this.setValid(handler, true);
            }
            if (!globalUnSaveable && this.global.isSaveable(path)) continue;
            Blocker.block(handler, "unsaveable");
        }
        return;
    }

    public boolean saveValues() {
        if (!this.checkValues()) {
            return false;
        }
        for (EditorHandler handler : this.handlers) {
            String path = handler.getPath();
            if (path == null) continue;
            String value = handler.getValue();
            this.global.set(path, value, false);
            handler.onChange(value);
        }
        this.global.store();
        this.updateValues();
        return true;
    }

    void resetValues() {
        for (EditorHandler handler : this.handlers) {
            this.resetValue(handler);
        }
    }

    void resetValue(EditorHandler handler) {
        String path = handler.getPath();
        if (this.global.isSaveable(path)) {
            String value = this.global.getDefault(path);
            handler.setValue(value);
        }
    }

    boolean canReset(EditorHandler handler) {
        String key = handler.getPath();
        return this.global.isSaveable(key) && this.global.getDefault(handler.getPath()) != null;
    }

    void callPopup(MouseEvent e, EditorHandler handler) {
        if (this.popup.isShowing()) {
            this.popup.setVisible(false);
        }
        this.defocus();
        int x = e.getX();
        int y = e.getY();
        this.selectedHandler = handler;
        this.updateResetMenu();
        this.infoItem.setVariables(handler.getPath());
        this.popup.show((JComponent)e.getSource(), x, y);
    }

    @Override
    public void block(Object reason) {
        Blocker.blockComponents(this.minecraftTab, reason);
        this.updateResetMenu();
    }

    @Override
    public void unblock(Object reason) {
        Blocker.unblockComponents(this.minecraftTab, reason);
        this.updateResetMenu();
    }

    private void updateResetMenu() {
        if (this.selectedHandler != null) {
            this.defaultItem.setEnabled(!Blocker.isBlocked(this.selectedHandler));
        }
    }

    @Override
    public void logginingIn() throws LoginException {
        boolean ok = !this.tlauncher.getSettings().isFirstRun() && this.anyChanges() ? this.askToSaveChanges() : this.checkValues();
        if (!ok) {
            this.scene.setSidePanel(DefaultScene.SidePanel.SETTINGS);
            throw new LoginException("Invalid settings!");
        }
    }

    @Override
    public void loginFailed() {
    }

    @Override
    public void loginSucceed() {
    }

    @Override
    public void updateLocale() {
    }

    private boolean anyChanges() {
        for (EditorHandler handler : this.handlers) {
            String existingValue;
            String value;
            String path = handler.getPath();
            if (path == null || Objects.equals(value = handler.getValue(), existingValue = this.global.get(path))) continue;
            LOGGER.debug("Found changes: {}", (Object)path);
            return true;
        }
        return false;
    }

    private boolean askToSaveChanges() {
        if (Alert.showQuestion("", Localizable.get("settings.changed.confirm"))) {
            if (!this.saveValues()) {
                return false;
            }
        } else {
            this.updateValues();
        }
        this.scene.setSidePanel(null);
        return true;
    }
}

