/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.settings;

import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Locale;
import ru.turikhay.tlauncher.configuration.LangConfiguration;
import ru.turikhay.tlauncher.ui.converter.LocaleConverter;
import ru.turikhay.tlauncher.ui.editor.EditorComboBox;
import ru.turikhay.tlauncher.ui.editor.EditorField;
import ru.turikhay.tlauncher.ui.loc.LocalizableComponent;
import ru.turikhay.tlauncher.ui.settings.SettingsPanel;
import ru.turikhay.tlauncher.ui.swing.extended.BorderPanel;
import ru.turikhay.tlauncher.ui.swing.extended.ExtendedLabel;
import ru.turikhay.util.OS;

public class SettingsLocaleComboBox
extends BorderPanel
implements EditorField,
LocalizableComponent {
    final SettingsPanel panel;
    final EditorComboBox<Locale> comboBox;
    final ExtendedLabel hint;
    private static final String CONTRIBUTE_PATH = "settings.lang.contribute";

    public SettingsLocaleComboBox(SettingsPanel panel) {
        this.panel = panel;
        this.comboBox = new EditorComboBox<Locale>(new LocaleConverter(), LangConfiguration.getAvailableLocales().toArray(new Locale[0]));
        this.setCenter(this.comboBox);
        this.hint = new ExtendedLabel();
        this.hint.setFont(this.hint.getFont().deriveFont((float)this.hint.getFont().getSize() - 2.0f));
        this.hint.setCursor(Cursor.getPredefinedCursor(12));
        this.hint.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                OS.openLink("https://llaun.ch/l10n");
            }
        });
        this.setSouth(this.hint);
        this.updateLocale();
    }

    @Override
    public String getSettingsValue() {
        return this.comboBox.getSettingsValue();
    }

    @Override
    public void setSettingsValue(String var1) {
        this.comboBox.setSettingsValue(var1);
    }

    @Override
    public boolean isValueValid() {
        return this.comboBox.isValueValid();
    }

    @Override
    public void block(Object var1) {
        this.comboBox.setEnabled(false);
        this.hint.setEnabled(false);
    }

    @Override
    public void unblock(Object var1) {
        this.comboBox.setEnabled(true);
        this.hint.setEnabled(true);
    }

    @Override
    public void updateLocale() {
        String locale = this.panel.lang.getLocale().toString();
        this.hint.setVisible(!locale.equals("ru_RU") && !locale.equals("uk_UA"));
        String hintLocalized = this.panel.lang.get(CONTRIBUTE_PATH);
        this.hint.setText("<html>" + hintLocalized + "</html>");
    }
}

