/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.settings;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Hashtable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.minecraft.launcher.updater.VersionSyncInfo;
import net.minecraft.launcher.versions.Version;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.tlauncher.TLauncher;
import ru.turikhay.tlauncher.managers.MemoryAllocationService;
import ru.turikhay.tlauncher.ui.block.Blocker;
import ru.turikhay.tlauncher.ui.editor.EditorField;
import ru.turikhay.tlauncher.ui.images.ImageIcon;
import ru.turikhay.tlauncher.ui.images.Images;
import ru.turikhay.tlauncher.ui.loc.LocalizableCheckbox;
import ru.turikhay.tlauncher.ui.loc.LocalizableComponent;
import ru.turikhay.tlauncher.ui.loc.LocalizableHTMLLabel;
import ru.turikhay.tlauncher.ui.loc.LocalizableLabel;
import ru.turikhay.tlauncher.ui.swing.extended.ExtendedPanel;
import ru.turikhay.util.Lazy;
import ru.turikhay.util.SwingUtil;
import ru.turikhay.util.async.AsyncThread;

public class MemorySlider
extends ExtendedPanel
implements EditorField,
LocalizableComponent {
    private static final Logger LOGGER = LogManager.getLogger(MemorySlider.class);
    private final Lazy<ImageIcon> warningIcon = Images.getIcon16Lazy("warning");
    private final Lazy<ImageIcon> infoIcon = Images.getIcon16Lazy("info-circle");
    private final Lazy<ImageIcon> waitingIcon = Images.getIcon16Lazy("hourglass-start");
    private final Lazy<ImageIcon> questionIcon = Images.getIcon16Lazy("question");
    private final MemoryAllocationService service;
    private final JTextField inputField;
    private final Slider slider;
    private final LocalizableCheckbox autoCheckbox;
    private final LocalizableHTMLLabel statusLabel;
    private int value;
    private int savedManualValue;
    private boolean auto;
    private final AtomicInteger requestId = new AtomicInteger();
    private boolean isFocusingOnAutoCheckbox;

    public MemorySlider(MemoryAllocationService service) {
        this.service = service;
        this.setLayout(new GridBagLayout());
        this.inputField = new JTextField();
        this.inputField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                char c;
                if (MemorySlider.this.inputField.getSelectionStart() == 0 && MemorySlider.this.inputField.getSelectionEnd() == MemorySlider.this.inputField.getDocument().getLength()) {
                    MemorySlider.this.inputField.setText("");
                }
                if ((c = e.getKeyChar()) != '\uffff') {
                    MemorySlider.this.inputField.setCaretPosition(MemorySlider.this.inputField.getDocument().getLength());
                    if (c < '0' || c > '9') {
                        UIManager.getLookAndFeel().provideErrorFeedback(MemorySlider.this.inputField);
                        e.consume();
                    }
                }
            }
        });
        this.inputField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (MemorySlider.this.inputField.isEditable()) {
                    MemorySlider.this.inputField.selectAll();
                }
            }
        });
        this.autoCheckbox = new LocalizableCheckbox("settings.java.memory.auto");
        this.statusLabel = new LocalizableHTMLLabel();
        this.statusLabel.setIconTextGap(8);
        this.statusLabel.setLabelWidth(400);
        this.resetStatus();
        this.slider = new Slider();
        this.slider.addChangeListener(e -> {
            if (this.slider.getValue() == this.value) {
                return;
            }
            if (this.auto) {
                this.slider.setValue(this.value);
                UIManager.getLookAndFeel().provideErrorFeedback(this.slider);
                this.autoCheckbox.requestFocusInWindow();
                this.makeFocusOnAutoCheckbox();
            } else {
                this.value = this.slider.getValue();
                this.inputField.setText(String.valueOf(this.value));
                this.updateManualStatus();
            }
        });
        this.slider.setOpaque(false);
        this.slider.setMinimum(service.getRange().getMin());
        this.slider.setMaximum(service.getRange().getMax());
        this.slider.setMajorTickSpacing(service.getMemoryInfo().getBase());
        this.slider.setSnapToTicks(true);
        this.slider.setPaintLabels(true);
        this.slider.setPaintTicks(true);
        this.slider.updateLocale();
        this.add((Component)this.slider, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 8, 8, 12), 0, 0));
        ExtendedPanel sidePanel = new ExtendedPanel();
        sidePanel.setLayout(new GridBagLayout());
        ((GridBagLayout)sidePanel.getLayout()).columnWidths = new int[]{0, 0};
        ((GridBagLayout)sidePanel.getLayout()).rowHeights = new int[]{0, 0, 0};
        ((GridBagLayout)sidePanel.getLayout()).columnWeights = new double[]{0.0, 1.0E-4};
        ((GridBagLayout)sidePanel.getLayout()).rowWeights = new double[]{0.0, 0.0, 1.0E-4};
        ExtendedPanel inputPanel = new ExtendedPanel();
        inputPanel.setLayout(new FlowLayout());
        this.inputField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                int currentValue;
                if (MemorySlider.this.auto) {
                    return;
                }
                try {
                    currentValue = Integer.parseInt(MemorySlider.this.inputField.getText());
                }
                catch (NumberFormatException ignored) {
                    return;
                }
                if (currentValue == MemorySlider.this.value) {
                    return;
                }
                MemorySlider.this.value = currentValue;
                MemorySlider.this.slider.setSnapToTicks(false);
                MemorySlider.this.slider.setValue(MemorySlider.this.value);
                MemorySlider.this.updateManualStatus();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.inputField.setColumns(4);
        inputPanel.add((Component)this.inputField);
        inputPanel.add((Component)new LocalizableLabel("settings.java.memory.unit.mib"));
        sidePanel.add((Component)inputPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.autoCheckbox.addActionListener(e -> {
            boolean active = this.autoCheckbox.getModel().isSelected();
            if (this.auto == active) {
                return;
            }
            if (active) {
                this.savedManualValue = this.value;
                this.setAuto();
            } else {
                if (this.savedManualValue == 0) {
                    this.savedManualValue = this.value;
                }
                this.setManual(this.savedManualValue);
            }
        });
        sidePanel.add((Component)this.autoCheckbox, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 3, 0, 0), 0, 0));
        this.add((Component)sidePanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 8, 0), 0, 0));
        this.add((Component)this.statusLabel, new GridBagConstraints(0, 1, 0, 1, 0.0, 0.0, 10, 1, new Insets(0, 8, 0, 0), 0, 0));
    }

    @Override
    public String getSettingsValue() {
        return this.auto ? "auto" : String.valueOf(this.inputField.getText());
    }

    @Override
    public void setSettingsValue(String value) {
        int xmx;
        if ("auto".equals(value)) {
            this.setAuto();
            return;
        }
        try {
            xmx = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            LOGGER.warn("Setting to auto mode. Bad value passed: {}", (Object)value, (Object)e);
            this.setAuto();
            return;
        }
        this.setManual(xmx);
    }

    private void setAuto() {
        this.requestId.incrementAndGet();
        this.auto = true;
        this.autoCheckbox.setSelected(true);
        this.inputField.setEditable(false);
        this.resetStatus();
        if (TLauncher.getInstance().isReady()) {
            this.updateForCurrentlySelectedVersion();
        }
    }

    private void updateManualStatus() {
        int currentValue;
        if (this.auto) {
            return;
        }
        try {
            currentValue = Integer.parseInt(this.inputField.getText());
        }
        catch (NumberFormatException ignored) {
            currentValue = -1;
        }
        if (currentValue < this.service.getRange().getMin() || currentValue > this.service.getRange().getMax()) {
            this.setStatus(this.warningIcon, "settings.java.memory.status.manual.invalid-input", new Object[0]);
            return;
        }
        if (currentValue > this.service.getMemoryInfo().getSafeMax()) {
            this.setStatus(this.infoIcon, "settings.java.memory.status.manual.high-amount", new Object[0]);
            return;
        }
        this.resetStatus();
    }

    private void setManual(int xmx) {
        this.requestId.incrementAndGet();
        this.auto = false;
        this.value = xmx;
        this.autoCheckbox.setSelected(false);
        this.inputField.setEditable(true);
        this.inputField.setText(String.valueOf(xmx));
        this.slider.setValue(xmx);
        this.resetStatus();
    }

    public void updateForCurrentlySelectedVersion() {
        if (!this.auto) {
            return;
        }
        int id = this.requestId.incrementAndGet();
        VersionSyncInfo version = TLauncher.getInstance().getFrame().mp.defaultScene.loginForm.versions.getVersion();
        if (version == null) {
            return;
        }
        AsyncThread.execute(() -> {
            MemoryAllocationService.Hint hint = null;
            ExecutionException error = null;
            Version availableVersion = version.getAvailableVersion();
            String versionId = version.getAvailableVersion().getID();
            Future<MemoryAllocationService.Hint> hintFuture = this.service.queryHint(new MemoryAllocationService.VersionContext(availableVersion, null));
            try {
                hint = hintFuture.get(500L, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                boolean shouldContinue = SwingUtil.waitAndReturn(() -> {
                    if (this.requestId.get() != id) {
                        return false;
                    }
                    this.setStatus(this.waitingIcon, "settings.java.memory.status.querying", versionId);
                    return true;
                });
                if (!shouldContinue) {
                    hintFuture.cancel(true);
                    return;
                }
            }
            catch (ExecutionException e) {
                error = e;
            }
            catch (InterruptedException e) {
                return;
            }
            if (hint == null && error == null) {
                try {
                    hint = hintFuture.get();
                }
                catch (InterruptedException e) {
                    return;
                }
                catch (ExecutionException e) {
                    error = e;
                }
            }
            MemoryAllocationService.Hint _hint = hint;
            ExecutionException _error = error;
            SwingUtil.later(() -> this.hintCallback(id, versionId, _hint, _error));
        });
    }

    private void hintCallback(int id, String versionId, MemoryAllocationService.Hint hint, Throwable error) {
        if (this.requestId.get() != id) {
            return;
        }
        if (error != null) {
            LOGGER.error("Couldn't request memory hint", error);
            this.setStatus(this.warningIcon, "settings.java.memory.status.error", new Object[0]);
            return;
        }
        this.value = hint.getActual();
        this.slider.setValue(hint.getActual());
        this.inputField.setText(String.valueOf(hint.getActual()));
        if (hint.isUnderAllocation()) {
            this.setStatus(this.warningIcon, "settings.java.memory.status.result.under-allocation", versionId, hint.getDesired());
            return;
        }
        this.setStatus(hint.isConfident() ? this.infoIcon : this.questionIcon, "settings.java.memory.status.result." + (hint.isConfident() ? "" : "un") + "confident", versionId);
    }

    @Override
    public boolean isValueValid() {
        if (this.autoCheckbox.isSelected()) {
            return true;
        }
        try {
            Integer.parseInt(this.inputField.getText());
        }
        catch (NumberFormatException ignored) {
            return false;
        }
        return true;
    }

    @Override
    public void block(Object var1) {
        Blocker.blockComponents(this, var1);
    }

    @Override
    public void unblock(Object var1) {
        Blocker.unblockComponents(this, var1);
    }

    private void makeFocusOnAutoCheckbox() {
        if (this.isFocusingOnAutoCheckbox) {
            return;
        }
        this.isFocusingOnAutoCheckbox = true;
        Font normalFont = this.autoCheckbox.getFont();
        AsyncThread.execute(() -> {
            for (int i = 0; i < 4; ++i) {
                SwingUtilities.invokeLater(() -> this.autoCheckbox.setFont(normalFont.deriveFont(1)));
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                SwingUtilities.invokeLater(() -> this.autoCheckbox.setFont(normalFont));
                try {
                    Thread.sleep(500L);
                    continue;
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            SwingUtilities.invokeLater(() -> {
                this.isFocusingOnAutoCheckbox = false;
            });
        });
    }

    private void setStatus(Lazy<ImageIcon> icon, String text, Object ... vars) {
        this.statusLabel.setIcon(icon == null ? null : icon.get());
        if (text == null) {
            this.statusLabel.setText("<br/><br/>");
        } else {
            this.statusLabel.setText(text, vars);
        }
    }

    private void resetStatus() {
        this.setStatus(null, null, new Object[0]);
    }

    @Override
    public void updateLocale() {
        this.slider.updateLocale();
    }

    private static class Slider
    extends JSlider
    implements LocalizableComponent {
        private Slider() {
        }

        private Hashtable<Integer, JComponent> createLabelTable() {
            int step = this.getMaximum() >= 4000 ? (int)(Math.round((double)this.getMaximum() / 4.0 / 1024.0) * 1024L) : 512;
            Hashtable<Integer, JComponent> table = new Hashtable<Integer, JComponent>();
            table.put(this.getMinimum(), this.createLabel(this.getMinimum()));
            for (int i = step; i <= this.getMaximum() - step / 2; i += step) {
                table.put(i, this.createLabel(i));
            }
            table.put(this.getMaximum(), this.createLabel(this.getMaximum()));
            return table;
        }

        private JLabel createLabel(int unit) {
            if (unit >= 1000 && unit % 1024 != 512) {
                return new LocalizableLabel("settings.java.memory.unit.gib.tick", String.valueOf(Math.round((double)unit / 1024.0)));
            }
            return new LocalizableLabel("settings.java.memory.unit.mib.tick", String.valueOf(unit));
        }

        @Override
        public void updateLocale() {
            this.setLabelTable(this.createLabelTable());
        }
    }
}

