/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.settings;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import ru.turikhay.util.JavaVersion;
import ru.turikhay.util.JavaVersionDetector;
import ru.turikhay.util.SwingUtil;
import ru.turikhay.util.async.AsyncThread;

public class JavaVersionDetectorCache {
    private final Map<String, Future<JavaVersion>> taskCache = new HashMap<String, Future<JavaVersion>>();
    private final Runnable callback;

    public JavaVersionDetectorCache(Runnable callback) {
        this.callback = callback;
    }

    public synchronized Future<JavaVersion> get(String javaExec) {
        return this.taskCache.computeIfAbsent(javaExec, this::createTask);
    }

    private Future<JavaVersion> createTask(String javaExec) {
        return AsyncThread.future(new Task(this.callback, javaExec));
    }

    private static class Task
    implements Callable<JavaVersion> {
        private final Runnable callback;
        private final String javaExec;

        private Task(Runnable callback, String javaExec) {
            this.callback = callback;
            this.javaExec = javaExec;
        }

        @Override
        public JavaVersion call() throws Exception {
            try {
                JavaVersionDetector detector = new JavaVersionDetector(this.javaExec);
                JavaVersion javaVersion = detector.detect();
                return javaVersion;
            }
            finally {
                SwingUtil.laterRunnable(this.callback);
            }
        }
    }
}

