/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.settings;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.event.DocumentEvent;
import net.minecraft.launcher.updater.VersionSyncInfo;
import net.minecraft.launcher.versions.CompleteVersion;
import ru.turikhay.tlauncher.TLauncher;
import ru.turikhay.tlauncher.jre.JavaRuntimeLocal;
import ru.turikhay.tlauncher.managers.JavaManagerConfig;
import ru.turikhay.tlauncher.ui.editor.EditorFileField;
import ru.turikhay.tlauncher.ui.explorer.FileExplorer;
import ru.turikhay.tlauncher.ui.images.Images;
import ru.turikhay.tlauncher.ui.loc.Localizable;
import ru.turikhay.tlauncher.ui.loc.LocalizableButton;
import ru.turikhay.tlauncher.ui.loc.LocalizableCheckbox;
import ru.turikhay.tlauncher.ui.loc.LocalizableComponent;
import ru.turikhay.tlauncher.ui.loc.LocalizableHTMLLabel;
import ru.turikhay.tlauncher.ui.loc.LocalizableLabel;
import ru.turikhay.tlauncher.ui.loc.LocalizableRadioButton;
import ru.turikhay.tlauncher.ui.loc.LocalizableTextField;
import ru.turikhay.tlauncher.ui.settings.JREComboBox;
import ru.turikhay.tlauncher.ui.swing.DocumentChangeListener;
import ru.turikhay.tlauncher.ui.swing.extended.BorderPanel;
import ru.turikhay.tlauncher.ui.swing.extended.ExtendedFrame;
import ru.turikhay.tlauncher.ui.swing.extended.ExtendedPanel;
import ru.turikhay.tlauncher.ui.theme.Theme;
import ru.turikhay.util.JavaVersion;
import ru.turikhay.util.OS;
import ru.turikhay.util.SwingUtil;
import ru.turikhay.util.async.AsyncThread;

public class JRESettingsWindow
extends ExtendedFrame
implements LocalizableComponent {
    private static final int WIDTH = SwingUtil.magnify(450);
    private static final int HALF_WIDTH = SwingUtil.magnify(300);
    private final JREComboBox comboBox;
    private final LocalizableRadioButton recommendedRadioButton;
    private final LocalizableRadioButton currentRadioButton;
    private final LocalizableRadioButton customRadioButton;
    private final ExtendedPanel pathPanel;
    private final CardLayout pathCards;
    private final EditorFileField customPathField;
    private final LocalizableLabel customPathHint;
    private final LocalizableLabel recommendedPathHint0;
    private final LocalizableTextField recommendedPathField;
    private final LocalizableHTMLLabel pathMessage;
    private final LocalizableTextField jvmArgsField;
    private final LocalizableTextField mcArgsField;
    private final LocalizableCheckbox useOptimizedArgsCheckbox;
    private final LocalizableLabel settingsSavedLabel;
    private boolean saveValues;
    private final AtomicInteger saveCount = new AtomicInteger();

    public JRESettingsWindow(JREComboBox comboBox) {
        this.comboBox = comboBox;
        this.setResizable(false);
        this.setAlwaysOnTop(true);
        ExtendedPanel p = new ExtendedPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.setBorder(BorderFactory.createEmptyBorder(SwingUtil.magnify(20), SwingUtil.magnify(20), SwingUtil.magnify(20), SwingUtil.magnify(20)));
        this.setContentPane(p);
        this.addLabel("select", "check-circle-o");
        this.recommendedRadioButton = this.addType("recommended", WIDTH);
        this.recommendedRadioButton.addActionListener(e -> this.onRecommended());
        this.currentRadioButton = this.addType("current", WIDTH);
        this.currentRadioButton.addActionListener(e -> this.onCurrent());
        this.customRadioButton = this.addType("custom", WIDTH);
        this.customRadioButton.addActionListener(e -> this.onCustom());
        ButtonGroup group = new ButtonGroup();
        group.add(this.recommendedRadioButton);
        group.add(this.currentRadioButton);
        group.add(this.customRadioButton);
        this.add(Box.createRigidArea(new Dimension(1, SwingUtil.magnify(20))));
        this.add(new JSeparator(0));
        this.add(Box.createRigidArea(new Dimension(1, SwingUtil.magnify(20))));
        this.addLabel("configure", "gear");
        ExtendedPanel cfgs = new ExtendedPanel();
        cfgs.setAlignmentX(0.0f);
        GridBagConstraints c = new GridBagConstraints();
        cfgs.setLayout(new GridBagLayout());
        c.gridx = 0;
        cfgs.add(Box.createRigidArea(new Dimension(1, 1)), c);
        c.gridx = 1;
        cfgs.add(Box.createRigidArea(new Dimension(SwingUtil.magnify(HALF_WIDTH), 1)), c);
        this.pathPanel = new ExtendedPanel();
        this.pathPanel.setAlignmentX(0.0f);
        this.pathCards = new CardLayout();
        this.pathPanel.setLayout(this.pathCards);
        LocalizableTextField currentPathField = this.initCurrentPath();
        this.customPathHint = this.createCustomPathHint();
        this.customPathField = this.initCustomPath();
        this.recommendedPathHint0 = this.createRecommendedPathHint();
        this.recommendedPathField = this.initRecommendedPath();
        this.pathMessage = this.initPathMessage();
        this.addConfig(cfgs, c, "path", this.pathPanel, 23);
        this.jvmArgsField = this.createJvmArgsField();
        this.useOptimizedArgsCheckbox = this.createUseOptimizedArgsCheckbox();
        this.initJvmArgs(cfgs, c);
        this.mcArgsField = this.addConfig(cfgs, c, "mc-args");
        this.add(cfgs);
        this.add(Box.createRigidArea(new Dimension(1, SwingUtil.magnify(20))));
        this.add(new JSeparator(0));
        this.add(Box.createRigidArea(new Dimension(1, SwingUtil.magnify(20))));
        this.settingsSavedLabel = new LocalizableLabel("settings.jre.window.bottom.save");
        this.settingsSavedLabel.setIcon(Images.getIcon16("save-1").getDisabledInstance());
        this.settingsSavedLabel.setIconTextGap(SwingUtil.magnify(15));
        this.settingsSavedLabel.setForeground(Theme.getTheme().getSemiForeground());
        this.settingsSavedLabel.setVisible(false);
        LocalizableButton closeButton = new LocalizableButton("settings.jre.window.bottom.close");
        closeButton.setPreferredSize(new Dimension(HALF_WIDTH / 2, SwingUtil.magnify(40)));
        closeButton.addActionListener(e -> this.dispose());
        BorderPanel bottomPanel = new BorderPanel();
        bottomPanel.setAlignmentX(0.0f);
        bottomPanel.setWest(this.settingsSavedLabel);
        bottomPanel.setEast(closeButton);
        this.add(bottomPanel);
        this.pack();
    }

    void showSettingsWindow() {
        this.updateLocale();
        this.updateSelfValues();
        super.showAtCenter();
    }

    void selectedVersionChanged(VersionSyncInfo versionSyncInfo) {
        if (this.recommendedRadioButton.isSelected()) {
            this.onRecommended();
        }
    }

    void javaVersionCallback() {
        JavaVersion javaVersion;
        String settingsValue = this.customPathField.getSettingsValue();
        Future<JavaVersion> f = this.comboBox.javaVersionCache.get(settingsValue);
        if (!f.isDone()) {
            return;
        }
        try {
            javaVersion = f.get();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return;
        }
        catch (ExecutionException e) {
            this.setCustomPathHint(true, "settings.jre.window.configure.path.custom.hint.version.error", new Object[0]);
            return;
        }
        this.setCustomPathHint(false, "settings.jre.window.configure.path.custom.hint.version.detected", javaVersion.getVersion());
    }

    private void updateSelfValues() {
        this.saveValues = false;
        JavaManagerConfig.JreType jreType = JavaManagerConfig.createByType(this.comboBox.sp.jre.getValue());
        if (jreType instanceof JavaManagerConfig.Recommended) {
            this.recommendedRadioButton.doClick();
        } else if (jreType instanceof JavaManagerConfig.Current) {
            this.currentRadioButton.doClick();
        } else if (jreType instanceof JavaManagerConfig.Custom) {
            this.customRadioButton.doClick();
        } else {
            throw new RuntimeException("unknown jreType");
        }
        JavaManagerConfig javaManagerConfig = this.comboBox.sp.global.get(JavaManagerConfig.class);
        this.useOptimizedArgsCheckbox.setSelected(javaManagerConfig.useOptimizedArguments());
        this.jvmArgsField.setValue((Object)javaManagerConfig.getArgs().orElse(null));
        this.mcArgsField.setValue((Object)javaManagerConfig.getMinecraftArgs().orElse(null));
        this.saveValues = true;
    }

    private void saveSelfValues() {
        if (!this.saveValues) {
            return;
        }
        JavaManagerConfig javaManagerConfigOld = this.comboBox.sp.global.get(JavaManagerConfig.class);
        JavaManagerConfig javaManagerConfig = this.comboBox.sp.global.get(JavaManagerConfig.class);
        javaManagerConfig.setArgs(this.jvmArgsField.getValue());
        javaManagerConfig.setMcArgs(this.mcArgsField.getValue());
        javaManagerConfig.setUseOptimizedArguments(this.useOptimizedArgsCheckbox.isSelected());
        if (!javaManagerConfigOld.equals(javaManagerConfig)) {
            this.comboBox.sp.global.set(javaManagerConfig);
            this.onValuesSaved();
        }
    }

    private void onValuesSaved() {
        int saveCount = this.saveCount.incrementAndGet();
        AsyncThread.execute(() -> {
            SwingUtil.later(() -> this.settingsSavedLabel.setVisible(true));
            Thread.sleep(5000L);
            SwingUtil.later(() -> {
                if (saveCount == this.saveCount.get()) {
                    SwingUtil.later(() -> this.settingsSavedLabel.setVisible(false));
                }
            });
            return null;
        });
    }

    private void onRecommended() {
        String javaVersionId;
        this.saveJreType("recommended");
        VersionSyncInfo version = this.comboBox.sp.scene.loginForm.versions.getVersion();
        if (version == null || !version.isInstalled()) {
            this.pathMessage.setText("settings.jre.window.configure.path.recommended.unknown");
            this.showPath("pathMessage");
            return;
        }
        CompleteVersion localCompleteVersion = version.getLocalCompleteVersion();
        CompleteVersion.JavaVersion javaVersion = localCompleteVersion.getJavaVersion();
        if (javaVersion == null && (javaVersion = TLauncher.getInstance().getJavaManager().getFallbackRecommendedVersion(localCompleteVersion, false)) == null) {
            this.pathMessage.setText("settings.jre.window.configure.path.recommended.current", localCompleteVersion.getID());
            this.showPath("pathMessage");
            return;
        }
        Optional<JavaRuntimeLocal> localRuntimeOpt = TLauncher.getInstance().getJavaManager().getDiscoverer().getCurrentPlatformRuntime(javaVersion.getComponent());
        if (!localRuntimeOpt.isPresent()) {
            this.pathMessage.setText("settings.jre.window.configure.path.recommended.not-installed", localCompleteVersion.getID(), javaVersion.getComponent());
            this.showPath("pathMessage");
            return;
        }
        try {
            javaVersionId = localRuntimeOpt.get().getVersion();
        }
        catch (IOException e) {
            javaVersionId = localRuntimeOpt.get().getName();
        }
        this.recommendedPathField.setText(localRuntimeOpt.get().getDirectory().getAbsolutePath());
        this.setRecommendedPathHint0(localCompleteVersion.getID(), javaVersionId);
        this.showPath("recommendedPath");
    }

    private void onCurrent() {
        this.showPath("currentPath");
        this.saveJreType("current");
    }

    private void onCustom() {
        JavaManagerConfig.Custom custom = this.comboBox.sp.global.get(JavaManagerConfig.Custom.class);
        this.customPathField.setSettingsValue(custom.getPath().orElse(null));
        this.showPath("customPath");
        this.saveJreType("custom");
    }

    private void saveJreType(String type) {
        if (type.equals(this.comboBox.sp.global.get("minecraft.jre.type"))) {
            return;
        }
        this.comboBox.sp.global.set("minecraft.jre.type", type);
        this.comboBox.sp.updateValues();
        this.onValuesSaved();
    }

    private void showPath(String name) {
        this.pathCards.show(this.pathPanel, name);
    }

    private void initPathPanelCard(String name, JComponent field, JComponent hint) {
        ExtendedPanel customPath = new ExtendedPanel();
        customPath.setLayout(new BoxLayout(customPath, 1));
        field.setAlignmentX(0.0f);
        customPath.add((Component)field);
        customPath.add(Box.createRigidArea(new Dimension(1, SwingUtil.magnify(5))));
        customPath.add((Component)hint);
        this.pathPanel.add((Component)customPath, name);
    }

    private LocalizableLabel createCustomPathHint() {
        return new LocalizableLabel();
    }

    private void setCustomPathHint(boolean isError, String path, Object ... vars) {
        if (isError) {
            this.customPathHint.setForeground(Theme.getTheme().getFailure());
        } else {
            this.customPathHint.setForeground(Theme.getTheme().getForeground());
        }
        this.customPathHint.setText(path, vars);
    }

    private EditorFileField initCustomPath() {
        FileExplorer fileExplorer;
        try {
            fileExplorer = FileExplorer.newExplorer();
        }
        catch (Exception e) {
            fileExplorer = null;
        }
        EditorFileField customPathField = new EditorFileField("settings.jre.window.configure.path.custom.placeholder" + (OS.WINDOWS.isCurrent() ? ".windows" : ""), "settings.jre.window.configure.path.custom.browse", fileExplorer, true, false);
        customPathField.addChangeListener(s -> {
            File file;
            if (s != null && (file = new File((String)s)).isFile()) {
                this.comboBox.sp.global.set(new JavaManagerConfig.Custom((String)s));
                Future<JavaVersion> future = this.comboBox.javaVersionCache.get((String)s);
                if (future.isDone()) {
                    this.javaVersionCallback();
                    this.comboBox.sp.jre.getComponent().repaint();
                } else {
                    this.setCustomPathHint(false, "settings.jre.window.configure.path.custom.hint.version.detecting", new Object[0]);
                }
                return;
            }
            this.comboBox.sp.global.set(new JavaManagerConfig.Custom((String)s));
            this.setCustomPathHint(false, "settings.jre.window.configure.path.custom.hint.enter-path", new Object[0]);
        });
        this.initPathPanelCard("customPath", customPathField, this.customPathHint);
        return customPathField;
    }

    private LocalizableTextField initCurrentPath() {
        LocalizableTextField currentPathField = new LocalizableTextField();
        currentPathField.setText(OS.getJavaPath());
        currentPathField.setEditable(false);
        LocalizableLabel currentPathHint = new LocalizableLabel("settings.jre.window.configure.path.current.hint");
        this.initPathPanelCard("currentPath", currentPathField, currentPathHint);
        return currentPathField;
    }

    private LocalizableLabel createRecommendedPathHint() {
        return new LocalizableLabel();
    }

    private void setRecommendedPathHint0(String version, String javaVersion) {
        this.recommendedPathHint0.setText("settings.jre.window.configure.path.recommended.actual.hint.0", version, javaVersion);
    }

    private LocalizableTextField initRecommendedPath() {
        LocalizableTextField recommendedPathField = new LocalizableTextField();
        recommendedPathField.setEditable(false);
        LocalizableButton recommendedPathButton = new LocalizableButton("settings.jre.window.configure.path.recommended.actual.open");
        recommendedPathButton.addActionListener(e -> {
            String path = recommendedPathField.getValue();
            if (path != null) {
                this.setAlwaysOnTop(false);
                OS.openFolder(new File(path));
            }
        });
        LocalizableLabel recommendedPathHint1 = new LocalizableLabel("settings.jre.window.configure.path.recommended.actual.hint.1");
        recommendedPathHint1.setForeground(Theme.getTheme().getSemiForeground());
        HashMap attributes = new HashMap(recommendedPathHint1.getFont().getAttributes());
        attributes.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        recommendedPathHint1.setFont(recommendedPathHint1.getFont().deriveFont(attributes));
        recommendedPathHint1.setCursor(Cursor.getPredefinedCursor(12));
        recommendedPathHint1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                JRESettingsWindow.this.setAlwaysOnTop(false);
                OS.openLink("https://wiki.llaun.ch/" + (((JRESettingsWindow)JRESettingsWindow.this).comboBox.sp.global.isLikelyRussianSpeakingLocale() ? "" : "en:") + "guide:override-jre");
            }
        });
        ExtendedPanel recommendedPathHint = new ExtendedPanel();
        recommendedPathHint.setInsets(new Insets(SwingUtil.magnify(5), 0, 0, 0));
        recommendedPathHint.setLayout(new BoxLayout(recommendedPathHint, 1));
        recommendedPathHint.add((Component)this.recommendedPathHint0);
        recommendedPathHint.add(Box.createRigidArea(new Dimension(0, SwingUtil.magnify(2))));
        recommendedPathHint.add((Component)recommendedPathHint1);
        BorderPanel recommendedPath = new BorderPanel();
        recommendedPath.setCenter(recommendedPathField);
        recommendedPath.setEast(recommendedPathButton);
        recommendedPath.setSouth(recommendedPathHint);
        this.pathPanel.add((Component)recommendedPath, "recommendedPath");
        return recommendedPathField;
    }

    private LocalizableHTMLLabel initPathMessage() {
        LocalizableHTMLLabel pathMessage = new LocalizableHTMLLabel();
        pathMessage.setVerticalAlignment(1);
        pathMessage.setLabelWidth(HALF_WIDTH);
        this.pathPanel.add((Component)pathMessage, "pathMessage");
        return pathMessage;
    }

    private LocalizableTextField createJvmArgsField() {
        LocalizableTextField l = new LocalizableTextField("settings.jre.window.configure.jvm-args.hint"){

            @Override
            protected void updateStyle() {
            }
        };
        l.getDocument().addDocumentListener(new DocumentChangeListener(){

            @Override
            public void documentChanged(DocumentEvent e) {
                JRESettingsWindow.this.saveSelfValues();
            }
        });
        return l;
    }

    private LocalizableCheckbox createUseOptimizedArgsCheckbox() {
        LocalizableCheckbox c = new LocalizableCheckbox("settings.jre.window.configure.jvm-args.use-optimized");
        c.addActionListener(e -> this.saveSelfValues());
        return c;
    }

    private void initJvmArgs(ExtendedPanel cfgs, GridBagConstraints c) {
        ExtendedPanel jvmArgsPanel = new ExtendedPanel();
        jvmArgsPanel.setAlignmentX(0.0f);
        jvmArgsPanel.setLayout(new BoxLayout(jvmArgsPanel, 1));
        jvmArgsPanel.add((Component)this.jvmArgsField);
        jvmArgsPanel.add(Box.createRigidArea(new Dimension(1, SwingUtil.magnify(10))));
        jvmArgsPanel.add((Component)this.useOptimizedArgsCheckbox);
        this.addConfig(cfgs, c, "jvm-args", jvmArgsPanel, 23);
    }

    private void addConfig(ExtendedPanel p, GridBagConstraints c, String path, JComponent component, int anchor) {
        LocalizableLabel label = new LocalizableLabel("settings.jre.window.configure." + path);
        ++c.gridy;
        c.gridx = 0;
        c.anchor = anchor;
        c.insets = SwingUtil.magnify(new Insets(10, 0, 0, 10));
        c.fill = 0;
        c.weightx = 0.0;
        p.add((Component)label, c);
        c.gridx = 1;
        c.anchor = 23;
        c.insets = SwingUtil.magnify(new Insets(10, 0, 0, 0));
        c.fill = 1;
        c.weightx = 1.0;
        p.add((Component)component, c);
    }

    private LocalizableTextField addConfig(ExtendedPanel p, GridBagConstraints c, String path) {
        LocalizableTextField textField = new LocalizableTextField("settings.jre.window.configure." + path + ".hint"){

            @Override
            protected void updateStyle() {
            }
        };
        textField.getDocument().addDocumentListener(new DocumentChangeListener(){

            @Override
            public void documentChanged(DocumentEvent e) {
                JRESettingsWindow.this.saveSelfValues();
            }
        });
        this.addConfig(p, c, path, textField, 21);
        return textField;
    }

    private LocalizableRadioButton addType(String type, int width) {
        LocalizableRadioButton b = new LocalizableRadioButton("settings.jre.window.select." + type);
        this.add(b);
        LocalizableHTMLLabel l = new LocalizableHTMLLabel("settings.jre.window.select." + type + ".hint");
        l.setLabelWidth(width);
        l.setForeground(Theme.getTheme().getSemiForeground());
        this.add(l);
        this.add(Box.createRigidArea(new Dimension(1, SwingUtil.magnify(10))));
        return b;
    }

    private LocalizableLabel addLabel(String path, String icon) {
        LocalizableLabel l = new LocalizableLabel("settings.jre.window." + path + ".label");
        l.setFont(l.getFont().deriveFont(1, l.getFont().getSize2D() + 3.0f));
        l.setIconTextGap(SwingUtil.magnify(10));
        l.setForeground(Theme.getTheme().getSemiForeground());
        l.setIcon(Images.getIcon24(icon).getDisabledInstance());
        this.add(l);
        this.add(Box.createRigidArea(new Dimension(1, SwingUtil.magnify(20))));
        return l;
    }

    @Override
    public void updateLocale() {
        this.setTitle(Localizable.get("settings.jre.window.label"));
    }
}

