/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.settings;

import java.awt.Color;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Locale;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.tlauncher.ui.loc.Localizable;
import ru.turikhay.tlauncher.ui.loc.LocalizableComponent;
import ru.turikhay.tlauncher.ui.swing.MagnifiedInsets;
import ru.turikhay.tlauncher.ui.swing.editor.EditorPane;
import ru.turikhay.tlauncher.ui.swing.extended.BorderPanel;
import ru.turikhay.tlauncher.ui.theme.Theme;
import ru.turikhay.util.FileUtil;
import ru.turikhay.util.OS;
import ru.turikhay.util.SwingUtil;
import ru.turikhay.util.git.ITokenResolver;
import ru.turikhay.util.git.TokenReplacingReader;

public class HTMLPage
extends BorderPanel
implements LocalizableComponent {
    private static final Logger LOGGER = LogManager.getLogger(HTMLPage.class);
    private final String textColor;
    private final AboutPageTokenResolver resolver;
    private final String source;
    private final EditorPane editor;

    HTMLPage(String resourceName) {
        String tempSource;
        Color color = Theme.getTheme().getForeground();
        this.textColor = String.format(Locale.ROOT, "#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
        try {
            tempSource = FileUtil.getResource(this.getClass().getResource(resourceName));
        }
        catch (Exception var4) {
            LOGGER.warn("Could not load HTML page resource from {}", (Object)resourceName, (Object)var4);
            tempSource = null;
        }
        this.source = tempSource;
        this.resolver = new AboutPageTokenResolver();
        this.editor = new EditorPane();
        if (!OS.WINDOWS.isCurrent()) {
            this.editor.setMargin(new MagnifiedInsets(10, 0, 5, 0));
        }
        this.updateLocale();
        this.setCenter(this.editor);
    }

    public EditorPane getEditor() {
        return this.editor;
    }

    public String getSource() {
        return this.source;
    }

    @Override
    public void updateLocale() {
        if (this.source == null) {
            return;
        }
        try {
            String string = IOUtils.toString((Reader)new TokenReplacingReader(new StringReader(this.source), this.resolver));
            this.editor.setText(string);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private class AboutPageTokenResolver
    implements ITokenResolver {
        private AboutPageTokenResolver() {
        }

        @Override
        public String resolveToken(String token) {
            if (token.equals("width")) {
                return String.valueOf(SwingUtil.magnify(525));
            }
            if (token.startsWith("image:")) {
                return token.substring("image:".length());
            }
            if (token.startsWith("loc:")) {
                return Localizable.get(token.substring("loc:".length()));
            }
            if (token.equals("color")) {
                return HTMLPage.this.textColor;
            }
            return token;
        }
    }
}

