/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.settings;

import java.awt.Component;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import ru.turikhay.tlauncher.managers.GPUManager;
import ru.turikhay.tlauncher.ui.converter.StringConverter;
import ru.turikhay.tlauncher.ui.editor.EditorComboBox;
import ru.turikhay.tlauncher.ui.editor.EditorField;
import ru.turikhay.tlauncher.ui.images.ImageIcon;
import ru.turikhay.tlauncher.ui.images.Images;
import ru.turikhay.tlauncher.ui.settings.SettingsPanel;
import ru.turikhay.tlauncher.ui.swing.ConverterCellRenderer;
import ru.turikhay.tlauncher.ui.swing.extended.BorderPanel;

public class GPUComboBox
extends BorderPanel
implements EditorField {
    private final SettingsPanel sp;
    private final EditorComboBox<GPUManager.GPU> comboBox;

    public GPUComboBox(SettingsPanel sp) {
        this.sp = sp;
        GPUManager gpuManager = sp.tlauncher.getGpuManager();
        List<GPUManager.GPU> gpus = gpuManager.discoveryGPUs();
        this.comboBox = new EditorComboBox<GPUManager.GPU>(new GPUCellRenderer(gpus, gpuManager), false);
        GPUManager.GPU.GLOBAL_DEFINED.forEach(this.comboBox::addItem);
        gpus.forEach(this.comboBox::addItem);
        this.setCenter(this.comboBox);
    }

    @Override
    public void block(Object reason) {
        this.comboBox.block(reason);
    }

    @Override
    public void unblock(Object reason) {
        this.comboBox.unblock(reason);
    }

    @Override
    public String getSettingsValue() {
        return this.comboBox.getSettingsValue();
    }

    @Override
    public void setSettingsValue(String value) {
        this.comboBox.setSettingsValue(value);
    }

    @Override
    public boolean isValueValid() {
        return this.comboBox.isValueValid();
    }

    private static class GPUCellRenderer
    extends ConverterCellRenderer<GPUManager.GPU> {
        private final DefaultListCellRenderer defaultRenderer = new DefaultListCellRenderer();

        GPUCellRenderer(List<GPUManager.GPU> gpus, GPUManager gpuManager) {
            super(new GPUConverter(gpus, gpuManager));
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends GPUManager.GPU> list, GPUManager.GPU value, int index, boolean isSelected, boolean cellHasFocus) {
            ImageIcon icon;
            JLabel label = (JLabel)this.defaultRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            label.setText(this.converter.toString(value));
            switch (value.getVendor()) {
                case AMD: {
                    icon = Images.getIcon16("gpu-icon-amd");
                    break;
                }
                case Nvidia: {
                    icon = Images.getIcon16("gpu-icon-nvidia");
                    break;
                }
                case Intel: {
                    icon = Images.getIcon16("gpu-icon-intel");
                    break;
                }
                default: {
                    icon = null;
                }
            }
            label.setIcon(icon);
            return label;
        }
    }

    private static class GPUConverter
    implements StringConverter<GPUManager.GPU> {
        private final List<GPUManager.GPU> gpus;
        private final GPUManager gpuManager;

        GPUConverter(List<GPUManager.GPU> gpus, GPUManager gpuManager) {
            this.gpus = gpus;
            this.gpuManager = gpuManager;
        }

        @Override
        public GPUManager.GPU fromString(String name) {
            return GPUManager.GPU.GLOBAL_DEFINED.stream().filter(gpu -> gpu.getName().equalsIgnoreCase(name)).findAny().orElseGet(() -> this.gpus.stream().filter(gpu -> gpu.getName().equalsIgnoreCase(name)).findAny().orElse(null));
        }

        @Override
        public String toString(GPUManager.GPU gpu) {
            return gpu.getDisplayName(this.gpuManager);
        }

        @Override
        public String toValue(GPUManager.GPU gpu) {
            return gpu.getName();
        }

        @Override
        public Class<GPUManager.GPU> getObjectClass() {
            return GPUManager.GPU.class;
        }
    }
}

