/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.scenes;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.AbstractButton;
import ru.turikhay.tlauncher.stats.Stats;
import ru.turikhay.tlauncher.ui.MainPane;
import ru.turikhay.tlauncher.ui.TLauncherFrame;
import ru.turikhay.tlauncher.ui.block.Blocker;
import ru.turikhay.tlauncher.ui.images.ImageIcon;
import ru.turikhay.tlauncher.ui.images.Images;
import ru.turikhay.tlauncher.ui.notice.Notice;
import ru.turikhay.tlauncher.ui.notice.NoticeManager;
import ru.turikhay.tlauncher.ui.notice.NoticeManagerListener;
import ru.turikhay.tlauncher.ui.notice.NoticePanel;
import ru.turikhay.tlauncher.ui.scenes.PseudoScene;
import ru.turikhay.tlauncher.ui.swing.MagnifiedInsets;
import ru.turikhay.tlauncher.ui.swing.ResizeableComponent;
import ru.turikhay.tlauncher.ui.swing.extended.ExtendedButton;
import ru.turikhay.tlauncher.ui.swing.extended.ExtendedPanel;
import ru.turikhay.tlauncher.ui.swing.extended.ExtendedToggleButton;
import ru.turikhay.util.SwingUtil;

public class NoticeScene
extends PseudoScene
implements ResizeableComponent {
    public static final float ADDED_FONT_SIZE = 2.0f;
    private static final int IMAGE_WIDTH = 24;
    private static final int SAFE_ZONE = 10;
    private final NoticePanel noticePanel;
    private final ButtonPanel buttonPanel;
    private final float fontSize = TLauncherFrame.getFontSize() + 2.0f;

    public NoticeScene(MainPane main) {
        super(main);
        this.noticePanel = new NoticePanel(main.getRootFrame().getNotices(), this.fontSize){

            @Override
            protected void updateNotice() {
                super.updateNotice();
                NoticeScene.this.onResize();
            }
        };
        this.add((Component)this.noticePanel);
        this.buttonPanel = new ButtonPanel();
        this.add((Component)this.buttonPanel);
        this.getMainPane().getRootFrame().getNotices().addListener(this.noticePanel, true);
        this.getMainPane().getRootFrame().getNotices().addListener(new NoticeManagerListener(){

            @Override
            public void onNoticeSelected(Notice notice) {
                NoticeScene.this.updateNoticeVisibility();
            }

            @Override
            public void onNoticePromoted(Notice promotedNotice) {
                NoticeScene.this.updateNoticeVisibility();
            }
        }, true);
    }

    private void changeNotice(int indexDelta) {
        int currentIndex;
        this.setVisible(false);
        Notice selected = null;
        List<Notice> noticeList = this.getMainPane().getRootFrame().getNotices().getForCurrentLocale();
        if (noticeList != null && (currentIndex = noticeList.indexOf(this.noticePanel.getNotice())) != -1) {
            currentIndex = (currentIndex + indexDelta + noticeList.size()) % noticeList.size();
            selected = noticeList.get(currentIndex);
        }
        this.getMainPane().getRootFrame().getNotices().selectNotice(selected, true);
        this.setVisible(true);
        this.noticePanel.redraw();
    }

    private void updateNoticeVisibility() {
        if (this.noticePanel.getNotice() != null) {
            boolean hidden = this.getMainPane().getRootFrame().getNotices().isHidden(this.noticePanel.getNotice());
            Blocker.setBlocked(this.noticePanel, "notice_disabled", hidden);
            this.buttonPanel.visible.setEnabled(true);
            this.buttonPanel.visible.setSelected(!hidden);
        } else {
            this.buttonPanel.visible.setEnabled(false);
        }
    }

    @Override
    public void setShown(boolean shown, boolean animate) {
        super.setShown(shown, animate);
        if (shown) {
            Stats.noticeSceneShown();
            NoticeManager manager = this.getMainPane().getRootFrame().getNotices();
            List<Notice> list = manager.getForCurrentLocale();
            if (list != null && manager.getSelectedNotice() == null) {
                manager.selectNotice(list.get(0), false);
            }
            this.noticePanel.redraw();
        }
    }

    @Override
    public void onResize() {
        super.onResize();
        this.noticePanel.setLocation((this.getWidth() - this.noticePanel.getWidth()) / 2, (this.getHeight() - this.noticePanel.getHeight()) / 2);
        this.buttonPanel.setLocation((this.getWidth() - this.buttonPanel.getWidth()) / 2, this.getHeight() - this.buttonPanel.getHeight() - SwingUtil.magnify(10));
    }

    private class ButtonPanel
    extends ExtendedPanel
    implements ResizeableComponent {
        private final Insets insets = new MagnifiedInsets(0, 5, 0, 5);
        private final ExtendedButton prev;
        private final ExtendedButton next;
        private final ExtendedButton home;
        private final ExtendedToggleButton visible;

        ButtonPanel() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.insets = this.insets;
            c.gridx = -1;
            c.gridy = 0;
            c.fill = 3;
            this.prev = this.newButton("arrow-left", e -> NoticeScene.this.changeNotice(-1));
            ++c.gridx;
            this.add((Component)this.prev, c);
            this.next = this.newButton("arrow-right", e -> NoticeScene.this.changeNotice(1));
            ++c.gridx;
            this.add((Component)this.next, c);
            this.visible = this.newToggleButton("eye.png", "eye-slash.png", new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (NoticeScene.this.noticePanel.getNotice() == null) {
                        return;
                    }
                    boolean hidden = !ButtonPanel.this.visible.isSelected();
                    NoticeScene.this.getMainPane().getRootFrame().getNotices().setHidden(NoticeScene.this.noticePanel.getNotice(), hidden);
                    NoticeScene.this.updateNoticeVisibility();
                }
            });
            ++c.gridx;
            this.add((Component)this.visible, c);
            this.home = this.newButton("home", e -> NoticeScene.this.getMainPane().openDefaultScene());
            ++c.gridx;
            this.add((Component)this.home, c);
        }

        @Override
        public void onResize() {
            int width = 0;
            width += (this.insets.left + this.insets.right) * 4;
            width += this.prev.getPreferredSize().width;
            width += this.next.getPreferredSize().width;
            width += this.home.getPreferredSize().width;
            width += this.visible.getPreferredSize().width;
            int height = 0;
            height = Math.max(height, this.prev.getPreferredSize().height);
            height = Math.max(height, this.next.getPreferredSize().height);
            height = Math.max(height, this.home.getPreferredSize().height);
            height = Math.max(height, this.visible.getPreferredSize().height);
            this.setBounds(0, 0, width, height);
        }

        private void setupButton(AbstractButton b, String iconPath, ActionListener l) {
            ImageIcon icon = this.newImage(iconPath);
            icon.setup(b);
            Dimension d = new Dimension(b.getInsets().left + b.getInsets().right + icon.getIconWidth(), b.getInsets().top + b.getInsets().bottom + icon.getIconHeight());
            b.setPreferredSize(d);
            b.setSize(d);
            b.addActionListener(l);
        }

        private ExtendedButton newButton(String iconPath, ActionListener l) {
            ExtendedButton b = new ExtendedButton();
            this.setupButton(b, iconPath, l);
            return b;
        }

        private ExtendedToggleButton newToggleButton(String enabledIcon, String disabledIcon, ActionListener l) {
            ExtendedToggleButton b = new ExtendedToggleButton();
            ImageIcon enabled = this.newImage(enabledIcon);
            ImageIcon disabled = this.newImage(disabledIcon);
            b.addChangeListener(e -> {
                b.setIcon(b.isSelected() ? enabled : disabled);
                b.setDisabledIcon(disabled);
            });
            b.setSelected(true);
            Dimension d = new Dimension(b.getInsets().left + b.getInsets().right + Math.max(enabled.getIconWidth(), disabled.getIconWidth()), b.getInsets().top + b.getInsets().bottom + Math.max(enabled.getIconHeight(), disabled.getIconHeight()));
            b.setPreferredSize(d);
            b.setSize(d);
            b.addActionListener(l);
            return b;
        }

        private ImageIcon newImage(String iconPath) {
            return Images.getIcon24(iconPath);
        }
    }
}

