/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.scenes;

import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import ru.turikhay.tlauncher.configuration.Configuration;
import ru.turikhay.tlauncher.minecraft.auth.Account;
import ru.turikhay.tlauncher.ui.MainPane;
import ru.turikhay.tlauncher.ui.login.LoginForm;
import ru.turikhay.tlauncher.ui.notice.MainNoticePanel;
import ru.turikhay.tlauncher.ui.notice.Notice;
import ru.turikhay.tlauncher.ui.notice.NoticeSidePanel;
import ru.turikhay.tlauncher.ui.notification.NotificationPanel;
import ru.turikhay.tlauncher.ui.scenes.PseudoScene;
import ru.turikhay.tlauncher.ui.settings.SettingsPanel;
import ru.turikhay.tlauncher.ui.swing.DelayedComponent;
import ru.turikhay.tlauncher.ui.swing.DelayedComponentLoader;
import ru.turikhay.tlauncher.ui.swing.extended.ExtendedPanel;
import ru.turikhay.tlauncher.user.User;
import ru.turikhay.util.Direction;
import ru.turikhay.util.SwingUtil;

public class DefaultScene
extends PseudoScene {
    public static final Dimension LOGIN_SIZE = new Dimension(285, 240);
    public static final Dimension SETTINGS_SIZE = new Dimension(600, 550);
    public final LoginForm loginForm;
    public final DelayedComponent<SettingsPanel> settingsForm = new DelayedComponent<SettingsPanel>(new DelayedComponentLoader<SettingsPanel>(){

        @Override
        public SettingsPanel loadComponent() {
            return new SettingsPanel(DefaultScene.this);
        }

        @Override
        public void onComponentLoaded(SettingsPanel loaded) {
            loaded.setVisible(false);
            DefaultScene.this.add((Component)loaded);
            loaded.setSize(SwingUtil.magnify(SETTINGS_SIZE));
            loaded.ready = true;
        }
    });
    public final DelayedComponent<NoticeSidePanel> noticeSidePanel;
    private SidePanel sidePanel;
    private ExtendedPanel sidePanelComp;
    private Direction lfDirection;
    public final DelayedComponent<MainNoticePanel> noticePanel;
    public final NotificationPanel notificationPanel;
    private static final int MARGIN = 10;
    private static final int SPACE_BETWEEN = 15;

    public DefaultScene(MainPane main) {
        super(main);
        this.loginForm = new LoginForm(this);
        this.loginForm.setSize(SwingUtil.magnify(LOGIN_SIZE));
        this.add((Component)this.loginForm);
        this.noticePanel = new DelayedComponent<MainNoticePanel>(new DelayedComponentLoader<MainNoticePanel>(){

            @Override
            public MainNoticePanel loadComponent() {
                return new MainNoticePanel(DefaultScene.this);
            }

            @Override
            public void onComponentLoaded(MainNoticePanel loaded) {
                DefaultScene.this.add((Component)loaded);
                DefaultScene.this.updateSidePanel();
            }
        });
        this.noticeSidePanel = new DelayedComponent<NoticeSidePanel>(new DelayedComponentLoader<NoticeSidePanel>(){

            @Override
            public NoticeSidePanel loadComponent() {
                return new NoticeSidePanel(DefaultScene.this);
            }

            @Override
            public void onComponentLoaded(NoticeSidePanel loaded) {
                DefaultScene.this.add((Component)loaded);
                DefaultScene.this.updateSidePanel();
            }
        });
        this.notificationPanel = new NotificationPanel();
        this.add((Component)this.notificationPanel);
        this.updateDirection();
    }

    private void updateSidePanel() {
        if (this.isNoticeSidePanelEnabled() && this.getMainPane().getRootFrame().getNotices().getForCurrentLocale() != null) {
            this.setSidePanel(null);
        }
    }

    @Override
    public void setShown(boolean shown, boolean animate) {
        super.setShown(shown, animate);
        if (shown) {
            Account<? extends User> selected;
            if (this.getMainPane().getRootFrame().getNotices().getSelectedNotice() != null) {
                if (this.getMainPane().getRootFrame().getNotices().isHidden(this.noticePanel.get().getNotice())) {
                    this.getMainPane().getRootFrame().getNotices().selectRandom();
                }
                this.noticePanel.get().redraw();
            }
            if (this.getMainPane().accountManager.isLoaded() && (selected = this.getMainPane().accountManager.get().list.getSelected()) != null) {
                this.loginForm.accounts.setAccount(selected);
            }
        }
    }

    @Override
    public void onResize() {
        if (this.parent != null) {
            this.setBounds(0, 0, this.parent.getWidth(), this.parent.getHeight());
            this.updateCoords();
        }
    }

    private void updateCoords() {
        int sn_y;
        int lf_y;
        int lf_x;
        block25: {
            int sp_y;
            int sp_x;
            block27: {
                int n_y;
                int n_x;
                int hh;
                int hw;
                int w;
                block26: {
                    int lf_h;
                    int lf_w;
                    int h;
                    int spaceBetween;
                    int margin;
                    block24: {
                        margin = SwingUtil.magnify(10);
                        spaceBetween = SwingUtil.magnify(15);
                        w = this.getWidth();
                        h = this.getHeight();
                        hw = w / 2;
                        hh = h / 2;
                        lf_w = this.loginForm.getWidth();
                        lf_h = this.loginForm.getHeight();
                        if (this.sidePanel != null && this.sidePanelComp != null) break block24;
                        switch (this.lfDirection) {
                            case TOP_LEFT: 
                            case CENTER_LEFT: 
                            case BOTTOM_LEFT: {
                                lf_x = margin;
                                break;
                            }
                            case TOP: 
                            case CENTER: 
                            case BOTTOM: {
                                lf_x = hw - lf_w / 2;
                                break;
                            }
                            case TOP_RIGHT: 
                            case CENTER_RIGHT: 
                            case BOTTOM_RIGHT: {
                                lf_x = w - lf_w - margin;
                                break;
                            }
                            default: {
                                throw new RuntimeException("unknown direction:" + (Object)((Object)this.lfDirection));
                            }
                        }
                        switch (this.lfDirection) {
                            case TOP_LEFT: 
                            case TOP: 
                            case TOP_RIGHT: {
                                lf_y = margin;
                                break block25;
                            }
                            case CENTER_LEFT: 
                            case CENTER: 
                            case CENTER_RIGHT: {
                                lf_y = hh - lf_h / 2;
                                break block25;
                            }
                            case BOTTOM_LEFT: 
                            case BOTTOM: 
                            case BOTTOM_RIGHT: {
                                lf_y = h - margin - lf_h;
                                break block25;
                            }
                            default: {
                                throw new RuntimeException("unknown direction:" + (Object)((Object)this.lfDirection));
                            }
                        }
                    }
                    n_x = this.sidePanelComp.getWidth();
                    n_y = this.sidePanelComp.getHeight();
                    int bw = lf_w + n_x + spaceBetween;
                    int hbw = bw / 2;
                    if (w <= bw) break block26;
                    switch (this.lfDirection) {
                        case TOP_LEFT: 
                        case CENTER_LEFT: 
                        case BOTTOM_LEFT: {
                            lf_x = margin;
                            sp_x = lf_x + lf_w + spaceBetween;
                            break;
                        }
                        case TOP: 
                        case CENTER: 
                        case BOTTOM: {
                            lf_x = hw - hbw;
                            sp_x = lf_x + lf_w + spaceBetween;
                            break;
                        }
                        case TOP_RIGHT: 
                        case CENTER_RIGHT: 
                        case BOTTOM_RIGHT: {
                            lf_x = w - margin - lf_w;
                            sp_x = lf_x - spaceBetween - n_x;
                            break;
                        }
                        default: {
                            throw new RuntimeException("unknown direction:" + (Object)((Object)this.lfDirection));
                        }
                    }
                    switch (this.lfDirection) {
                        case TOP_LEFT: 
                        case TOP: 
                        case TOP_RIGHT: {
                            sp_y = margin;
                            lf_y = margin;
                            break block27;
                        }
                        case CENTER_LEFT: 
                        case CENTER: 
                        case CENTER_RIGHT: {
                            lf_y = hh - lf_h / 2;
                            sp_y = hh - n_y / 2;
                            break block27;
                        }
                        case BOTTOM_LEFT: 
                        case BOTTOM: 
                        case BOTTOM_RIGHT: {
                            lf_y = h - margin - lf_h;
                            sp_y = h - margin - n_y;
                            break block27;
                        }
                        default: {
                            throw new RuntimeException("unknown direction:" + (Object)((Object)this.lfDirection));
                        }
                    }
                }
                lf_x = w * 2;
                lf_y = 0;
                sp_x = hw - n_x / 2;
                sp_y = hh - n_y / 2;
            }
            this.sidePanelComp.setLocation(sp_x, sp_y);
        }
        this.loginForm.setLocation(lf_x, lf_y);
        if (this.noticePanel.isLoaded()) {
            this.noticePanel.get().onResize();
        }
        switch (this.lfDirection) {
            case TOP_LEFT: 
            case TOP: 
            case TOP_RIGHT: {
                sn_y = this.getHeight() - this.notificationPanel.height;
                break;
            }
            default: {
                sn_y = 0;
            }
        }
        this.notificationPanel.setBounds(0, sn_y, this.getWidth(), this.notificationPanel.height);
    }

    public SidePanel getSidePanel() {
        return this.sidePanel;
    }

    public boolean isNoticeSidePanelEnabled() {
        return this.getMainPane().getRootFrame().getConfiguration().getBoolean("gui.notices.enabled");
    }

    public void setNoticeSidePanelEnabled(boolean e) {
        this.getMainPane().getRootFrame().getConfiguration().set("gui.notices.enabled", (Object)e);
        this.setSidePanel(null);
    }

    public void setSidePanel(SidePanel side) {
        List<Notice> noticeList = this.getMainPane().getRootFrame().getNotices().getForCurrentLocale();
        if (side == null && this.isNoticeSidePanelEnabled() && noticeList != null && noticeList.size() > 3) {
            side = SidePanel.NOTICES;
        }
        if (this.sidePanel != side) {
            boolean noSidePanel;
            boolean bl = noSidePanel = side == null;
            if (this.sidePanelComp != null) {
                this.sidePanelComp.setVisible(false);
            }
            this.sidePanel = side;
            ExtendedPanel extendedPanel = this.sidePanelComp = noSidePanel ? null : this.getSidePanelComp(side);
            if (!noSidePanel) {
                this.sidePanelComp.setVisible(true);
            }
            if (this.noticePanel.isLoaded()) {
                this.noticePanel.get().setVisible(noSidePanel);
            }
            this.updateCoords();
            this.validate();
            this.repaint();
            if (this.sidePanelComp != null) {
                this.sidePanelComp.validate();
                this.sidePanelComp.repaint();
            }
        }
    }

    public void toggleSidePanel(SidePanel side) {
        if (this.sidePanel == side) {
            side = null;
        }
        this.setSidePanel(side);
    }

    public ExtendedPanel getSidePanelComp(SidePanel side) {
        if (side == null) {
            throw new NullPointerException("side");
        }
        switch (side) {
            case SETTINGS: {
                return this.settingsForm.get();
            }
            case NOTICES: {
                return this.noticeSidePanel.get();
            }
        }
        throw new RuntimeException("unknown side:" + (Object)((Object)side));
    }

    public Direction getLoginFormDirection() {
        return this.lfDirection;
    }

    public void updateDirection() {
        this.loadDirection();
        this.updateCoords();
    }

    private void loadDirection() {
        Configuration config = this.getMainPane().getRootFrame().getConfiguration();
        Direction loginFormDirection = config.getDirection("gui.direction.loginform");
        if (loginFormDirection == null) {
            loginFormDirection = Direction.CENTER;
        }
        this.lfDirection = loginFormDirection;
    }

    public static enum SidePanel {
        SETTINGS,
        NOTICES;

        public final boolean requiresShow;

        private SidePanel(boolean requiresShow) {
            this.requiresShow = requiresShow;
        }

        private SidePanel() {
            this(false);
        }
    }
}

