/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.progress;

import java.awt.Component;
import ru.turikhay.tlauncher.minecraft.crash.CrashManager;
import ru.turikhay.tlauncher.minecraft.launcher.MinecraftException;
import ru.turikhay.tlauncher.minecraft.launcher.MinecraftExtendedListener;
import ru.turikhay.tlauncher.ui.progress.DownloaderProgress;

public class LaunchProgress
extends DownloaderProgress
implements MinecraftExtendedListener {
    private static final long serialVersionUID = -1003141285749311799L;

    public LaunchProgress(Component parentComp) {
        super(parentComp);
    }

    @Override
    public void clearProgress() {
        this.setIndeterminate(false);
        this.setValue(0);
        this.setCenterString(null);
        this.setEastString(null);
    }

    private void setupBar() {
        this.startProgress();
        this.setIndeterminate(true);
    }

    @Override
    public void onMinecraftPrepare() {
        this.setupBar();
    }

    @Override
    public void onMinecraftCollecting() {
        this.setWestString("launcher.step.collecting");
    }

    @Override
    public void onMinecraftComparingAssets(boolean fastCompare) {
        this.setWestString("launcher.step.comparing-assets" + (fastCompare ? "" : "-long"));
    }

    @Override
    public void onMinecraftCheckingJre() {
        this.setWestString("launcher.step.checking-jre");
    }

    @Override
    public void onMinecraftMalwareScanning() {
        this.setWestString("launcher.step.jarscanner");
    }

    @Override
    public void onMinecraftDownloading() {
        this.setWestString("launcher.step.downloading");
    }

    @Override
    public void onMinecraftReconstructingAssets() {
        this.setupBar();
        this.setWestString("launcher.step.reconstructing-assets");
    }

    @Override
    public void onMinecraftUnpackingNatives() {
        this.setWestString("launcher.step.unpacking-natives");
    }

    @Override
    public void onMinecraftDeletingEntries() {
        this.setWestString("launcher.step.deleting-entries");
    }

    @Override
    public void onMinecraftConstructing() {
        this.setWestString("launcher.step.constructing");
    }

    @Override
    public void onMinecraftPostLaunch() {
        this.setStrings(null, null, null);
    }

    @Override
    public void onMinecraftAbort() {
        this.stopProgress();
    }

    @Override
    public void onMinecraftLaunch() {
        this.stopProgress();
    }

    @Override
    public void onMinecraftClose() {
    }

    @Override
    public void onMinecraftError(Throwable e) {
        this.stopProgress();
    }

    @Override
    public void onMinecraftKnownError(MinecraftException e) {
        this.stopProgress();
    }

    @Override
    public void onCrashManagerInit(CrashManager manager) {
    }
}

