/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.progress;

import java.awt.Component;
import java.text.NumberFormat;
import ru.turikhay.tlauncher.TLauncher;
import ru.turikhay.tlauncher.downloader.Downloadable;
import ru.turikhay.tlauncher.downloader.Downloader;
import ru.turikhay.tlauncher.downloader.DownloaderListener;
import ru.turikhay.tlauncher.ui.loc.Localizable;
import ru.turikhay.tlauncher.ui.loc.LocalizableProgressBar;

public class DownloaderProgress
extends LocalizableProgressBar
implements DownloaderListener {
    private static final long serialVersionUID = -8382205925341380876L;
    private NumberFormat percentFormat;

    private DownloaderProgress(Component parentComp, Downloader downloader) {
        super(parentComp);
        if (downloader == null) {
            throw new NullPointerException();
        }
        downloader.addListener(this);
        this.stopProgress();
    }

    public DownloaderProgress(Component parentComp) {
        this(parentComp, TLauncher.getInstance().getDownloader());
    }

    @Override
    public void onDownloaderStart(Downloader d, int files) {
        this.startProgress();
        this.setIndeterminate(true);
        this.setCenterString("progressBar.init");
        this.setEastString("progressBar.downloading", files);
    }

    @Override
    public void onDownloaderAbort(Downloader d) {
        this.stopProgress();
    }

    @Override
    public void onDownloaderProgress(Downloader d, double dprogress, double speed) {
        if (dprogress > 0.0) {
            double progress;
            if (d.getRemaining() == 1) {
                progress = d.getLastProgress() * 100.0;
            } else {
                progress = dprogress * 100.0;
                if ((double)this.getValue() > progress) {
                    return;
                }
            }
            this.setIndeterminate(false);
            this.setValue((int)progress);
            this.setCenterString(this.getOrUpdatePercentFormat(false).format(dprogress));
        }
    }

    @Override
    public void onDownloaderFileComplete(Downloader d, Downloadable file) {
        this.setIndeterminate(false);
        this.setEastString("progressBar.remaining", d.getRemaining());
    }

    @Override
    public void onDownloaderComplete(Downloader d) {
        this.stopProgress();
    }

    @Override
    public void updateLocale() {
        super.updateLocale();
        this.getOrUpdatePercentFormat(true);
    }

    private NumberFormat getOrUpdatePercentFormat(boolean forceUpdate) {
        if (this.percentFormat == null || forceUpdate) {
            this.percentFormat = NumberFormat.getPercentInstance(Localizable.get().getLocale());
        }
        return this.percentFormat;
    }
}

