/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.notification;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.SwingUtilities;
import ru.turikhay.tlauncher.TLauncher;
import ru.turikhay.tlauncher.ui.images.ImageIcon;
import ru.turikhay.tlauncher.ui.loc.Localizable;
import ru.turikhay.tlauncher.ui.loc.LocalizableComponent;
import ru.turikhay.tlauncher.ui.notification.Notification;
import ru.turikhay.tlauncher.ui.notification.NotificationIcon;
import ru.turikhay.tlauncher.ui.notification.NotificationListener;
import ru.turikhay.tlauncher.ui.notification.UrlNotificationObject;
import ru.turikhay.tlauncher.ui.swing.extended.ExtendedButton;
import ru.turikhay.tlauncher.ui.swing.extended.ExtendedPanel;
import ru.turikhay.util.SwingUtil;

public class NotificationPanel
extends ExtendedPanel
implements LocalizableComponent {
    public static final int GAP = SwingUtil.magnify(10);
    private final int buttonSize = SwingUtil.magnify(48);
    private final int iconSize = SwingUtil.magnify(32);
    public final int height = GAP * 2 + this.buttonSize;
    private final ArrayList<NotificationIcon> notifications = new ArrayList();
    private String localeNotificationId;

    public NotificationPanel() {
        this.setLayout(new FlowLayout(0, GAP, GAP));
        this.updateLocale();
    }

    public void addNotification(final String id, Notification notification) {
        this.removeNotification(id);
        ExtendedButton button = new ExtendedButton();
        button.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    NotificationPanel.this.removeNotification(id);
                }
            }
        });
        button.addActionListener(e -> notification.listener.onClicked());
        button.setPreferredSize(new Dimension(this.buttonSize, this.buttonSize));
        NotificationIcon icon = new NotificationIcon(id, notification, this.iconSize, button);
        this.notifications.add(icon);
        ImageIcon.setup(button, icon);
        this.add((Component)button);
        this.deferUpdate();
    }

    public void removeNotification(String id) {
        Iterator<NotificationIcon> i = this.notifications.iterator();
        boolean removed = false;
        while (i.hasNext()) {
            NotificationIcon n = i.next();
            if (!n.id.equals(id)) continue;
            this.remove(n.parent);
            i.remove();
            removed = true;
        }
        if (removed) {
            this.deferUpdate();
        }
    }

    private void deferUpdate() {
        SwingUtil.later(() -> {
            this.revalidate();
            this.repaint();
        });
    }

    @Override
    public void updateLocale() {
        UrlNotificationObject notificationObject;
        if (this.localeNotificationId != null) {
            this.removeNotification(this.localeNotificationId);
            this.localeNotificationId = null;
        }
        if ((notificationObject = TLauncher.getInstance().getBootConfig().getNotifications().get(Localizable.get().getLocale().toString())) != null) {
            this.addNotification(notificationObject.getId(), new Notification(notificationObject.getImage(), new NotificationListener.UrlOpen(notificationObject.getUrl()).then(new NotificationListener.Remove(this, notificationObject.getId()))));
            this.localeNotificationId = notificationObject.getId();
        }
    }
}

