/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.notification;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import ru.turikhay.tlauncher.ui.notification.NotificationPanel;
import ru.turikhay.util.OS;

public interface NotificationListener {
    public void onClicked();

    default public NotificationListener then(NotificationListener ... listeners) {
        ArrayList<NotificationListener> l = new ArrayList<NotificationListener>(listeners.length + 1);
        l.add(this);
        l.addAll(Arrays.asList(listeners));
        return new NotificationListenerChain(l);
    }

    public static class NotificationListenerChain
    implements NotificationListener {
        private final List<NotificationListener> listeners;

        public NotificationListenerChain(List<NotificationListener> listeners) {
            this.listeners = listeners;
        }

        @Override
        public void onClicked() {
            for (NotificationListener listener : this.listeners) {
                listener.onClicked();
            }
        }
    }

    public static class Remove
    implements NotificationListener {
        private final NotificationPanel panel;
        private final String id;

        public Remove(NotificationPanel panel, String id) {
            this.panel = panel;
            this.id = id;
        }

        @Override
        public void onClicked() {
            this.panel.removeNotification(this.id);
        }
    }

    public static class UrlOpen
    implements NotificationListener {
        private final String url;

        public UrlOpen(String url) {
            this.url = url;
        }

        @Override
        public void onClicked() {
            OS.openLink(this.url);
        }
    }
}

