/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.notice;

import java.awt.Image;
import java.net.URL;
import java.util.concurrent.Future;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.builder.ToStringBuilder;
import ru.turikhay.tlauncher.ui.notice.NoticeImage;
import ru.turikhay.util.async.AsyncThread;

public class UrlNoticeImage
extends NoticeImage {
    private final URL url;
    private int width;
    private int height;
    private Future<Image> future;

    UrlNoticeImage(URL url, int width, int height) {
        this.url = url;
        this.width = width;
        this.height = height;
    }

    UrlNoticeImage(URL url) {
        Image image;
        this.url = url;
        try {
            image = this.getTask().get();
        }
        catch (Exception e) {
            return;
        }
        this.width = image.getWidth(null);
        this.height = image.getHeight(null);
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public Future<Image> getTask() {
        if (this.future == null) {
            this.future = AsyncThread.future(() -> ImageIO.read(this.url));
            return this.future;
        }
        return this.future;
    }

    @Override
    protected ToStringBuilder toStringBuilder() {
        return super.toStringBuilder().append("url", (Object)this.url).append("width", this.width).append("height", this.height);
    }
}

