/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.notice;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.JMenuItem;
import org.apache.commons.lang3.builder.ToStringBuilder;
import ru.turikhay.tlauncher.ui.loc.LocalizableMenuItem;
import ru.turikhay.tlauncher.ui.notice.NoticeAction;
import ru.turikhay.util.OS;
import ru.turikhay.util.StringUtil;

public class UrlNoticeAction
extends NoticeAction {
    private final String name;
    private final URL url;

    UrlNoticeAction(String name, URL url) {
        super("url");
        this.name = StringUtil.requireNotBlank(name, "name");
        this.url = Objects.requireNonNull(url, "url");
    }

    @Override
    List<? extends JMenuItem> getMenuItemList() {
        ArrayList<LocalizableMenuItem> list = new ArrayList<LocalizableMenuItem>();
        LocalizableMenuItem item = new LocalizableMenuItem(this.L10N_PREFIX + "open", this.name);
        item.addActionListener(e -> OS.openLink(this.url));
        list.add(item);
        return list;
    }

    @Override
    protected ToStringBuilder toStringBuilder() {
        return super.toStringBuilder().append("name", (Object)this.name).append("url", (Object)this.url);
    }
}

