/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.notice;

import java.awt.Dimension;
import java.util.function.Supplier;
import ru.turikhay.tlauncher.ui.notice.Notice;
import ru.turikhay.tlauncher.ui.notice.NoticeEditorPane;
import ru.turikhay.tlauncher.ui.notice.NoticeTextSize;
import ru.turikhay.tlauncher.ui.notice.ParamPair;
import ru.turikhay.util.SwingUtil;
import ru.turikhay.util.WeakObjectPool;

class SizeCalculator
implements Supplier<Dimension> {
    private static final int MIN_WIDTH = 300;
    private static final int MIN_HEIGHT = 48;
    private static final int MAX_WIDTH = 450;
    private static final WeakObjectPool<NoticeEditorPane> editorPanePool = new WeakObjectPool<NoticeEditorPane>(NoticeEditorPane::new);
    private final Notice notice;
    private final ParamPair param;

    SizeCalculator(NoticeTextSize parent, ParamPair param) {
        this.notice = parent.getNotice();
        this.param = param;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension get() {
        WeakObjectPool.ObjectRef<NoticeEditorPane> ref = editorPanePool.get();
        try {
            NoticeEditorPane pane = ref.get();
            pane.setNotice(this.notice, this.param);
            if (this.param.width > 0) {
                Dimension dimension = pane.calcPreferredSize(this.param.width);
                return dimension;
            }
            Dimension dimension = pane.calcPreferredSize(SwingUtil.magnify(48), SwingUtil.magnify(300), SwingUtil.magnify(450));
            return dimension;
        }
        finally {
            ref.free();
        }
    }
}

