/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.notice;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import javax.swing.JMenuItem;
import net.minecraft.launcher.updater.VersionSyncInfo;
import net.minecraft.launcher.versions.CompleteVersion;
import net.minecraft.launcher.versions.ReleaseType;
import org.apache.commons.lang3.builder.ToStringBuilder;
import ru.turikhay.tlauncher.TLauncher;
import ru.turikhay.tlauncher.minecraft.PromotedServer;
import ru.turikhay.tlauncher.minecraft.auth.Account;
import ru.turikhay.tlauncher.ui.alert.Alert;
import ru.turikhay.tlauncher.ui.images.ImageIcon;
import ru.turikhay.tlauncher.ui.images.Images;
import ru.turikhay.tlauncher.ui.loc.Localizable;
import ru.turikhay.tlauncher.ui.loc.LocalizableMenuItem;
import ru.turikhay.tlauncher.ui.login.LoginForm;
import ru.turikhay.tlauncher.ui.notice.NoticeAction;
import ru.turikhay.tlauncher.user.User;

public class ServerNoticeAction
extends NoticeAction {
    private static final int MAX_FAMILY_MEMBERS = 2;
    private final PromotedServer server;
    private final int serverId;
    private final ImageIcon installedVersion;

    ServerNoticeAction(PromotedServer server, int serverId) {
        super("server");
        this.server = Objects.requireNonNull(server, "server");
        this.serverId = serverId;
        this.installedVersion = Images.getIcon16("check-square");
    }

    @Override
    protected ToStringBuilder toStringBuilder() {
        return super.toStringBuilder().append("server", (Object)this.server);
    }

    @Override
    List<? extends JMenuItem> getMenuItemList() {
        ArrayList<JMenuItem> list = new ArrayList<JMenuItem>();
        if (this.server.hasAccountTypeRestriction()) {
            LinkedHashSet<Account.AccountType> accountTypes = new LinkedHashSet<Account.AccountType>(this.server.getAccountTypes());
            boolean supportsFree = accountTypes.remove((Object)Account.AccountType.PLAIN);
            String path = this.L10N_PREFIX + "account." + (supportsFree ? "supported" : "required");
            for (Account.AccountType accountType : accountTypes) {
                LocalizableMenuItem accountItem = new LocalizableMenuItem(path, Localizable.get("account.type." + accountType.name().toLowerCase(Locale.ROOT)));
                accountItem.setEnabled(false);
                if (accountType.getIcon() != null) {
                    accountItem.setDisabledIcon(Images.getIcon16(accountType.getIcon()));
                }
                list.add(accountItem);
            }
        }
        LocalizableMenuItem selectItem = new LocalizableMenuItem(this.L10N_PREFIX + "choose-version", this.server.getName());
        selectItem.setDisabledIcon(Images.getIcon16("play-circle-o"));
        selectItem.setEnabled(false);
        list.add(selectItem);
        LocalizableMenuItem currentItem = new LocalizableMenuItem(this.L10N_PREFIX + "choose-version.current");
        currentItem.addActionListener(e -> {
            VersionSyncInfo vs = TLauncher.getInstance().getFrame().mp.defaultScene.loginForm.versions.getVersion();
            this.startVersion(vs);
        });
        list.add(currentItem);
        if (this.server.getFamily() != null) {
            List<VersionSyncInfo> syncInfoList = ServerNoticeAction.getFamilyMembers(this.server.getFamily(), TLauncher.getInstance().getVersionManager().getVersions(false));
            for (VersionSyncInfo syncInfo : syncInfoList) {
                JMenuItem item = new JMenuItem(syncInfo.getID());
                if (syncInfo.isInstalled() && syncInfo.isUpToDate()) {
                    this.installedVersion.setup(item);
                }
                item.addActionListener(e -> this.startVersion(syncInfo));
                list.add(item);
            }
        }
        return list;
    }

    void startVersion(VersionSyncInfo syncInfo) {
        if (syncInfo == null) {
            return;
        }
        LoginForm lf = TLauncher.getInstance().getFrame().mp.defaultScene.loginForm;
        Account<? extends User> account = lf.accounts.getAccount();
        if (this.server.hasAccountTypeRestriction() && account != null && !this.server.getAccountTypes().contains((Object)account.getType())) {
            String body;
            boolean haveOne;
            Set<Account.AccountType> allowedTypes = this.server.getAccountTypes();
            Collection<Account<? extends User>> accounts = TLauncher.getInstance().getProfileManager().getAuthDatabase().getAccounts();
            if (allowedTypes.size() == 1) {
                Account.AccountType allowedType = allowedTypes.iterator().next();
                haveOne = ServerNoticeAction.haveAccountWithType(accounts, allowedType);
                body = Localizable.get("notice.action.server.account.required.error.single." + (haveOne ? "have" : "register"), Localizable.get("account.type." + allowedType.toString()));
            } else {
                haveOne = false;
                StringBuilder b = new StringBuilder(Localizable.get("notice.action.server.account.required.error.multiple")).append("\n\n");
                for (Account.AccountType allowedType : allowedTypes) {
                    b.append("\u2013 ").append(Localizable.get("account.type." + allowedType.toString())).append('\n');
                    haveOne |= ServerNoticeAction.haveAccountWithType(accounts, allowedType);
                }
                b.append('\n').append(Localizable.get("notice.action.server.account.required.error.multiple." + (haveOne ? "have" : "register")));
                body = b.toString();
            }
            if (!haveOne) {
                TLauncher.getInstance().getFrame().mp.openAccountEditor();
            }
            Alert.showError(Localizable.get("notice.action.server.account.required.error.title"), body, null);
            return;
        }
        TLauncher.getInstance().getFrame().mp.openDefaultScene();
        lf.versions.setSelectedValue(syncInfo);
        lf.startLauncher(this.server, this.serverId);
    }

    static List<VersionSyncInfo> getFamilyMembers(List<String> familyList, List<VersionSyncInfo> syncInfoList) {
        ArrayList<VersionSyncInfo> fullVersionList = new ArrayList<VersionSyncInfo>();
        for (String family : familyList) {
            ArrayList<VersionSyncInfo> curVersionList = new ArrayList<VersionSyncInfo>();
            for (VersionSyncInfo syncInfo : syncInfoList) {
                String currentFamily;
                if (syncInfo.getAvailableVersion().getReleaseType() == ReleaseType.SNAPSHOT || !family.equals(currentFamily = family.equals(syncInfo.getID()) ? family : (syncInfo.getLocalCompleteVersion() != null ? syncInfo.getLocalCompleteVersion().getFamily() : CompleteVersion.getFamilyOf(syncInfo.getID())))) continue;
                curVersionList.add(syncInfo);
            }
            fullVersionList.addAll(ServerNoticeAction.filterLatestVersions(curVersionList));
        }
        return fullVersionList;
    }

    static List<VersionSyncInfo> filterLatestVersions(List<VersionSyncInfo> syncInfoList) {
        syncInfoList.sort((a, b) -> {
            Date aDate = a.getLatestVersion().getReleaseTime();
            Date bDate = b.getLatestVersion().getReleaseTime();
            return aDate != null && bDate != null ? bDate.compareTo(aDate) : 1;
        });
        return syncInfoList.size() > 2 ? syncInfoList.subList(0, 2) : syncInfoList;
    }

    private static boolean haveAccountWithType(Collection<Account<? extends User>> accounts, Account.AccountType type) {
        for (Account<? extends User> acc : accounts) {
            if (acc.getType() != type) continue;
            return true;
        }
        return false;
    }
}

