/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.notice;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import ru.turikhay.tlauncher.ui.block.Blocker;
import ru.turikhay.tlauncher.ui.images.DelayedIcon;
import ru.turikhay.tlauncher.ui.images.Images;
import ru.turikhay.tlauncher.ui.notice.LauncherNoticeAction;
import ru.turikhay.tlauncher.ui.notice.Notice;
import ru.turikhay.tlauncher.ui.notice.NoticeAction;
import ru.turikhay.tlauncher.ui.notice.NoticeEditorPane;
import ru.turikhay.tlauncher.ui.notice.NoticeImage;
import ru.turikhay.tlauncher.ui.notice.NoticeManager;
import ru.turikhay.tlauncher.ui.notice.NoticeTextSize;
import ru.turikhay.tlauncher.ui.notice.ParamPair;
import ru.turikhay.tlauncher.ui.swing.extended.BorderPanel;
import ru.turikhay.tlauncher.ui.swing.extended.ExtendedButton;
import ru.turikhay.tlauncher.ui.swing.extended.ExtendedPanel;
import ru.turikhay.util.SwingUtil;

class NoticeWrapper
extends BorderPanel {
    static final int GAP = 5;
    private static final int BUTTON_ICON_WIDTH = 24;
    private static final int BUTTON_INSETS = 5;
    private final NoticeManager manager;
    final ParamPair paramPair;
    final int fixedIconWidth;
    private Notice notice;
    private final DelayedIcon iconLabel;
    final NoticeEditorPane editorPane;
    final ButtonPane buttonPane;

    public NoticeWrapper(NoticeManager manager, float fontSize, int fixedWidth, int iconWidth) {
        this.setHgap(SwingUtil.magnify(5));
        this.manager = manager;
        if (fixedWidth > 0) {
            this.paramPair = new ParamPair(fontSize, fixedWidth);
            this.fixedIconWidth = iconWidth;
        } else {
            this.paramPair = new ParamPair(fontSize, -1);
            this.fixedIconWidth = 0;
        }
        this.iconLabel = new DelayedIcon();
        this.setWest(this.iconLabel);
        this.editorPane = new NoticeEditorPane();
        this.setCenter(this.editorPane);
        this.buttonPane = new ButtonPane();
        this.setEast(this.buttonPane);
    }

    NoticeWrapper(NoticeManager manager, ParamPair param) {
        this(manager, param.fontSize, param.width, -1);
    }

    void setNotice(Notice notice) {
        this.notice = notice;
        this.editorPane.setNotice(notice, this.paramPair);
        this.buttonPane.updateButton();
    }

    Dimension updateSize() {
        int setIconHeight;
        int setIconWidth;
        Dimension size = this.calcNoticeSize(this.notice);
        if (size.width == 0 && size.height == 0) {
            return null;
        }
        NoticeImage image = this.notice.getImage();
        int additionalWidth = 0;
        if (this.fixedIconWidth > 0 && size.height >= this.fixedIconWidth) {
            setIconWidth = this.fixedIconWidth;
            setIconHeight = 0;
        } else {
            setIconWidth = 0;
            setIconHeight = size.height;
        }
        this.iconLabel.setImage(image, setIconWidth, setIconHeight);
        int iconWidth = this.iconLabel.getIconWidth();
        if (this.fixedIconWidth > 0 && this.fixedIconWidth != iconWidth) {
            additionalWidth += this.fixedIconWidth - iconWidth;
        }
        Dimension buttonSize = this.buttonPane.updateSize(size.height);
        int width = 0;
        width += this.getInsets().left + this.getInsets().right;
        width += this.iconLabel.getInsets().left + this.iconLabel.getInsets().right + iconWidth;
        width += this.getHgap();
        width += size.width + additionalWidth + this.editorPane.getInsets().left + this.editorPane.getInsets().right;
        width += this.getHgap();
        width += buttonSize.width;
        int height = 0;
        height += this.getInsets().top + this.getInsets().bottom;
        return new Dimension(width += this.getHgap(), height += size.height);
    }

    private Dimension calcNoticeSize(Notice notice) {
        if (this.manager == null) {
            return new NoticeTextSize(notice).get(this.paramPair);
        }
        return this.manager.getTextSize(notice, this.paramPair);
    }

    class ButtonPane
    extends ExtendedPanel {
        private final GridBagConstraints c = new GridBagConstraints();
        final Button action;
        final Button extra;

        ButtonPane() {
            this.setInsets(0, 0, 0, 0);
            this.action = new Button();
            this.action.registerAction(e -> {
                if (NoticeWrapper.this.notice == null) {
                    return;
                }
                if (NoticeWrapper.this.notice.getAction() != null) {
                    this.action.popup.clearMenu();
                    NoticeAction noticeAction = NoticeWrapper.this.notice.getAction();
                    for (JMenuItem jMenuItem : noticeAction.getMenuItemList()) {
                        this.action.popup.registerItem(jMenuItem);
                    }
                }
                this.action.popup.show(this.action);
            });
            this.extra = new Button();
            this.setLayout(new GridBagLayout());
            this.c.gridx = 0;
            this.c.gridy = 0;
            this.c.fill = 3;
            this.add((Component)this.action, this.c);
        }

        void updatePopup() {
            this.action.popup.updateMenu();
            this.extra.popup.updateMenu();
        }

        void updateButton() {
            if (NoticeWrapper.this.notice != null && NoticeWrapper.this.notice.getAction() instanceof LauncherNoticeAction) {
                this.action.setGoColorIcon();
            } else {
                this.action.setGoIcon();
            }
        }

        Dimension updateSize(int height) {
            int width;
            if (!this.extra.popup.items.isEmpty() || this.extra.listener != null) {
                boolean hor = height < SwingUtil.magnify(24) * 2;
                int useHeight = hor ? height : height / 2;
                int actionWidth = this.action.updateSize((int)useHeight).width;
                int extraWidth = this.extra.updateSize((int)useHeight).width;
                width = hor ? actionWidth + extraWidth : Math.max(actionWidth, extraWidth);
                this.removeAll();
                this.c.gridx = 0;
                this.c.gridy = 0;
                this.c.anchor = hor ? 17 : 11;
                this.c.fill = hor ? 3 : 2;
                this.add((Component)this.action, this.c);
                if (hor) {
                    ++this.c.gridx;
                } else {
                    ++this.c.gridy;
                }
                this.c.anchor = hor ? 13 : 15;
                this.add((Component)this.extra, this.c);
            } else {
                width = this.action.updateSize((int)height).width;
                this.remove(this.extra);
            }
            return new Dimension(width, height);
        }
    }

    class Popup
    extends JPopupMenu {
        private final List<JMenuItem> items;
        private ActionListener visbilityListener;

        Popup() {
            this.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    if (NoticeWrapper.this.manager != null) {
                        Blocker.block(NoticeWrapper.this.manager, this);
                    }
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                    if (NoticeWrapper.this.manager != null) {
                        Blocker.unblock(NoticeWrapper.this.manager, this);
                    }
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                    if (NoticeWrapper.this.manager != null) {
                        Blocker.unblock(NoticeWrapper.this.manager, this);
                    }
                }
            });
            this.items = new ArrayList<JMenuItem>();
        }

        void clearMenu() {
            this.items.clear();
            this.removeAll();
        }

        void registerItem(JMenuItem item) {
            this.items.add(item);
        }

        void registerVisibilityHandler(ActionListener l) {
            this.visbilityListener = l;
        }

        void updateMenu() {
            this.removeAll();
            if (NoticeWrapper.this.notice == null) {
                return;
            }
            if (!this.items.isEmpty()) {
                for (JMenuItem item : this.items) {
                    if (item == null) {
                        this.addSeparator();
                        continue;
                    }
                    this.add(item);
                }
            }
            if (this.visbilityListener != null) {
                this.visbilityListener.actionPerformed(null);
            }
        }

        void show(Component comp) {
            this.updateMenu();
            this.show(comp, comp.getWidth(), 0);
        }
    }

    class Button
    extends ExtendedButton {
        final Popup popup;
        private ActionListener listener;

        Button() {
            this.setMargin(new Insets(0, 0, 0, 0));
            this.popup = new Popup();
            this.setIcon(Images.getIcon24("ellipsis-v"));
            this.addActionListener(e -> {
                if (this.listener != null) {
                    this.listener.actionPerformed(e);
                } else {
                    this.popup.show(this);
                }
            });
        }

        void setGoIcon() {
            this.setIcon(Images.getIcon24("play-circle-o"));
        }

        void setGoColorIcon() {
            this.setIcon(Images.getIcon24("play-circle-o-1"));
        }

        void registerAction(ActionListener l) {
            this.setGoIcon();
            this.listener = l;
        }

        Dimension updateSize(int height) {
            int insets = SwingUtil.magnify(5) * 2;
            Dimension size = new Dimension(insets + 24, height);
            this.setPreferredSize(size);
            return size;
        }
    }
}

