/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.notice;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JPopupMenu;
import ru.turikhay.tlauncher.TLauncher;
import ru.turikhay.tlauncher.stats.Stats;
import ru.turikhay.tlauncher.ui.TLauncherFrame;
import ru.turikhay.tlauncher.ui.block.BlockableButton;
import ru.turikhay.tlauncher.ui.block.Blocker;
import ru.turikhay.tlauncher.ui.center.CenterPanel;
import ru.turikhay.tlauncher.ui.images.Images;
import ru.turikhay.tlauncher.ui.loc.LocalizableComponent;
import ru.turikhay.tlauncher.ui.loc.LocalizableMenuItem;
import ru.turikhay.tlauncher.ui.notice.Notice;
import ru.turikhay.tlauncher.ui.notice.NoticeManager;
import ru.turikhay.tlauncher.ui.notice.NoticeWrapper;
import ru.turikhay.tlauncher.ui.scenes.DefaultScene;
import ru.turikhay.tlauncher.ui.swing.Del;
import ru.turikhay.tlauncher.ui.swing.MagnifiedInsets;
import ru.turikhay.tlauncher.ui.swing.ScrollPane;
import ru.turikhay.tlauncher.ui.swing.extended.BorderPanel;
import ru.turikhay.tlauncher.ui.swing.extended.ExtendedButton;
import ru.turikhay.tlauncher.ui.swing.extended.ExtendedPanel;
import ru.turikhay.util.SwingUtil;

public class NoticeSidePanel
extends CenterPanel
implements LocalizableComponent {
    private static final int BUTTON_IMAGE_SIZE = 24;
    private static final int BUTTON_PANEL_HEIGHT = 36;
    private static final int NOTICE_IMAGE_SIZE = 48;
    private final DefaultScene scene;
    private final NoticeManager noticeManager;
    private final ExtendedPanel panel;
    private final ButtonPanel buttonPanel;
    private final int workHeight;
    private final List<Page> pages = new ArrayList<Page>();
    private Page page;
    private int pageNumber;

    public NoticeSidePanel(DefaultScene scene) {
        super(new MagnifiedInsets(15, 15, 10, 15));
        this.scene = scene;
        this.setSize(SwingUtil.magnify(new Dimension(600, 550)));
        BorderPanel wrapper = new BorderPanel();
        wrapper.setInsets(0, 0, 0, 0);
        this.add((Component)wrapper);
        this.panel = new ExtendedPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        this.panel.setInsets(0, 0, 0, 0);
        ScrollPane scrollPane = new ScrollPane(this.panel, ScrollPane.ScrollBarPolicy.AS_NEEDED, ScrollPane.ScrollBarPolicy.NEVER, false);
        scrollPane.setBorder(null);
        wrapper.setCenter(scrollPane);
        this.buttonPanel = new ButtonPanel();
        wrapper.setSouth(this.buttonPanel);
        this.workHeight = this.getHeight() - this.getInsets().top - this.getInsets().bottom - this.buttonPanel.controlButton.getInsets().top - this.buttonPanel.controlButton.getInsets().bottom - SwingUtil.magnify(36);
        this.noticeManager = scene.getMainPane().getRootFrame().getNotices();
        this.updateLocale();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                if (NoticeSidePanel.this.page != null) {
                    Stats.noticeListViewed(NoticeSidePanel.this.page.noticeList);
                }
            }
        });
    }

    private void fillPages(List<Notice> noticeList) {
        this.pages.clear();
        if (noticeList == null) {
            return;
        }
        Page page = new Page();
        for (Notice notice : noticeList) {
            NoticeWrapper wrapper = new NoticeWrapper(this.noticeManager, TLauncherFrame.getFontSize(), this.getWidth() - SwingUtil.magnify(5) * 2 - this.getInsets().left - this.getInsets().right - SwingUtil.magnify(48) - SwingUtil.magnify(32), SwingUtil.magnify(48));
            wrapper.setNotice(notice);
            Dimension size = wrapper.updateSize();
            if (size == null) continue;
            wrapper.setMaximumSize(size);
            Del del = this.del(0);
            int height = size.height + 15;
            if (page.height + height > this.workHeight) {
                this.pages.add(page);
                page = new Page();
            }
            page.height += height;
            page.list.add(wrapper);
            page.list.add(del);
            page.noticeList.add(notice);
        }
        if (!page.list.isEmpty()) {
            this.pages.add(page);
        }
    }

    private void renderPage(int i) {
        this.pageNumber = i;
        this.panel.removeAll();
        Blocker.setBlocked(this.buttonPanel.left, "firstPage", i < 1);
        Blocker.setBlocked(this.buttonPanel.right, "lastPage", i + 1 >= this.pages.size());
        boolean invisible = Blocker.isBlocked(this.buttonPanel.left) && Blocker.isBlocked(this.buttonPanel.right);
        this.buttonPanel.setEast(null);
        this.buttonPanel.setWest(null);
        if (invisible) {
            this.buttonPanel.setEast(this.buttonPanel.controlButton);
        } else {
            this.buttonPanel.setWest(this.buttonPanel.controlButton);
            this.buttonPanel.setEast(this.buttonPanel.pageButtons);
        }
        if (i < 0 || i >= this.pages.size()) {
            return;
        }
        this.page = this.pages.get(i);
        for (Component comp : this.page.list) {
            this.panel.add(comp);
        }
        this.setSize(SwingUtil.magnify(600), this.page.height + SwingUtil.magnify(75));
        this.validate();
        this.repaint();
        if (TLauncher.getInstance() != null && TLauncher.getInstance().isReady() && this.page != null) {
            Stats.noticeListViewed(this.page.noticeList);
        }
    }

    @Override
    public void updateLocale() {
        List<Notice> list = this.noticeManager.getForCurrentLocale();
        this.fillPages(list);
        this.renderPage(0);
    }

    private static class Page {
        private final List<Component> list = new ArrayList<Component>();
        private final List<Notice> noticeList = new ArrayList<Notice>();
        private int height;

        Page() {
        }
    }

    private class ButtonPanel
    extends BorderPanel {
        final JPopupMenu popup = new JPopupMenu();
        final LocalizableMenuItem promotedItem;
        ExtendedButton controlButton;
        final ExtendedPanel pageButtons;
        final BlockableButton left;
        final BlockableButton right;

        ButtonPanel() {
            this.setPreferredSize(new Dimension(NoticeSidePanel.this.getWidth() - NoticeSidePanel.this.getInsets().left - NoticeSidePanel.this.getInsets().right, SwingUtil.magnify(36)));
            this.setMaximumSize(new Dimension(Integer.MAX_VALUE, SwingUtil.magnify(36)));
            this.promotedItem = new LocalizableMenuItem();
            this.promotedItem.addActionListener(e -> this.togglePromoted());
            this.popup.add(this.promotedItem);
            this.refreshPromoted();
            this.popup.add(LocalizableMenuItem.newItem("notice.sidepanel.control.restore", "refresh", e -> NoticeSidePanel.this.noticeManager.restoreHidden()));
            this.popup.addSeparator();
            this.popup.add(LocalizableMenuItem.newItem("notice.sidepanel.control.hide", "compress", e -> NoticeSidePanel.this.scene.setNoticeSidePanelEnabled(false)));
            this.controlButton = this.newButton("bars", e -> {
                this.refreshPromoted();
                this.popup.show(this.controlButton, 0, this.controlButton.getHeight());
            });
            this.pageButtons = new ExtendedPanel();
            this.pageButtons.setInsets(0, 0, 0, 0);
            this.pageButtons.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 3;
            c.gridx = -1;
            c.insets = new Insets(0, SwingUtil.magnify(2), 0, SwingUtil.magnify(2));
            c.weighty = 1.0;
            ++c.gridx;
            this.left = this.newButton("arrow-left", e -> NoticeSidePanel.this.renderPage(NoticeSidePanel.this.pageNumber - 1));
            this.pageButtons.add((Component)this.left, c);
            ++c.gridx;
            this.right = this.newButton("arrow-right", e -> NoticeSidePanel.this.renderPage(NoticeSidePanel.this.pageNumber + 1));
            this.pageButtons.add((Component)this.right, c);
        }

        BlockableButton newButton(String path, ActionListener listener) {
            BlockableButton button = new BlockableButton(Images.getIcon24(path));
            button.addActionListener(listener);
            return button;
        }

        private void togglePromoted() {
            boolean current = NoticeSidePanel.this.noticeManager.isPromotedAllowed();
            NoticeSidePanel.this.noticeManager.setPromotedAllowed(!current);
            this.refreshPromoted();
        }

        private void refreshPromoted() {
            String image;
            boolean enabled = TLauncher.getInstance().getSettings().getBoolean("notice.promoted");
            String path = "notice.promoted.";
            if (enabled) {
                path = path + "hide";
                image = "eye-slash";
            } else {
                path = path + "restore";
                image = "eye";
            }
            this.promotedItem.setText(path);
            this.promotedItem.setIcon(Images.getIcon16(image));
        }
    }
}

