/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.notice;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JMenuItem;
import ru.turikhay.tlauncher.ui.TLauncherFrame;
import ru.turikhay.tlauncher.ui.block.Blockable;
import ru.turikhay.tlauncher.ui.block.Blocker;
import ru.turikhay.tlauncher.ui.center.CenterPanel;
import ru.turikhay.tlauncher.ui.notice.Notice;
import ru.turikhay.tlauncher.ui.notice.NoticeManager;
import ru.turikhay.tlauncher.ui.notice.NoticeManagerListener;
import ru.turikhay.tlauncher.ui.notice.NoticeWrapper;
import ru.turikhay.tlauncher.ui.notice.ParamPair;
import ru.turikhay.tlauncher.ui.swing.MagnifiedInsets;

public class NoticePanel
extends CenterPanel
implements Blockable,
NoticeManagerListener {
    private final NoticeWrapper noticeWrapper;
    protected final NoticeManager manager;
    private Notice notice;

    public NoticePanel(NoticeManager manager, float fontSize) {
        super(CenterPanel.tipTheme, new MagnifiedInsets(8, 10, 8, 10));
        this.setInsets(0, 0, 0, 0);
        this.manager = manager;
        this.noticeWrapper = new NoticeWrapper(manager, new ParamPair(fontSize, -1));
        this.add((Component)this.noticeWrapper);
    }

    public NoticePanel(NoticeManager manager) {
        this(manager, TLauncherFrame.getFontSize());
    }

    public final Notice getNotice() {
        return this.notice;
    }

    public final void setNotice(Notice notice) {
        this.notice = notice;
        this.updateNotice();
    }

    protected void updateNotice() {
        if (this.notice == null) {
            this.setSize(0, 0);
            return;
        }
        this.noticeWrapper.setNotice(this.notice);
        Dimension insets = new Dimension(this.getInsets().left + this.getInsets().right, this.getInsets().top + this.getInsets().bottom);
        Dimension noticeSize = this.noticeWrapper.updateSize();
        if (noticeSize == null) {
            this.setSize(0, 0);
            return;
        }
        int width = 0;
        width += insets.width;
        width += noticeSize.width;
        int height = 0;
        height += insets.height;
        this.setSize(width += 5, height += noticeSize.height);
    }

    public void redraw() {
        if (this.getGraphics() != null) {
            this.update(this.getGraphics());
        }
    }

    protected void registerExtraItems(JMenuItem ... items) {
        this.noticeWrapper.buttonPane.extra.popup.clearMenu();
        for (JMenuItem item : items) {
            this.noticeWrapper.buttonPane.extra.popup.registerItem(item);
        }
    }

    @Override
    public void block(Object var1) {
        Blocker.blockComponents(var1, this.noticeWrapper);
    }

    @Override
    public void unblock(Object var1) {
        Blocker.unblockComponents(var1, this.noticeWrapper);
    }

    @Override
    public void onNoticeSelected(Notice notice) {
        this.setNotice(notice);
    }

    @Override
    public void onNoticePromoted(Notice promotedNotice) {
    }
}

