/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.notice;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.tlauncher.configuration.BootConfiguration;
import ru.turikhay.tlauncher.configuration.LangConfiguration;
import ru.turikhay.tlauncher.stats.Stats;
import ru.turikhay.tlauncher.ui.TLauncherFrame;
import ru.turikhay.tlauncher.ui.block.Blockable;
import ru.turikhay.tlauncher.ui.loc.LocalizableComponent;
import ru.turikhay.tlauncher.ui.notice.Notice;
import ru.turikhay.tlauncher.ui.notice.NoticeManagerListener;
import ru.turikhay.tlauncher.ui.notice.NoticeTextSize;
import ru.turikhay.tlauncher.ui.notice.ParamPair;
import ru.turikhay.util.U;

public final class NoticeManager
implements LocalizableComponent,
Blockable {
    private static final Logger LOGGER = LogManager.getLogger(NoticeManager.class);
    private static final int HIDDEN_DELAY = 604800000;
    private final TLauncherFrame frame;
    private final List<NoticeManagerListener> listeners = new ArrayList<NoticeManagerListener>();
    private final Map<Locale, List<Notice>> byLocaleMap = new HashMap<Locale, List<Notice>>();
    private final Map<Notice, NoticeTextSize> cachedSizeMap = new HashMap<Notice, NoticeTextSize>();
    private Notice selectedNotice;
    private Notice promotedNotice;
    private boolean forceSelected;

    NoticeManager(TLauncherFrame frame, Map<String, List<Notice>> config) {
        this.frame = frame;
        if (!config.isEmpty()) {
            for (Map.Entry<String, List<Notice>> entry : config.entrySet()) {
                String key = entry.getKey();
                Locale locale = U.getLocale(entry.getKey());
                if (locale == null) {
                    LOGGER.warn("Couldn't parse locale: {}", (Object)key);
                    continue;
                }
                if (entry.getValue() == null) {
                    LOGGER.warn("Notice list is null: {}", (Object)key);
                    continue;
                }
                if (entry.getValue().isEmpty()) {
                    LOGGER.debug("Notice list is empty: {}", (Object)key);
                    continue;
                }
                ArrayList<Notice> noticeList = new ArrayList<Notice>();
                for (Notice notice : entry.getValue()) {
                    if (notice == null) {
                        LOGGER.warn("Found null selectedNotice in {}", (Object)key);
                        continue;
                    }
                    noticeList.add(notice);
                    NoticeTextSize textSize = new NoticeTextSize(notice);
                    textSize.get(new ParamPair(TLauncherFrame.getFontSize(), -1));
                    this.cachedSizeMap.put(notice, textSize);
                }
                Collections.shuffle(noticeList);
                noticeList.sort(Comparator.comparingInt(Notice::getPos));
                this.byLocaleMap.put(locale, Collections.unmodifiableList(noticeList));
                LOGGER.debug("Added {} notices for {}", (Object)noticeList.size(), (Object)locale);
            }
            if (frame != null) {
                List<Notice> globalNoticeList;
                Locale ruRU = U.getLocale("ru_RU");
                Locale ukUA = U.getLocale("uk_UA");
                if (ruRU != null && ukUA != null && this.byLocaleMap.get(ruRU) != null && this.byLocaleMap.get(ukUA) == null) {
                    this.byLocaleMap.put(ukUA, this.byLocaleMap.get(ruRU));
                }
                if ((globalNoticeList = this.byLocaleMap.get(Locale.US)) != null) {
                    for (Locale locale : LangConfiguration.getAvailableLocales()) {
                        this.byLocaleMap.putIfAbsent(locale, globalNoticeList);
                    }
                }
            }
            this.selectRandom();
        } else {
            LOGGER.debug("Notice map is empty");
        }
    }

    public NoticeManager(TLauncherFrame frame, BootConfiguration config) {
        this(frame, config.getNotices());
    }

    public void addListener(NoticeManagerListener l, boolean updateImmidiately) {
        this.listeners.add(Objects.requireNonNull(l, "listener"));
        l.onNoticeSelected(this.selectedNotice);
        if (this.promotedNotice != null) {
            Notice promoted = this.promotedNotice;
            l.onNoticePromoted(promoted);
        }
    }

    public Notice getSelectedNotice() {
        return this.selectedNotice;
    }

    public Notice getPromotedNotice() {
        return this.promotedNotice;
    }

    public List<Notice> getForCurrentLocale() {
        if (this.frame == null) {
            return null;
        }
        Locale currentLocale = this.frame.getLauncher().getLang().getLocale();
        return this.getForLocale(currentLocale);
    }

    public List<Notice> getForLocale(Locale locale) {
        return this.byLocaleMap.get(Objects.requireNonNull(locale, "locale"));
    }

    public void selectNotice(Notice notice, boolean forceSet) {
        if (this.forceSelected && !forceSet) {
            return;
        }
        this.selectedNotice = notice;
        this.forceSelected = notice != null && forceSet;
        for (NoticeManagerListener l : this.listeners) {
            l.onNoticeSelected(notice);
        }
    }

    public void setPromoted(Notice promoted) {
        this.promotedNotice = promoted;
        for (NoticeManagerListener l : this.listeners) {
            l.onNoticePromoted(promoted);
        }
    }

    public boolean isPromotedAllowed() {
        return this.frame.getLauncher().getSettings().getBoolean("notice.promoted");
    }

    public void setPromotedAllowed(boolean allowPromoted) {
        this.frame.getLauncher().getSettings().set("notice.promoted", (Object)allowPromoted);
        if (allowPromoted) {
            this.pickPromoted(this.getForCurrentLocale());
        } else {
            this.setPromoted(null);
        }
    }

    private NoticeTextSize getTextSize(Notice notice) {
        Objects.requireNonNull(notice, "notice");
        NoticeTextSize cachedSize = this.cachedSizeMap.get(notice);
        if (cachedSize == null) {
            cachedSize = new NoticeTextSize(notice);
            this.cachedSizeMap.put(notice, cachedSize);
        }
        return cachedSize;
    }

    Dimension getTextSize(Notice notice, ParamPair param) {
        return this.getTextSize(notice).get(param);
    }

    public boolean isHidden(Notice notice) {
        if (notice == null) {
            return false;
        }
        long expiryDate = this.frame.getLauncher().getSettings().getLong("notice.id." + notice.getId());
        if (System.currentTimeMillis() > expiryDate) {
            this.setHidden(notice, false, false);
            return false;
        }
        return true;
    }

    private void setHidden(Notice notice, boolean hidden, boolean notify) {
        if (notify) {
            if (hidden) {
                Stats.noticeHiddenByUser(notice);
            } else {
                Stats.noticeShownByUser(notice);
            }
        }
        this.frame.getLauncher().getSettings().set("notice.id." + notice.getId(), hidden ? Long.valueOf(System.currentTimeMillis() + 604800000L) : null);
        if (hidden && this.selectedNotice == notice) {
            this.selectNotice(null, true);
        }
        if (hidden && this.promotedNotice == notice) {
            this.setPromoted(null);
        }
    }

    public void setHidden(Notice notice, boolean hidden) {
        this.setHidden(notice, hidden, true);
    }

    private void setAllHidden(boolean hidden) {
        List<Notice> noticeList = this.getForCurrentLocale();
        if (noticeList == null || noticeList.isEmpty()) {
            return;
        }
        for (Notice notice : noticeList) {
            this.setHidden(notice, hidden, false);
        }
    }

    public void setAllHidden() {
        this.setAllHidden(true);
    }

    public void restoreHidden() {
        this.setAllHidden(false);
        this.selectRandom();
    }

    @Override
    public void updateLocale() {
        this.selectRandom();
    }

    public void selectRandom() {
        Notice selected = null;
        List<Notice> list = this.getForCurrentLocale();
        if (!this.frame.getLauncher().isNoticeDisabled() && list != null) {
            ArrayList<Notice> available = new ArrayList<Notice>();
            for (Notice notice : list) {
                if (this.isHidden(notice)) continue;
                available.add(notice);
            }
            if (!available.isEmpty()) {
                selected = (Notice)available.get(new Random().nextInt(available.size()));
            }
        }
        this.pickPromoted(list);
        this.selectNotice(selected, false);
    }

    private void pickPromoted(List<Notice> list) {
        Notice promoted = null;
        boolean promotedAllowed = this.isPromotedAllowed();
        if (promotedAllowed && list != null) {
            for (Notice notice : list) {
                if (!notice.isPromoted() || this.isHidden(notice)) continue;
                promoted = notice;
                break;
            }
        }
        this.promotedNotice = promoted;
        for (NoticeManagerListener l : this.listeners) {
            l.onNoticePromoted(promoted);
        }
    }

    @Override
    public void block(Object var1) {
    }

    @Override
    public void unblock(Object var1) {
    }
}

