/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.notice;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import ru.turikhay.tlauncher.minecraft.PromotedServer;
import ru.turikhay.tlauncher.ui.notice.DirectNoticeImage;
import ru.turikhay.tlauncher.ui.notice.LauncherNoticeAction;
import ru.turikhay.tlauncher.ui.notice.Notice;
import ru.turikhay.tlauncher.ui.notice.NoticeAction;
import ru.turikhay.tlauncher.ui.notice.NoticeImage;
import ru.turikhay.tlauncher.ui.notice.ServerNoticeAction;
import ru.turikhay.tlauncher.ui.notice.UrlNoticeAction;
import ru.turikhay.tlauncher.ui.notice.UrlNoticeImage;
import ru.turikhay.util.SwingUtil;
import ru.turikhay.util.U;

public class NoticeDeserializer
implements JsonDeserializer<Notice> {
    public Notice deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject root = json.getAsJsonObject();
        int id = root.get("id").getAsInt();
        int pos = root.has("pos") ? root.get("pos").getAsInt() : -1;
        String text = root.get("text").getAsString();
        text = StringUtils.replace((String)StringUtils.replace((String)text, (String)"<nobr>", (String)"<span style=\"white-space: nowrap;\">"), (String)"</nobr>", (String)"</span>");
        NoticeImage image = this.parseImage(root, context);
        NoticeAction action = this.parseAction(id, root, context);
        Notice notice = new Notice(id, pos, text, image, action);
        if (root.has("promoted") && root.get("promoted").getAsBoolean()) {
            notice.setPromoted(true);
        }
        return notice;
    }

    private NoticeImage parseImage(JsonObject root, JsonDeserializationContext context) {
        JsonElement elem = Objects.requireNonNull(root.get("image"));
        if (elem.isJsonObject()) {
            return this.parseImageObject(elem.getAsJsonObject(), context);
        }
        String imageSrc = elem.getAsString();
        try {
            return new DirectNoticeImage(SwingUtil.base64ToImage(imageSrc));
        }
        catch (Exception exception) {
            NoticeImage image = UrlNoticeImage.getDefinedImages().get(imageSrc);
            if (image != null) {
                return image;
            }
            throw new IllegalArgumentException("could not parse image: \"" + imageSrc + "\"");
        }
    }

    private NoticeImage parseImageObject(JsonObject object, JsonDeserializationContext context) {
        URL url = Objects.requireNonNull((URL)context.deserialize(object.get("url"), URL.class));
        int width = object.get("width").getAsInt();
        int height = object.get("height").getAsInt();
        return new UrlNoticeImage(url, width, height);
    }

    private NoticeAction parseAction(int noticeId, JsonObject root, JsonDeserializationContext context) {
        JsonObject actionObject = root.getAsJsonObject("action");
        if (actionObject == null) {
            return null;
        }
        String type = actionObject.get("type").getAsString();
        if ("url".equals(type)) {
            return new UrlNoticeAction(actionObject.get("name").getAsString(), U.makeURL(actionObject.get("url").getAsString(), true));
        }
        if ("server".equals(type)) {
            return new ServerNoticeAction((PromotedServer)context.deserialize((JsonElement)actionObject.getAsJsonObject("server"), PromotedServer.class), noticeId);
        }
        if ("launcher".equals(type)) {
            return new LauncherNoticeAction(actionObject.get("launcher").getAsString(), actionObject.has("url") ? actionObject.get("url").getAsString() : null);
        }
        throw new IllegalArgumentException("unknown action type: " + type);
    }
}

