/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.notice;

import java.util.Objects;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import ru.turikhay.tlauncher.ui.notice.NoticeAction;
import ru.turikhay.tlauncher.ui.notice.NoticeImage;
import ru.turikhay.util.StringUtil;

public final class Notice {
    private final int id;
    private final int pos;
    private final String text;
    private final NoticeImage image;
    private final NoticeAction action;
    private boolean promoted;

    Notice(int id, int pos, String text, NoticeImage image, NoticeAction action) {
        this.id = id;
        this.pos = pos;
        this.text = StringUtil.requireNotBlank(text, "text");
        this.image = Objects.requireNonNull(image, "image");
        this.action = action;
    }

    public int getId() {
        return this.id;
    }

    public int getPos() {
        return this.pos;
    }

    public String getText() {
        return this.text;
    }

    public NoticeImage getImage() {
        return this.image;
    }

    public NoticeAction getAction() {
        return this.action;
    }

    public boolean isPromoted() {
        return this.promoted;
    }

    public void setPromoted(boolean promoted) {
        this.promoted = promoted;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("id", this.id).append("pos", this.pos).append("text", (Object)(this.text.length() > 30 ? this.text.substring(0, 27) + "..." : this.text)).append("image", (Object)this.image).append("action", (Object)this.action).build();
    }
}

