/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.notice;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import ru.turikhay.tlauncher.TLauncher;
import ru.turikhay.tlauncher.stats.Stats;
import ru.turikhay.tlauncher.ui.images.Images;
import ru.turikhay.tlauncher.ui.loc.LocalizableMenuItem;
import ru.turikhay.tlauncher.ui.notice.NoticePanel;
import ru.turikhay.tlauncher.ui.scenes.DefaultScene;
import ru.turikhay.tlauncher.ui.swing.ResizeableComponent;

public class MainNoticePanel
extends NoticePanel
implements ResizeableComponent {
    private static final int SAFE_ZONE = 10;
    private final DefaultScene defaultScene;
    private final LocalizableMenuItem hideNotice = new LocalizableMenuItem("notice.action.hide");
    private final LocalizableMenuItem hideAllNotices;
    private final LocalizableMenuItem openNoticeScene;

    public MainNoticePanel(DefaultScene scene) {
        super(scene.getMainPane().getRootFrame().getNotices());
        Images.getIcon16("eye-slash").setup(this.hideNotice);
        this.hideNotice.addActionListener(e -> {
            if (this.getNotice() != null) {
                this.manager.setHidden(this.getNotice(), true);
                this.manager.selectRandom();
            }
        });
        this.hideAllNotices = new LocalizableMenuItem("notice.action.hide-all");
        Images.getIcon16("remove").setup(this.hideAllNotices);
        this.hideAllNotices.addActionListener(e -> {
            this.manager.setAllHidden();
            this.manager.selectNotice(null, true);
        });
        this.openNoticeScene = new LocalizableMenuItem("notice.action.scene");
        Images.getIcon16("expand").setup(this.openNoticeScene);
        this.openNoticeScene.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainNoticePanel.this.defaultScene.setNoticeSidePanelEnabled(true);
                ((MainNoticePanel)MainNoticePanel.this).defaultScene.getMainPane().defaultScene.setSidePanel(DefaultScene.SidePanel.NOTICES);
            }
        });
        this.defaultScene = scene;
        this.registerExtraItems(this.openNoticeScene, null, this.hideNotice);
        scene.getMainPane().getRootFrame().getNotices().addListener(this, true);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                MainNoticePanel.this.noticeSeen();
            }
        });
    }

    private void noticeSeen() {
        if (this.isVisible() && this.getNotice() != null && (TLauncher.getInstance() == null || TLauncher.getInstance().getMinecraftLauncher() == null || !TLauncher.getInstance().getMinecraftLauncher().isWorking())) {
            Stats.noticeViewed(this.getNotice());
        }
    }

    @Override
    protected void updateNotice() {
        super.updateNotice();
        if (TLauncher.getInstance() != null && TLauncher.getInstance().isReady()) {
            this.onResize();
        }
        this.noticeSeen();
    }

    @Override
    public void onResize() {
        int y;
        if (this.getNotice() == null) {
            return;
        }
        Point loginFormLocation = this.defaultScene.loginForm.getLocation();
        Dimension loginFormSize = this.defaultScene.loginForm.getSize();
        int fullWidth = this.getWidth();
        int height = this.getHeight();
        int x = loginFormLocation.x + loginFormSize.width / 2 - fullWidth / 2;
        if (x + fullWidth > this.defaultScene.getWidth() - 10) {
            x = this.defaultScene.getWidth() - fullWidth - 10;
        } else if (x < 10) {
            x = 10;
        }
        switch (this.defaultScene.getLoginFormDirection()) {
            case TOP_LEFT: 
            case TOP: 
            case TOP_RIGHT: 
            case CENTER_LEFT: 
            case CENTER: 
            case CENTER_RIGHT: {
                y = loginFormLocation.y + loginFormSize.height + 10;
                break;
            }
            case BOTTOM_LEFT: 
            case BOTTOM: 
            case BOTTOM_RIGHT: {
                y = loginFormLocation.y - height - 10;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        if (y + height > this.defaultScene.getHeight() - 10) {
            y = this.defaultScene.getHeight() - height - 10;
        } else if (y < 10) {
            y = 10;
        }
        this.setLocation(x, y);
    }
}

