/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.notice;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenuItem;
import net.minecraft.launcher.updater.VersionSyncInfo;
import ru.turikhay.tlauncher.TLauncher;
import ru.turikhay.tlauncher.ui.alert.Alert;
import ru.turikhay.tlauncher.ui.loc.LocalizableMenuItem;
import ru.turikhay.tlauncher.ui.login.LoginForm;
import ru.turikhay.tlauncher.ui.notice.NoticeAction;
import ru.turikhay.util.OS;

public class LauncherNoticeAction
extends NoticeAction {
    private final String launcherName;
    private final String downloadUrl;

    LauncherNoticeAction(String launcherName, String downloadUrl) {
        super("launcher");
        this.launcherName = launcherName;
        this.downloadUrl = downloadUrl;
    }

    @Override
    List<? extends JMenuItem> getMenuItemList() {
        ArrayList<LocalizableMenuItem> list = new ArrayList<LocalizableMenuItem>();
        LocalizableMenuItem launchItem = new LocalizableMenuItem(this.L10N_PREFIX + "start", this.launcherName);
        launchItem.addActionListener(e -> this.startLauncher());
        list.add(launchItem);
        if (this.downloadUrl != null) {
            LocalizableMenuItem downloadItem = new LocalizableMenuItem(this.L10N_PREFIX + "download");
            downloadItem.addActionListener(e -> OS.openLink(this.downloadUrl));
            list.add(downloadItem);
        }
        return list;
    }

    private void startLauncher() {
        VersionSyncInfo vs = TLauncher.getInstance().getVersionManager().getVersionSyncInfo(this.launcherName);
        if (vs == null) {
            if (this.downloadUrl == null) {
                Alert.showLocError(this.L10N_PREFIX + "start.error.not-found");
            } else if (Alert.showLocQuestion(this.L10N_PREFIX + "start.error.not-found.download")) {
                OS.openLink(this.downloadUrl);
            }
            return;
        }
        LoginForm lf = TLauncher.getInstance().getFrame().mp.defaultScene.loginForm;
        lf.startLauncher(vs, null, 0);
    }
}

