/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.login.buttons;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import ru.turikhay.tlauncher.TLauncher;
import ru.turikhay.tlauncher.configuration.Configuration;
import ru.turikhay.tlauncher.ui.alert.Alert;
import ru.turikhay.tlauncher.ui.block.Blockable;
import ru.turikhay.tlauncher.ui.images.ImageIcon;
import ru.turikhay.tlauncher.ui.images.Images;
import ru.turikhay.tlauncher.ui.loc.Localizable;
import ru.turikhay.tlauncher.ui.loc.LocalizableButton;
import ru.turikhay.tlauncher.ui.loc.LocalizableMenuItem;
import ru.turikhay.tlauncher.ui.login.LoginForm;
import ru.turikhay.tlauncher.ui.support.PreSupportFrame;
import ru.turikhay.tlauncher.ui.swing.DelayedComponent;
import ru.turikhay.tlauncher.ui.swing.DelayedComponentLoader;
import ru.turikhay.util.OS;

public class SupportButton
extends LocalizableButton
implements Blockable {
    private DelayedComponent<PreSupportFrame> supportFrame;
    private final ActionListener showSupportFrame = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            SupportButton.this.loadSupportFrame();
            if (!((PreSupportFrame)SupportButton.this.supportFrame.get()).isVisible()) {
                ((PreSupportFrame)SupportButton.this.supportFrame.get()).showAtCenter();
            }
        }
    };
    private final HashMap<String, SupportMenu> localeMap = new HashMap();
    SupportMenu menu;

    SupportButton(LoginForm loginForm) {
        this.localeMap.put("ru_RU", new SupportMenu("info-circle").add("loginform.button.support.vk", Images.getIcon16("logo-vk"), SupportButton.actionURL("https://llaun.ch/vk")).add("loginform.button.support.discord", Images.getIcon16("logo-discord"), SupportButton.actionURL("https://llaun.ch/discord/ru")).addSeparator().add("loginform.button.support", Images.getIcon16("life-ring"), this.showSupportFrame));
        this.localeMap.put("uk_UA", new SupportMenu("info-circle").add("loginform.button.support.discord", Images.getIcon16("logo-discord"), SupportButton.actionURL("https://llaun.ch/discord/ru")).addSeparator().add("loginform.button.support", Images.getIcon16("life-ring"), this.showSupportFrame));
        this.localeMap.put("en_US", new SupportMenu("comments-o").add("loginform.button.support.discord", Images.getIcon16("logo-discord"), SupportButton.actionURL("https://llaun.ch/discord/intl")).addSeparator().add("loginform.button.support", Images.getIcon16("life-ring"), this.showSupportFrame));
        this.setToolTipText("loginform.button.support");
        this.addActionListener(e -> {
            if (this.menu != null) {
                this.menu.showPopup();
            }
        });
        this.updateLocale();
    }

    private void loadSupportFrame() {
        PreSupportFrame oldSupportFrame = this.supportFrame == null ? null : this.supportFrame.get();
        this.supportFrame = new DelayedComponent<PreSupportFrame>(new DelayedComponentLoader<PreSupportFrame>(){

            @Override
            public PreSupportFrame loadComponent() {
                return new PreSupportFrame();
            }

            @Override
            public void onComponentLoaded(PreSupportFrame loaded) {
                TLauncher.getInstance().reloadLocale();
            }
        });
        if (oldSupportFrame != null && oldSupportFrame.isVisible()) {
            oldSupportFrame.dispose();
            this.supportFrame.get().showAtCenter();
        }
    }

    void setLocale(String locale) {
        if (this.menu != null) {
            this.menu.popup.setVisible(false);
        }
        this.menu = this.localeMap.get(locale);
        if (this.menu == null) {
            this.setIcon(null);
            this.setEnabled(false);
        } else {
            this.setIcon(this.menu.icon);
            this.setEnabled(true);
        }
    }

    @Override
    public void block(Object reason) {
    }

    @Override
    public void unblock(Object reason) {
    }

    @Override
    public void updateLocale() {
        super.updateLocale();
        if (this.supportFrame != null && this.supportFrame.isLoaded()) {
            this.loadSupportFrame();
        }
        String selectedLocale = TLauncher.getInstance().getSettings().getLocale().toString();
        String newLocale = null;
        for (String locale : this.localeMap.keySet()) {
            if (!locale.equals(selectedLocale)) continue;
            newLocale = locale;
            break;
        }
        if (newLocale == null) {
            newLocale = Configuration.isLikelyRussianSpeakingLocale(selectedLocale) ? "ru_RU" : "en_US";
        }
        this.setLocale(newLocale);
    }

    private static ActionListener actionURL(String rawURL) {
        URL tryURL;
        try {
            tryURL = new URL(rawURL);
        }
        catch (MalformedURLException muE) {
            throw new RuntimeException(muE);
        }
        URL url = tryURL;
        return e -> OS.openLink(url);
    }

    private static ActionListener actionAlert(String msgPath, Object textArea) {
        return e -> Alert.showLocMessage(msgPath, textArea);
    }

    private class SupportMenu {
        final ImageIcon icon;
        final JPopupMenu popup = new JPopupMenu();

        SupportMenu(String icon) {
            this.icon = Images.getIcon24(icon);
        }

        void showPopup() {
            Localizable.updateContainer(this.popup);
            this.popup.show(SupportButton.this, 0, SupportButton.this.getHeight());
        }

        SupportMenu add(JMenuItem item) {
            this.popup.add(item);
            return this;
        }

        public SupportMenu add(String key, ImageIcon icon, ActionListener listener) {
            LocalizableMenuItem item = new LocalizableMenuItem(key);
            item.setIcon(icon);
            if (listener != null) {
                item.addActionListener(listener);
            }
            this.add(item);
            return this;
        }

        public SupportMenu add(String key, ActionListener listener) {
            return this.add(key, null, listener);
        }

        public SupportMenu add(String key) {
            LocalizableMenuItem item = new LocalizableMenuItem(key);
            item.setEnabled(false);
            this.add(item);
            return this;
        }

        public SupportMenu addSeparator() {
            this.popup.addSeparator();
            return this;
        }
    }
}

