/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.login.buttons;

import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.JPopupMenu;
import ru.turikhay.tlauncher.ui.LLaunchFrame;
import ru.turikhay.tlauncher.ui.block.Blockable;
import ru.turikhay.tlauncher.ui.block.Blocker;
import ru.turikhay.tlauncher.ui.images.Images;
import ru.turikhay.tlauncher.ui.loc.LocalizableButton;
import ru.turikhay.tlauncher.ui.loc.LocalizableMenuItem;
import ru.turikhay.tlauncher.ui.login.LoginForm;
import ru.turikhay.tlauncher.ui.notice.Notice;
import ru.turikhay.tlauncher.ui.notice.NoticeManagerListener;
import ru.turikhay.tlauncher.ui.scenes.DefaultScene;
import ru.turikhay.util.SwingUtil;

public class SettingsButton
extends LocalizableButton
implements Blockable,
NoticeManagerListener {
    private final LoginForm lf;
    private final JPopupMenu popup;
    private final LocalizableMenuItem accountManager;
    private final LocalizableMenuItem versionManager;
    private final LocalizableMenuItem notices;

    SettingsButton(LoginForm loginform) {
        this.lf = loginform;
        this.setToolTipText("loginform.button.settings");
        this.setIcon(Images.getIcon24("bars"));
        this.popup = new JPopupMenu();
        LocalizableMenuItem settings = new LocalizableMenuItem("loginform.button.settings.launcher");
        settings.addActionListener(e -> this.lf.scene.setSidePanel(DefaultScene.SidePanel.SETTINGS));
        this.popup.add(settings);
        this.versionManager = new LocalizableMenuItem("loginform.button.settings.version");
        this.versionManager.addActionListener(e -> this.lf.pane.openVersionManager());
        this.popup.add(this.versionManager);
        this.accountManager = new LocalizableMenuItem("loginform.button.settings.account");
        this.accountManager.addActionListener(e -> this.lf.pane.openAccountEditor());
        this.popup.add(this.accountManager);
        if (LLaunchFrame.isNotPostTlaunchEra()) {
            this.popup.add(LocalizableMenuItem.newItem("llaunch.menuItem", "ll-square", e -> LLaunchFrame.showInstance()));
        }
        this.notices = LocalizableMenuItem.newItem("loginform.button.settings.notices", e -> {
            this.lf.scene.setNoticeSidePanelEnabled(true);
            this.lf.scene.setSidePanel(DefaultScene.SidePanel.NOTICES);
        });
        this.updateNoticeEntry();
        this.setPreferredSize(new Dimension(30, this.getHeight()));
        this.addActionListener(e -> this.callPopup());
        this.lf.scene.getMainPane().getRootFrame().getNotices().addListener(this, true);
    }

    @Override
    public Insets getInsets() {
        return SwingUtil.magnify(super.getInsets());
    }

    void callPopup() {
        this.lf.defocus();
        this.popup.show(this, 0, this.getHeight());
    }

    @Override
    public void block(Object reason) {
        if (reason.equals("auth") || reason.equals("launch")) {
            Blocker.blockComponents(reason, this.accountManager, this.versionManager);
        }
    }

    @Override
    public void unblock(Object reason) {
        Blocker.unblockComponents(reason, this.accountManager, this.versionManager);
    }

    @Override
    public void onNoticeSelected(Notice notice) {
    }

    @Override
    public void onNoticePromoted(Notice promotedNotice) {
    }

    @Override
    public void updateLocale() {
        super.updateLocale();
        this.updateNoticeEntry();
    }

    private void updateNoticeEntry() {
        if (this.lf.scene.getMainPane().getRootFrame().getNotices().getForCurrentLocale() == null) {
            this.popup.remove(this.notices);
        } else {
            this.popup.add(this.notices);
        }
    }
}

