/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.login.buttons;

import java.awt.Insets;
import ru.turikhay.tlauncher.TLauncher;
import ru.turikhay.tlauncher.managers.ComponentManager;
import ru.turikhay.tlauncher.managers.ComponentManagerListener;
import ru.turikhay.tlauncher.managers.ComponentManagerListenerHelper;
import ru.turikhay.tlauncher.managers.LibraryReplaceProcessor;
import ru.turikhay.tlauncher.managers.LibraryReplaceProcessorListener;
import ru.turikhay.tlauncher.ui.block.Blockable;
import ru.turikhay.tlauncher.ui.block.Blocker;
import ru.turikhay.tlauncher.ui.images.ImageIcon;
import ru.turikhay.tlauncher.ui.images.Images;
import ru.turikhay.tlauncher.ui.loc.LocalizableButton;
import ru.turikhay.tlauncher.ui.login.LoginForm;
import ru.turikhay.util.SwingUtil;

public class RefreshButton
extends LocalizableButton
implements Blockable,
ComponentManagerListener,
LibraryReplaceProcessorListener {
    private static final int TYPE_REFRESH = 0;
    private static final int TYPE_CANCEL = 1;
    private final LoginForm lf;
    private int type;
    private final ImageIcon refresh = Images.getIcon24("refresh");
    private final ImageIcon cancel = Images.getIcon24("remove");

    private RefreshButton(LoginForm loginform, int type) {
        this.lf = loginform;
        this.setType(type, false);
        this.addActionListener(e -> this.onPressButton());
        TLauncher.getInstance().getManager().getComponent(ComponentManagerListenerHelper.class).addListener(this);
    }

    RefreshButton(LoginForm loginform) {
        this(loginform, 0);
    }

    @Override
    public Insets getInsets() {
        return SwingUtil.magnify(super.getInsets());
    }

    private void onPressButton() {
        switch (this.type) {
            case 0: {
                TLauncher.getInstance().getManager().startAsyncRefresh();
                break;
            }
            case 1: {
                TLauncher.getInstance().getManager().stopRefresh();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type: " + this.type + ". Use RefreshButton.TYPE_* constants.");
            }
        }
        this.lf.defocus();
    }

    void setType(int type) {
        this.setType(type, true);
    }

    void setType(int type, boolean repaint) {
        switch (type) {
            case 0: {
                this.setIcon(this.refresh);
                this.setToolTipText("loginform.button.refresh");
                break;
            }
            case 1: {
                this.setIcon(this.cancel);
                this.setToolTipText("loginform.button.refresh-cancel");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type: " + type + ". Use RefreshButton.TYPE_* constants.");
            }
        }
        this.type = type;
    }

    @Override
    public void onComponentsRefreshing(ComponentManager manager) {
        Blocker.block(this, "refresh");
    }

    @Override
    public void onComponentsRefreshed(ComponentManager manager) {
        Blocker.unblock(this, "refresh");
    }

    @Override
    public void block(Object reason) {
        if (reason.equals("refresh")) {
            this.setType(1);
        } else {
            this.setEnabled(false);
        }
        this.repaint();
    }

    @Override
    public void unblock(Object reason) {
        if (reason.equals("refresh")) {
            this.setType(0);
        }
        this.setEnabled(true);
        this.repaint();
    }

    @Override
    public void onLibraryReplaceRefreshing(LibraryReplaceProcessor manager) {
        Blocker.block(this, "library");
    }

    @Override
    public void onLibraryReplaceRefreshed(LibraryReplaceProcessor manager) {
        Blocker.unblock(this, "library");
    }

    private static class StatusResponse {
        private Status ely;
        private Status mojang;
        private String nextUpdateTime;
        private String responseTime;

        private StatusResponse() {
        }
    }

    private static enum Status {
        OK,
        BAD,
        AWFUL;

    }
}

