/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.login.buttons;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JPopupMenu;
import net.minecraft.launcher.updater.VersionSyncInfo;
import ru.turikhay.tlauncher.stats.Stats;
import ru.turikhay.tlauncher.ui.TLauncherFrame;
import ru.turikhay.tlauncher.ui.block.Blockable;
import ru.turikhay.tlauncher.ui.block.Blocker;
import ru.turikhay.tlauncher.ui.images.DelayedIcon;
import ru.turikhay.tlauncher.ui.images.Images;
import ru.turikhay.tlauncher.ui.loc.LocalizableButton;
import ru.turikhay.tlauncher.ui.loc.LocalizableMenuItem;
import ru.turikhay.tlauncher.ui.login.LoginForm;
import ru.turikhay.tlauncher.ui.notice.Notice;
import ru.turikhay.tlauncher.ui.notice.NoticeManager;
import ru.turikhay.tlauncher.ui.notice.NoticeManagerListener;
import ru.turikhay.tlauncher.ui.notice.NoticePopup;
import ru.turikhay.tlauncher.ui.swing.extended.BorderPanel;
import ru.turikhay.util.SwingUtil;

public class PlayButton
extends BorderPanel
implements Blockable,
LoginForm.LoginStateListener,
NoticeManagerListener {
    private static final long serialVersionUID = 6944074583143406549L;
    private PlayButtonState state;
    private final LoginForm loginForm;
    private final LocalizableButton button;
    private final LocalizableButton promotedNoticeButton;
    private final NoticePopup promotedNoticePopup = new NoticePopup();
    private final LocalizableMenuItem hideNotice = new LocalizableMenuItem("notice.action.hide");
    private final LocalizableMenuItem hidePromoted = new LocalizableMenuItem("notice.promoted.hide.here");
    private int mouseX;
    private int mouseY;
    private final JPopupMenu wrongButtonMenu;

    PlayButton(LoginForm lf) {
        Images.getIcon16("eye-slash").setup(this.hideNotice);
        this.hideNotice.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PlayButton.this.promotedNoticePopup.getNotice() != null) {
                    NoticeManager manager = ((PlayButton)PlayButton.this).loginForm.scene.getMainPane().getRootFrame().getNotices();
                    manager.setHidden(PlayButton.this.promotedNoticePopup.getNotice(), true);
                    manager.selectRandom();
                }
            }
        });
        this.promotedNoticePopup.registerItem(this.hideNotice);
        Images.getIcon16("eye-slash").setup(this.hidePromoted);
        this.hidePromoted.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NoticeManager manager = ((PlayButton)PlayButton.this).loginForm.scene.getMainPane().getRootFrame().getNotices();
                manager.setPromotedAllowed(false);
            }
        });
        this.promotedNoticePopup.registerItem(this.hidePromoted);
        this.wrongButtonMenu = new JPopupMenu();
        LocalizableMenuItem wrongButtonItem = new LocalizableMenuItem("loginform.wrongbutton");
        wrongButtonItem.setEnabled(false);
        wrongButtonItem.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                PlayButton.this.wrongButtonMenu.setVisible(false);
            }
        });
        this.wrongButtonMenu.add(wrongButtonItem);
        this.loginForm = lf;
        this.button = new LocalizableButton();
        this.button.addActionListener(e -> {
            switch (this.state) {
                case CANCEL: {
                    this.loginForm.stopLauncher();
                    break;
                }
                default: {
                    this.loginForm.startLauncher();
                }
            }
        });
        this.button.setFont(this.getFont().deriveFont(1).deriveFont(TLauncherFrame.getFontSize() * 1.5f));
        this.setCenter(this.button);
        this.promotedNoticeButton = new LocalizableButton();
        this.promotedNoticeButton.setPreferredSize(SwingUtil.magnify(new Dimension(48, 1)));
        this.promotedNoticeButton.addActionListener(e -> {
            this.promotedNoticePopup.updateList();
            this.promotedNoticePopup.show(this.promotedNoticeButton, this.promotedNoticeButton.getWidth(), 0);
        });
        this.onNoticePromoted(null);
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                PlayButton.this.mouseX = e.getX();
                PlayButton.this.mouseY = e.getY();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() != 1) {
                    PlayButton.this.wrongButtonMenu.show(PlayButton.this, PlayButton.this.mouseX, PlayButton.this.mouseY);
                }
            }
        });
        this.setState(PlayButtonState.PLAY);
        lf.scene.getMainPane().getRootFrame().getNotices().addListener(this, true);
    }

    public PlayButtonState getState() {
        return this.state;
    }

    public void setState(PlayButtonState state) {
        if (state == null) {
            throw new NullPointerException();
        }
        this.state = state;
        this.button.setText(state.getPath());
        if (state == PlayButtonState.CANCEL) {
            this.setEnabled(true);
        }
    }

    public void updateState() {
        VersionSyncInfo vs = this.loginForm.versions.getVersion();
        if (vs != null) {
            boolean installed = vs.isInstalled();
            boolean force = this.loginForm.checkbox.forceupdate.getState();
            if (!installed) {
                this.setState(PlayButtonState.INSTALL);
            } else {
                this.setState(force ? PlayButtonState.REINSTALL : PlayButtonState.PLAY);
            }
        }
    }

    @Override
    public void loginStateChanged(LoginForm.LoginState state) {
        if (state == LoginForm.LoginState.LAUNCHING) {
            this.setState(PlayButtonState.CANCEL);
        } else {
            this.updateState();
            this.setEnabled(!Blocker.isBlocked(this));
        }
    }

    @Override
    public void block(Object reason) {
        if (this.state != PlayButtonState.CANCEL) {
            this.setEnabled(false);
        }
    }

    @Override
    public void unblock(Object reason) {
        this.setEnabled(true);
    }

    @Override
    public void onNoticeSelected(Notice notice) {
    }

    @Override
    public void onNoticePromoted(Notice promotedNotice) {
        if (promotedNotice == null) {
            this.setEast(null);
        } else {
            this.setEast(this.promotedNoticeButton);
            this.promotedNoticePopup.setNotice(promotedNotice);
            this.promotedNoticeButton.setIcon(new DelayedIcon(promotedNotice.getImage(), 32, 32));
            Stats.noticeViewed(promotedNotice);
        }
        this.validate();
        this.repaint();
    }

    public static enum PlayButtonState {
        REINSTALL("loginform.enter.reinstall"),
        INSTALL("loginform.enter.install"),
        PLAY("loginform.enter"),
        CANCEL("loginform.enter.cancel");

        private final String path;

        private PlayButtonState(String path) {
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }
    }
}

