/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.login.buttons;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JPopupMenu;
import net.minecraft.launcher.updater.VersionSyncInfo;
import net.minecraft.launcher.versions.CompleteVersion;
import org.apache.commons.lang3.StringUtils;
import ru.turikhay.tlauncher.configuration.Configuration;
import ru.turikhay.tlauncher.ui.block.Unblockable;
import ru.turikhay.tlauncher.ui.images.Images;
import ru.turikhay.tlauncher.ui.loc.LocalizableButton;
import ru.turikhay.tlauncher.ui.loc.LocalizableMenuItem;
import ru.turikhay.tlauncher.ui.login.LoginForm;
import ru.turikhay.util.FileUtil;
import ru.turikhay.util.MinecraftUtil;
import ru.turikhay.util.OS;
import ru.turikhay.util.SwingUtil;
import ru.turikhay.util.async.AsyncThread;

public class FolderButton
extends LocalizableButton
implements Unblockable {
    private final LoginForm lf;
    final JPopupMenu menu = new JPopupMenu();
    final LocalizableMenuItem openFamily = LocalizableMenuItem.newItem("loginform.button.folder.family", e -> {
        File folder = this.getFamilyFolder();
        if (folder != null) {
            this.openFolder(folder);
        }
    });
    final LocalizableMenuItem openRoot;

    FolderButton(LoginForm loginform) {
        this.menu.add(this.openFamily);
        this.openRoot = LocalizableMenuItem.newItem("loginform.button.folder.root", e -> this.openDefFolder());
        this.menu.add(this.openRoot);
        this.lf = loginform;
        this.setToolTipText("loginform.button.folder");
        this.setIcon(Images.getIcon24("folder-open"));
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FolderButton.this.getFamilyFolder() == null) {
                    FolderButton.this.openDefFolder();
                } else {
                    FolderButton.this.menu.removeAll();
                    CompleteVersion complete = FolderButton.this.getSelectedVersion();
                    if (complete != null) {
                        FolderButton.this.menu.add(FolderButton.this.openFamily);
                        FolderButton.this.openFamily.setVariables(complete.getFamily());
                    }
                    FolderButton.this.menu.add(FolderButton.this.openRoot);
                    FolderButton.this.menu.show(FolderButton.this, 0, FolderButton.this.getHeight());
                }
            }
        });
    }

    @Override
    public Insets getInsets() {
        return SwingUtil.magnify(super.getInsets());
    }

    private CompleteVersion getSelectedVersion() {
        VersionSyncInfo syncInfo = this.lf.versions.getVersion();
        return syncInfo == null ? null : syncInfo.getLocalCompleteVersion();
    }

    private File getFamilyFolder() {
        Configuration.SeparateDirs separateDirs = this.lf.global.getSeparateDirs();
        CompleteVersion complete = this.getSelectedVersion();
        if (complete == null) {
            return null;
        }
        String dirName = null;
        switch (separateDirs) {
            case FAMILY: {
                dirName = complete.getFamily();
                break;
            }
            case VERSION: {
                dirName = complete.getID();
            }
        }
        if (dirName != null && !StringUtils.isEmpty((CharSequence)dirName)) {
            return new File(MinecraftUtil.getWorkingDirectory(false), "home/" + dirName);
        }
        return null;
    }

    private void openFolder(File folder) {
        if (folder == null) {
            throw new NullPointerException();
        }
        if (!folder.isDirectory()) {
            try {
                FileUtil.createFolder(folder);
            }
            catch (IOException ioE) {
                throw new RuntimeException(ioE);
            }
        }
        AsyncThread.execute(() -> OS.openFolder(folder));
    }

    private void openDefFolder() {
        this.openFolder(MinecraftUtil.getWorkingDirectory(false));
    }
}

