/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.login.buttons;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JPanel;
import ru.turikhay.tlauncher.ui.block.BlockablePanel;
import ru.turikhay.tlauncher.ui.login.LoginForm;
import ru.turikhay.tlauncher.ui.login.buttons.CancelAutoLoginButton;
import ru.turikhay.tlauncher.ui.login.buttons.FolderButton;
import ru.turikhay.tlauncher.ui.login.buttons.PlayButton;
import ru.turikhay.tlauncher.ui.login.buttons.RefreshButton;
import ru.turikhay.tlauncher.ui.login.buttons.SettingsButton;
import ru.turikhay.tlauncher.ui.login.buttons.SupportButton;
import ru.turikhay.util.SwingUtil;

public class ButtonPanel
extends BlockablePanel {
    private static final long serialVersionUID = -2155145867054136409L;
    public final PlayButton play;
    private final JPanel manageButtonsPanel;
    public final SupportButton support;
    public final FolderButton folder;
    public final RefreshButton refresh;
    public final SettingsButton settings;
    public final CancelAutoLoginButton cancel;
    private ButtonPanelState state;

    public ButtonPanel(LoginForm lf) {
        boolean letUserDoWhatHeWants = !lf.global.getBoolean("gui.settings.blocked");
        BorderLayout lm = new BorderLayout(SwingUtil.magnify(1), SwingUtil.magnify(2));
        this.setLayout(lm);
        this.setOpaque(false);
        this.play = new PlayButton(lf);
        this.add("Center", (Component)this.play);
        this.cancel = new CancelAutoLoginButton(lf);
        this.manageButtonsPanel = new JPanel(new GridLayout(0, letUserDoWhatHeWants ? 4 : 2));
        this.manageButtonsPanel.setOpaque(false);
        this.support = new SupportButton(lf);
        this.manageButtonsPanel.add(this.support);
        this.folder = new FolderButton(lf);
        if (letUserDoWhatHeWants) {
            this.manageButtonsPanel.add(this.folder);
        }
        this.refresh = new RefreshButton(lf);
        this.manageButtonsPanel.add(this.refresh);
        this.settings = new SettingsButton(lf);
        if (letUserDoWhatHeWants) {
            this.manageButtonsPanel.add(this.settings);
        }
        this.setState(lf.autologin.isEnabled() ? ButtonPanelState.AUTOLOGIN_CANCEL : ButtonPanelState.MANAGE_BUTTONS);
    }

    public ButtonPanelState getState() {
        return this.state;
    }

    public void setState(ButtonPanelState state) {
        if (state == null) {
            throw new NullPointerException();
        }
        this.state = state;
        switch (state) {
            case AUTOLOGIN_CANCEL: {
                this.remove(this.manageButtonsPanel);
                this.add("South", (Component)this.cancel);
                break;
            }
            case MANAGE_BUTTONS: {
                this.remove(this.cancel);
                this.add("South", (Component)this.manageButtonsPanel);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown state: " + (Object)((Object)state));
            }
        }
        this.validate();
    }

    public static enum ButtonPanelState {
        AUTOLOGIN_CANCEL,
        MANAGE_BUTTONS;

    }
}

