/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.login;

import java.awt.Component;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.swing.JList;
import net.minecraft.launcher.updater.VersionFilter;
import net.minecraft.launcher.updater.VersionSyncInfo;
import net.minecraft.launcher.versions.CompleteVersion;
import net.minecraft.launcher.versions.ReleaseType;
import net.minecraft.launcher.versions.Version;
import net.minecraft.launcher.versions.VersionFamily;
import org.apache.commons.lang3.StringUtils;
import ru.turikhay.tlauncher.TLauncher;
import ru.turikhay.tlauncher.configuration.Configuration;
import ru.turikhay.tlauncher.managers.SwingVersionManagerListener;
import ru.turikhay.tlauncher.managers.VersionManager;
import ru.turikhay.tlauncher.managers.VersionManagerListener;
import ru.turikhay.tlauncher.minecraft.auth.Account;
import ru.turikhay.tlauncher.ui.alert.Alert;
import ru.turikhay.tlauncher.ui.block.Blockable;
import ru.turikhay.tlauncher.ui.images.ImageIcon;
import ru.turikhay.tlauncher.ui.loc.Localizable;
import ru.turikhay.tlauncher.ui.loc.LocalizableComponent;
import ru.turikhay.tlauncher.ui.login.LoginException;
import ru.turikhay.tlauncher.ui.login.LoginForm;
import ru.turikhay.tlauncher.ui.login.LoginWaitException;
import ru.turikhay.tlauncher.ui.settings.JREComboBox;
import ru.turikhay.tlauncher.ui.settings.MemorySlider;
import ru.turikhay.tlauncher.ui.swing.SimpleComboBoxModel;
import ru.turikhay.tlauncher.ui.swing.VersionCellRenderer;
import ru.turikhay.tlauncher.ui.swing.combobox.ComboBoxFilter;
import ru.turikhay.tlauncher.ui.swing.combobox.IconText;
import ru.turikhay.tlauncher.ui.swing.extended.ExtendedComboBox;
import ru.turikhay.util.SwingUtil;
import ru.turikhay.util.U;

public class VersionComboBox
extends ExtendedComboBox<VersionSyncInfo>
implements Blockable,
VersionManagerListener,
LocalizableComponent,
LoginForm.LoginProcessListener {
    private static final long serialVersionUID = -9122074452728842733L;
    static Account.AccountType showVersionForType;
    private static final VersionSyncInfo LOADING;
    private static final VersionSyncInfo EMPTY;
    private final VersionManager manager;
    private final LoginForm loginForm;
    private final SimpleComboBoxModel<VersionSyncInfo> model;
    private String selectedVersion;
    final ComboBoxFilter<VersionSyncInfo> comboBoxFilter;
    private final VersionSeeker seeker = new VersionSeeker();
    private List<VersionSyncInfo> versionList;

    VersionComboBox(LoginForm lf) {
        super(new VersionCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<? extends VersionSyncInfo> list, VersionSyncInfo value, int index, boolean isSelected, boolean cellHasFocus) {
                list.setFixedCellWidth(SwingUtil.magnify(180));
                return super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            }

            @Override
            public Account.AccountType getShowVersionsFor() {
                return showVersionForType;
            }
        });
        this.loginForm = lf;
        this.model = this.getSimpleModel();
        this.manager = TLauncher.getInstance().getVersionManager();
        this.manager.addListener(new SwingVersionManagerListener(this));
        this.addItemListener(e -> {
            this.loginForm.buttons.play.updateState();
            VersionSyncInfo selected = this.getVersion();
            if (selected != null) {
                this.selectedVersion = selected.getID();
                this.loginForm.global.setForcefully("login.version", this.selectedVersion, false);
                this.loginForm.global.store();
                this.setToolTipText(this.selectedVersion);
            }
            if (this.loginForm.scene.settingsForm.isLoaded()) {
                ((JREComboBox)this.loginForm.scene.settingsForm.get().jre.getComponent()).selectedVersionChanged(selected);
                this.loginForm.scene.settingsForm.get().useSeparateDir.getComponent().repaint();
                ((MemorySlider)this.loginForm.scene.settingsForm.get().memory.getComponent()).updateForCurrentlySelectedVersion();
            }
        });
        this.selectedVersion = lf.global.get("login.version");
        this.comboBoxFilter = ComboBoxFilter.decorate(this, () -> this.versionList == null ? Collections.emptyList() : this.versionList, vs -> {
            if (vs == null) {
                return IconText.EMPTY;
            }
            ImageIcon imageIcon = null;
            String text = VersionCellRenderer.getLabelFor(vs);
            if (TLauncher.getInstance().getLibraryManager().hasLibrariesExplicitly((VersionSyncInfo)vs, showVersionForType.toString())) {
                imageIcon = VersionCellRenderer.getIconFor(showVersionForType);
            }
            return new IconText(imageIcon, text);
        }, this.seeker);
    }

    public VersionSyncInfo getVersion() {
        if (this.loginForm.requestedVersion != null) {
            return this.loginForm.requestedVersion;
        }
        VersionSyncInfo selected = (VersionSyncInfo)this.getSelectedItem();
        return selected != null && !selected.equals(LOADING) && !selected.equals(EMPTY) ? selected : null;
    }

    @Override
    public void logginingIn() throws LoginException {
        VersionSyncInfo selected = this.getVersion();
        if (selected == null) {
            throw new LoginWaitException("Version list is empty, refreshing", () -> {
                this.manager.refresh();
                if (this.getVersion() == null) {
                    if (this.loginForm.global.getBoolean("minecraft.versions.sub.remote")) {
                        Alert.showLocError("versions.notfound");
                    } else {
                        Alert.showLocError("versions.notfound.disabled");
                    }
                }
                throw new LoginException("Giving user a second chance to choose correct version...");
            });
        }
        if (selected.hasRemote() && selected.isInstalled() && !selected.isUpToDate()) {
            if (!Alert.showLocQuestion("versions.found-update")) {
                try {
                    CompleteVersion e = this.manager.getLocalList().getCompleteVersion(selected.getLocal());
                    e.setUpdatedTime(U.getUTC().getTime());
                    this.manager.getLocalList().saveVersion(e);
                }
                catch (IOException var3) {
                    Alert.showLocError("versions.found-update.error");
                }
            } else {
                this.loginForm.checkbox.forceupdate.setSelected(true);
            }
        }
    }

    @Override
    public void loginFailed() {
    }

    @Override
    public void loginSucceed() {
    }

    @Override
    public void updateLocale() {
        this.updateList(this.manager);
    }

    @Override
    public void onVersionsRefreshing(VersionManager vm) {
        this.updateList(null, null);
    }

    @Override
    public void onVersionsRefreshingFailed(VersionManager vm) {
        this.updateList(this.manager);
    }

    @Override
    public void onVersionsRefreshed(VersionManager vm) {
        this.updateList(this.manager);
        this.seeker.updateLocale();
    }

    void updateList(VersionManager manager) {
        if (manager == null) {
            throw new NullPointerException();
        }
        this.versionList = manager.getVersions(this.createFilter(), true);
        this.updateList(this.versionList, null);
    }

    void updateList(List<VersionSyncInfo> list, String select) {
        if (select == null && this.selectedVersion != null) {
            select = this.selectedVersion;
        }
        this.removeAllItems();
        if (list == null) {
            this.addItem(LOADING);
        } else if (list.isEmpty()) {
            this.addItem(EMPTY);
        } else {
            this.model.addElements(list);
            for (VersionSyncInfo version : list) {
                if (select == null || !version.getID().equals(select)) continue;
                this.setSelectedItem(version);
            }
        }
    }

    @Override
    public void block(Object reason) {
        this.setEnabled(false);
    }

    @Override
    public void unblock(Object reason) {
        this.setEnabled(true);
    }

    private Filter createFilter() {
        Configuration settings = TLauncher.getInstance().getSettings();
        return new Filter(settings.getVersionFilter(), settings.getBoolean("minecraft.versions.only-installed") ? this.manager.getVersions(true).stream().filter(VersionSyncInfo::isInstalled).map(VersionSyncInfo::getID).collect(Collectors.toList()) : null);
    }

    static {
        LOADING = VersionCellRenderer.LOADING;
        EMPTY = VersionCellRenderer.EMPTY;
    }

    private static class VersionSeeker
    implements BiPredicate<VersionSyncInfo, String>,
    LocalizableComponent {
        private Map<ReleaseType, String> localizedReleaseTypeCache;

        private VersionSeeker() {
        }

        @Override
        public boolean test(VersionSyncInfo vs, String termRaw) {
            if (vs == null || vs.getID() == null) {
                return false;
            }
            String term = VersionSeeker.normalize(termRaw);
            String id = VersionSeeker.normalize(vs.getID().toLowerCase(Locale.ROOT));
            if (id.contains(term)) {
                return true;
            }
            VersionFamily.Guess familyGuess = VersionFamily.guessFamilyOf(vs);
            if (familyGuess != null && familyGuess.getFamily().toLowerCase(Locale.ROOT).contains(term)) {
                return true;
            }
            String localizedTypeName = this.localizedReleaseTypeCache.get((Object)vs.getAvailableVersion().getReleaseType());
            if (localizedTypeName != null) {
                if (localizedTypeName.contains(term)) {
                    return true;
                }
                if ((localizedTypeName + " " + id).contains(term)) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public void updateLocale() {
            HashMap<ReleaseType, String> cache = new HashMap<ReleaseType, String>();
            ReleaseType.valuesCollection().forEach(type -> {
                String localizedTypeName = Localizable.nget("version." + type.name().toLowerCase(Locale.ROOT));
                if (localizedTypeName != null) {
                    cache.put((ReleaseType)((Object)type), localizedTypeName.toLowerCase(Locale.ROOT));
                }
            });
            this.localizedReleaseTypeCache = cache;
        }

        private static String normalize(String str) {
            str = str.toLowerCase(Locale.ROOT);
            str = str.trim();
            str = StringUtils.replaceChars((String)str, (String)",/", (String)".");
            return str;
        }
    }

    private static class Filter
    extends VersionFilter {
        final VersionFilter delegate;
        @Nullable
        final List<String> installed;

        Filter(VersionFilter delegate, @Nullable List<String> installed) {
            this.delegate = delegate;
            this.installed = installed;
        }

        @Override
        public boolean satisfies(Version v) {
            if (!this.delegate.satisfies(v)) {
                return false;
            }
            return this.installed == null || this.installed.contains(v.getID());
        }
    }
}

