/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.login;

import java.awt.Component;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.launcher.updater.VersionSyncInfo;
import net.minecraft.launcher.versions.CompleteVersion;
import net.minecraft.launcher.versions.ReleaseType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.tlauncher.downloader.Downloadable;
import ru.turikhay.tlauncher.downloader.Downloader;
import ru.turikhay.tlauncher.downloader.DownloaderListener;
import ru.turikhay.tlauncher.managers.SwingVersionManagerListener;
import ru.turikhay.tlauncher.managers.VersionManager;
import ru.turikhay.tlauncher.managers.VersionManagerListener;
import ru.turikhay.tlauncher.minecraft.Server;
import ru.turikhay.tlauncher.minecraft.auth.Authenticator;
import ru.turikhay.tlauncher.minecraft.auth.AuthenticatorListener;
import ru.turikhay.tlauncher.minecraft.crash.Crash;
import ru.turikhay.tlauncher.minecraft.crash.CrashManager;
import ru.turikhay.tlauncher.minecraft.crash.CrashManagerListener;
import ru.turikhay.tlauncher.minecraft.crash.SwingCrashManagerListener;
import ru.turikhay.tlauncher.minecraft.launcher.MinecraftException;
import ru.turikhay.tlauncher.minecraft.launcher.MinecraftListener;
import ru.turikhay.tlauncher.ui.MainPane;
import ru.turikhay.tlauncher.ui.alert.Alert;
import ru.turikhay.tlauncher.ui.block.Blocker;
import ru.turikhay.tlauncher.ui.center.CenterPanel;
import ru.turikhay.tlauncher.ui.login.AccountComboBox;
import ru.turikhay.tlauncher.ui.login.AutoLogin;
import ru.turikhay.tlauncher.ui.login.CheckBoxPanel;
import ru.turikhay.tlauncher.ui.login.LoginException;
import ru.turikhay.tlauncher.ui.login.LoginWaitException;
import ru.turikhay.tlauncher.ui.login.VersionComboBox;
import ru.turikhay.tlauncher.ui.login.buttons.ButtonPanel;
import ru.turikhay.tlauncher.ui.scenes.DefaultScene;
import ru.turikhay.tlauncher.ui.settings.SettingsPanel;
import ru.turikhay.tlauncher.ui.swing.DelayedComponent;
import ru.turikhay.tlauncher.ui.swing.extended.ExtendedPanel;
import ru.turikhay.tlauncher.user.AuthException;
import ru.turikhay.tlauncher.user.User;
import ru.turikhay.util.SwingUtil;
import ru.turikhay.util.U;
import ru.turikhay.util.async.AsyncThread;
import ru.turikhay.util.async.LoopedThread;

public class LoginForm
extends CenterPanel
implements MinecraftListener,
AuthenticatorListener<User>,
VersionManagerListener,
DownloaderListener,
CrashManagerListener {
    private static final Logger LOGGER = LogManager.getLogger(LoginForm.class);
    private final List<LoginStateListener> stateListeners = Collections.synchronizedList(new ArrayList());
    private final List<LoginProcessListener> processListeners = Collections.synchronizedList(new ArrayList());
    public final DefaultScene scene;
    public final MainPane pane;
    private final DelayedComponent<SettingsPanel> settings;
    public final AccountComboBox accounts;
    public final VersionComboBox versions;
    public final CheckBoxPanel checkbox;
    public final ButtonPanel buttons;
    public final AutoLogin autologin;
    private final StartThread startThread;
    private final StopThread stopThread;
    private LoginState state = LoginState.STOPPED;
    private Server server;
    private int serverId;
    public static final String LOGIN_BLOCK = "login";
    public static final String REFRESH_BLOCK = "refresh";
    public static final String LAUNCH_BLOCK = "launch";
    public static final String AUTH_BLOCK = "auth";
    public static final String UPDATER_BLOCK = "update";
    public static final String DOWNLOADER_BLOCK = "download";
    VersionSyncInfo requestedVersion;

    public LoginForm(DefaultScene scene) {
        this.scene = scene;
        this.pane = scene.getMainPane();
        this.settings = scene.settingsForm;
        this.startThread = new StartThread();
        this.stopThread = new StopThread();
        this.autologin = new AutoLogin(this);
        this.accounts = new AccountComboBox(this);
        this.buttons = new ButtonPanel(this);
        this.versions = new VersionComboBox(this);
        this.checkbox = new CheckBoxPanel(this);
        this.processListeners.add(this.autologin);
        this.processListeners.add(new LoginProcessListener(){

            @Override
            public void logginingIn() throws LoginException {
                ((SettingsPanel)LoginForm.this.settings.get()).logginingIn();
            }

            @Override
            public void loginFailed() {
                ((SettingsPanel)LoginForm.this.settings.get()).loginFailed();
            }

            @Override
            public void loginSucceed() {
                ((SettingsPanel)LoginForm.this.settings.get()).loginSucceed();
            }
        });
        this.processListeners.add(this.checkbox);
        this.processListeners.add(this.versions);
        this.processListeners.add(this.accounts);
        this.processListeners.add(new LoginListener(){

            @Override
            public void logginingIn() throws LoginException {
                CompleteVersion local;
                VersionSyncInfo sync = LoginForm.this.versions.getVersion();
                if (!sync.isInstalled() || !sync.hasRemote()) {
                    return;
                }
                if (ReleaseType.SubType.get(sync.getLocal()).contains((Object)ReleaseType.SubType.OLD_RELEASE)) {
                    return;
                }
                try {
                    local = sync.resolveCompleteVersion(LoginForm.this.tlauncher.getVersionManager(), false);
                }
                catch (Exception e) {
                    throw new RuntimeException("could not resolve local version", e);
                }
                if (local.getReleaseType() != ReleaseType.OLD_ALPHA && local.getReleaseType() != ReleaseType.OLD_BETA && !ReleaseType.SubType.OLD_RELEASE.isSubType(local) && local.getAssetIndex() != null && "legacy".equals(local.getAssetIndex().getId()) && Alert.showLocQuestion("versions.damaged-json")) {
                    LoginForm.this.checkbox.forceupdate.setSelected(true);
                }
            }
        });
        this.stateListeners.add(this.buttons.play);
        this.add((Component)this.messagePanel);
        this.add((Component)this.del(0));
        ExtendedPanel p = new ExtendedPanel();
        p.setLayout(new GridLayout(2, 1, 0, 2));
        p.add((Component)this.accounts);
        p.add((Component)this.versions);
        this.add((Component)p);
        this.add((Component)this.del(0));
        this.add((Component)this.checkbox);
        this.add((Component)this.del(0));
        this.add((Component)this.buttons);
        this.tlauncher.getVersionManager().addListener(new SwingVersionManagerListener(this));
        this.tlauncher.getDownloader().addListener(this);
        this.tlauncher.getUIListeners().registerMinecraftLauncherListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runProcess() {
        LoginException error = null;
        boolean success = true;
        List<LoginProcessListener> list = this.processListeners;
        synchronized (list) {
            for (LoginProcessListener listener : this.processListeners) {
                try {
                    listener.logginingIn();
                }
                catch (LoginWaitException loginError) {
                    LOGGER.debug("Caught a wait task");
                    this.block("wait-task");
                    try {
                        loginError.getWaitTask().runTask();
                    }
                    catch (LoginException e) {
                        LOGGER.error("Caught an error on a wait task of {}", (Object)listener, (Object)e);
                        error = e;
                    }
                    finally {
                        this.unblock("wait-task");
                    }
                }
                catch (LoginException e) {
                    LOGGER.error("Caught an error on listener {}", (Object)listener, (Object)e);
                    error = e;
                }
                if (error == null) continue;
                success = false;
                break;
            }
            if (success) {
                for (LoginProcessListener processListener : this.processListeners) {
                    processListener.loginSucceed();
                }
            } else {
                for (LoginProcessListener processListener : this.processListeners) {
                    processListener.loginFailed();
                }
            }
        }
        if (error != null) {
            LOGGER.warn("Login process has ended with an error.");
        } else {
            if (this.accounts.getAccount() != null) {
                this.global.setForcefully("login.account", this.accounts.getAccount().getUsername(), false);
                this.global.setForcefully("login.account.type", (Object)this.accounts.getAccount().getType(), false);
            }
            this.global.setForcefully("login.version", this.versions.getVersion().getID(), false);
            this.global.store();
            this.changeState(LoginState.LAUNCHING);
            LOGGER.debug("Calling Minecraft Launcher...");
            String versionName = this.requestedVersion == null ? this.versions.getVersion().getID() : this.requestedVersion.getID();
            boolean forceUpdate = this.checkbox.forceupdate.isSelected();
            AsyncThread.execute(() -> this.tlauncher.newMinecraftLauncher(versionName, this.server, this.serverId, forceUpdate).start());
            this.checkbox.forceupdate.setSelected(false);
        }
        this.requestedVersion = null;
    }

    private void stopProcess() {
        while (!this.tlauncher.isMinecraftLauncherWorking()) {
            U.sleepFor(500L);
        }
        this.changeState(LoginState.STOPPING);
        this.tlauncher.getMinecraftLauncher().stop();
    }

    public void startLauncher() {
        this.startLauncher(null, 0);
    }

    public void startLauncher(Server server, int serverId) {
        this.startLauncher(null, server, serverId);
    }

    public void startLauncher(VersionSyncInfo requestedVersion, Server server, int serverId) {
        if (!Blocker.isBlocked(this)) {
            LOGGER.debug("Starting launcher: {}", (Object)requestedVersion);
            Blocker.block(this, "starting");
            AsyncThread.execute(() -> {
                while (this.tlauncher.getLibraryManager().isRefreshing()) {
                    LOGGER.debug("Waiting for library manager...");
                    U.sleepFor(500L);
                }
                SwingUtil.later(() -> {
                    try {
                        this.requestedVersion = requestedVersion;
                        if (requestedVersion != null) {
                            this.versions.setSelectedValue(requestedVersion);
                        }
                        this.server = server;
                        this.serverId = serverId;
                        this.autologin.setActive(false);
                        this.startThread.iterate();
                    }
                    finally {
                        Blocker.unblock(this, "starting");
                    }
                });
            });
        }
    }

    public void stopLauncher() {
        this.stopThread.iterate();
    }

    private void changeState(LoginState state) {
        if (state == null) {
            throw new NullPointerException();
        }
        if (this.state != state) {
            this.state = state;
            for (LoginStateListener listener : this.stateListeners) {
                listener.loginStateChanged(state);
            }
        }
    }

    @Override
    public void block(Object reason) {
        if (!Blocker.getBlockList(this).contains(REFRESH_BLOCK)) {
            Blocker.block(this.accounts, reason);
        }
        Blocker.block(reason, this.settings, this.versions, this.checkbox, this.buttons, this.scene.noticePanel);
    }

    @Override
    public synchronized void unblock(Object reason) {
        Blocker.unblock(reason, this.settings, this.accounts, this.versions, this.checkbox, this.buttons, this.scene.noticePanel);
    }

    @Override
    public void onDownloaderStart(Downloader d, int files) {
        Blocker.block(this, DOWNLOADER_BLOCK);
    }

    @Override
    public void onDownloaderAbort(Downloader d) {
        Blocker.unblock(this, DOWNLOADER_BLOCK);
    }

    @Override
    public void onDownloaderProgress(Downloader d, double progress, double speed) {
    }

    @Override
    public void onDownloaderFileComplete(Downloader d, Downloadable file) {
    }

    @Override
    public void onDownloaderComplete(Downloader d) {
        Blocker.unblock(this, DOWNLOADER_BLOCK);
    }

    @Override
    public void onVersionsRefreshing(VersionManager manager) {
        Blocker.block(this, REFRESH_BLOCK);
    }

    @Override
    public void onVersionsRefreshingFailed(VersionManager manager) {
        Blocker.unblock(this, REFRESH_BLOCK);
    }

    @Override
    public void onVersionsRefreshed(VersionManager manager) {
        Blocker.unblock(this, REFRESH_BLOCK);
    }

    @Override
    public void onAuthPassing(Authenticator<? extends User> auth) {
        Blocker.block(this, AUTH_BLOCK);
    }

    @Override
    public void onAuthPassingError(Authenticator<? extends User> auth, Throwable e) {
        if (e instanceof AuthException && ((AuthException)e).isSoft() && Alert.showLocQuestion("account.exception.soft")) {
            return;
        }
        Blocker.unblock(this, AUTH_BLOCK);
        throw new LoginException("Cannot auth!");
    }

    @Override
    public void onAuthPassed(Authenticator<? extends User> auth) {
        Blocker.unblock(this, AUTH_BLOCK);
    }

    @Override
    public void onMinecraftPrepare() {
        Blocker.block(this, LAUNCH_BLOCK);
    }

    @Override
    public void onMinecraftAbort() {
        Blocker.unblock(this, LAUNCH_BLOCK);
        this.buttons.play.updateState();
    }

    @Override
    public void onMinecraftLaunch() {
        this.changeState(LoginState.LAUNCHED);
    }

    @Override
    public void onMinecraftClose() {
        Blocker.unblock(this, LAUNCH_BLOCK);
        this.changeState(LoginState.STOPPED);
        if (this.autologin.isEnabled()) {
            this.tlauncher.getVersionManager().asyncRefresh();
        } else {
            this.tlauncher.getVersionManager().asyncRefresh(true);
        }
    }

    @Override
    public void onMinecraftError(Throwable e) {
        Blocker.unblock(this, LAUNCH_BLOCK);
        this.changeState(LoginState.STOPPED);
    }

    @Override
    public void onMinecraftKnownError(MinecraftException e) {
        Blocker.unblock(this, LAUNCH_BLOCK);
        this.changeState(LoginState.STOPPED);
    }

    @Override
    public void onCrashManagerInit(CrashManager manager) {
        Blocker.unblock(this, LAUNCH_BLOCK);
        this.changeState(LoginState.STOPPED);
        manager.addListener(new SwingCrashManagerListener(this));
    }

    @Override
    public void onCrashManagerProcessing(CrashManager manager) {
        Blocker.block(this, "crash");
    }

    @Override
    public void onCrashManagerComplete(CrashManager manager, Crash crash) {
        Blocker.unblock(this, "crash");
    }

    @Override
    public void onCrashManagerCancelled(CrashManager manager) {
        Blocker.unblock(this, "crash");
    }

    @Override
    public void onCrashManagerFailed(CrashManager manager, Exception e) {
        Blocker.unblock(this, "crash");
    }

    public static enum LoginState {
        LAUNCHING,
        STOPPING,
        STOPPED,
        LAUNCHED;

    }

    class StartThread
    extends LoopedThread {
        StartThread() {
            this.startAndWait();
        }

        @Override
        protected void iterateOnce() {
            try {
                LoginForm.this.runProcess();
            }
            catch (Throwable e) {
                Alert.showError(e);
            }
        }
    }

    class StopThread
    extends LoopedThread {
        StopThread() {
            this.startAndWait();
        }

        @Override
        protected void iterateOnce() {
            try {
                LoginForm.this.stopProcess();
            }
            catch (Throwable e) {
                Alert.showError(e);
            }
        }
    }

    public static interface LoginProcessListener {
        public void logginingIn() throws LoginException;

        public void loginFailed();

        public void loginSucceed();
    }

    public static interface LoginStateListener {
        public void loginStateChanged(LoginState var1);
    }

    public static abstract class LoginListener
    implements LoginProcessListener {
        @Override
        public abstract void logginingIn() throws LoginException;

        @Override
        public void loginFailed() {
        }

        @Override
        public void loginSucceed() {
        }
    }
}

