/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.login;

import ru.turikhay.tlauncher.ui.login.LoginException;
import ru.turikhay.tlauncher.ui.login.LoginForm;
import ru.turikhay.tlauncher.ui.login.buttons.ButtonPanel;
import ru.turikhay.util.U;
import ru.turikhay.util.async.AsyncThread;

public class AutoLogin
implements LoginForm.LoginProcessListener {
    public static final int DEFAULT_TIMEOUT = 3;
    public static final int MIN_TIMEOUT = 2;
    public static final int MAX_TIMEOUT = 10;
    private boolean enabled;
    private boolean active;
    private final int timeout;
    private int sec;
    private final Runnable task;
    private final LoginForm loginForm;

    AutoLogin(LoginForm lf) {
        this.loginForm = lf;
        this.enabled = lf.global.getBoolean("login.auto");
        int timeout = lf.global.getInteger("login.auto.timeout");
        if (timeout < 2 || timeout > 10) {
            timeout = 3;
        }
        this.timeout = timeout;
        this.task = () -> {
            while (this.sec > 0) {
                U.sleepFor(1000L);
                if (!this.updateLogin()) continue;
                this.loginForm.startLauncher();
            }
        };
    }

    private boolean updateLogin() {
        --this.sec;
        this.loginForm.buttons.cancel.setText("loginform.cancel", this.sec);
        if (this.sec != 0) {
            return false;
        }
        this.stopActive();
        return true;
    }

    public void setActive(boolean active) {
        if (this.active != active) {
            this.active = active;
            if (active) {
                this.startActive();
            } else {
                this.stopActive();
            }
        }
    }

    public boolean isActive() {
        return this.active;
    }

    private void startActive() {
        this.sec = this.timeout;
        AsyncThread.execute(this.task);
    }

    private void stopActive() {
        this.sec = -1;
        this.loginForm.buttons.setState(ButtonPanel.ButtonPanelState.MANAGE_BUTTONS);
    }

    public void setEnabled(boolean enabled) {
        if (this.enabled != enabled) {
            this.enabled = enabled;
            if (this.active) {
                this.setActive(enabled);
            }
            if (this.loginForm.checkbox.autologin.isSelected() != enabled) {
                this.loginForm.checkbox.autologin.setSelected(enabled);
            }
            this.loginForm.global.set("login.auto", (Object)enabled);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getTimeout() {
        return this.timeout;
    }

    @Override
    public void logginingIn() throws LoginException {
        this.setActive(false);
    }

    @Override
    public void loginFailed() {
    }

    @Override
    public void loginSucceed() {
    }
}

