/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.login;

import java.io.IOException;
import java.util.Collection;
import java.util.Locale;
import net.minecraft.launcher.versions.ReleaseType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.tlauncher.TLauncher;
import ru.turikhay.tlauncher.managers.ProfileManager;
import ru.turikhay.tlauncher.managers.ProfileManagerListener;
import ru.turikhay.tlauncher.managers.SwingProfileManagerListener;
import ru.turikhay.tlauncher.minecraft.auth.Account;
import ru.turikhay.tlauncher.minecraft.auth.Authenticator;
import ru.turikhay.tlauncher.minecraft.auth.AuthenticatorDatabase;
import ru.turikhay.tlauncher.minecraft.auth.AuthenticatorListener;
import ru.turikhay.tlauncher.ui.alert.Alert;
import ru.turikhay.tlauncher.ui.block.Blockable;
import ru.turikhay.tlauncher.ui.listener.AuthUIListener;
import ru.turikhay.tlauncher.ui.loc.LocalizableComponent;
import ru.turikhay.tlauncher.ui.login.LoginException;
import ru.turikhay.tlauncher.ui.login.LoginForm;
import ru.turikhay.tlauncher.ui.login.LoginWaitException;
import ru.turikhay.tlauncher.ui.login.VersionComboBox;
import ru.turikhay.tlauncher.ui.swing.AccountCellRenderer;
import ru.turikhay.tlauncher.ui.swing.SimpleComboBoxModel;
import ru.turikhay.tlauncher.ui.swing.extended.ExtendedComboBox;
import ru.turikhay.tlauncher.user.InvalidCredentialsException;
import ru.turikhay.tlauncher.user.User;

public class AccountComboBox
extends ExtendedComboBox<Account<? extends User>>
implements Blockable,
LoginForm.LoginProcessListener,
ProfileManagerListener,
LocalizableComponent {
    private static final Logger LOGGER = LogManager.getLogger(AccountComboBox.class);
    private static final long serialVersionUID = 6618039863712810645L;
    private static final Account<? extends User> EMPTY = AccountCellRenderer.EMPTY;
    private static final Account<? extends User> MANAGE = AccountCellRenderer.MANAGE;
    private final ProfileManager manager;
    private final LoginForm loginForm;
    private final AuthenticatorListener<? super User> listener;
    private final SimpleComboBoxModel<Account<? extends User>> model;
    private Account<? extends User> selectedAccount;
    boolean refreshing;

    AccountComboBox(LoginForm lf) {
        super(new AccountCellRenderer());
        this.loginForm = lf;
        this.model = this.getSimpleModel();
        this.manager = TLauncher.getInstance().getProfileManager();
        this.manager.addListener(new SwingProfileManagerListener(this));
        this.listener = new AuthUIListener<User>((AuthenticatorListener)lf){

            @Override
            public void onAuthPassingError(Authenticator<? extends User> auth, Throwable e) {
                if (e instanceof InvalidCredentialsException) {
                    ((AccountComboBox)AccountComboBox.this).loginForm.pane.openAccountEditor();
                    ((AccountComboBox)AccountComboBox.this).loginForm.pane.accountManager.get().multipane.showTip("add-account-" + (AccountComboBox.this.selectedAccount.getType() == Account.AccountType.ELY_LEGACY ? "ely" : AccountComboBox.this.selectedAccount.getType().name().toLowerCase(Locale.ROOT)));
                }
                super.onAuthPassingError(auth, e);
            }
        };
        this.addItemListener(e -> {
            Account selected = (Account)this.getSelectedItem();
            if (selected != null && selected != EMPTY) {
                if (selected == MANAGE) {
                    if (this.selectedAccount != null && this.loginForm.pane.accountManager.isLoaded()) {
                        this.loginForm.pane.accountManager.get().list.select(this.selectedAccount);
                    }
                    this.loginForm.pane.openAccountEditor();
                    this.setSelectedIndex(0);
                } else {
                    this.selectedAccount = selected;
                    TLauncher.getInstance().getProfileManager().getAccountManager().getUserSet().select(this.selectedAccount == null ? null : this.selectedAccount.getUser(), false);
                    try {
                        TLauncher.getInstance().getProfileManager().saveProfiles();
                    }
                    catch (IOException e1) {
                        LOGGER.warn("Could not save profiles", (Throwable)e1);
                    }
                }
            }
            this.updateAccount();
        });
    }

    private void updateAccount() {
        Account.AccountType type = Account.AccountType.PLAIN;
        if (!this.refreshing && this.selectedAccount != null) {
            if (!(this.selectedAccount.getType() != Account.AccountType.ELY && this.selectedAccount.getType() != Account.AccountType.ELY_LEGACY && this.selectedAccount.getType() != Account.AccountType.MCLEAKS || this.loginForm.tlauncher.getLibraryManager().isRefreshing())) {
                this.loginForm.tlauncher.getLibraryManager().asyncRefresh();
            }
            type = this.selectedAccount.getType();
        }
        VersionComboBox.showVersionForType = type;
        this.loginForm.versions.comboBoxFilter.updateState();
    }

    public Account<? extends User> getAccount() {
        Account value = (Account)this.getSelectedItem();
        return value != null && !value.equals(EMPTY) ? value : null;
    }

    public void setAccount(Account<? extends User> account) {
        if (account != null && !account.equals(this.getAccount())) {
            this.setSelectedItem(account);
        }
    }

    @Override
    public void logginingIn() throws LoginException {
        if (this.loginForm.versions.getVersion() != null && this.loginForm.versions.getVersion().getAvailableVersion().getReleaseType() == ReleaseType.LAUNCHER) {
            return;
        }
        Account<? extends User> account = this.getAccount();
        if (account == null) {
            this.loginForm.pane.openAccountEditor();
            Alert.showLocError("account.empty.error");
            throw new LoginException("Account list is empty!");
        }
        if (!account.isFree()) {
            throw new LoginWaitException("Waiting for auth...", () -> Authenticator.instanceFor(account).pass(this.listener));
        }
    }

    @Override
    public void loginFailed() {
    }

    @Override
    public void loginSucceed() {
    }

    public void refreshAccounts(AuthenticatorDatabase db, Account<? extends User> select) {
        this.removeAllItems();
        this.selectedAccount = null;
        Collection<Account<? extends User>> list1 = db.getAccounts();
        if (list1.isEmpty()) {
            this.addItem(EMPTY);
        } else {
            this.refreshing = true;
            this.model.addElements(list1);
            for (Account<? extends User> account1 : list1) {
                if (select == null || !select.equals(account1)) continue;
                this.setSelectedItem(account1);
                break;
            }
            this.refreshing = false;
        }
        this.addItem(MANAGE);
        this.updateAccount();
    }

    @Override
    public void updateLocale() {
        this.refreshAccounts(this.manager.getAuthDatabase(), (Account)this.getSelectedValue());
    }

    @Override
    public void onAccountsRefreshed(AuthenticatorDatabase db) {
        this.refreshAccounts(db, null);
    }

    @Override
    public void onProfilesRefreshed(ProfileManager pm) {
        this.refreshAccounts(pm.getAuthDatabase(), (Account<? extends User>)(pm.getAccountManager().getUserSet().getSelected() == null ? null : new Account<User>((User)pm.getAccountManager().getUserSet().getSelected())));
    }

    @Override
    public void onProfileManagerChanged(ProfileManager pm) {
        this.refreshAccounts(pm.getAuthDatabase(), (Account<? extends User>)(pm.getAccountManager().getUserSet().getSelected() == null ? null : new Account<User>((User)pm.getAccountManager().getUserSet().getSelected())));
    }

    @Override
    public void block(Object reason) {
        this.setEnabled(false);
    }

    @Override
    public void unblock(Object reason) {
        this.setEnabled(true);
    }
}

