/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.logger;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BoundedRangeModel;
import javax.swing.JFrame;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Document;
import ru.turikhay.tlauncher.TLauncher;
import ru.turikhay.tlauncher.configuration.Configuration;
import ru.turikhay.tlauncher.ui.loc.Localizable;
import ru.turikhay.tlauncher.ui.loc.LocalizableComponent;
import ru.turikhay.tlauncher.ui.loc.LocalizableLabel;
import ru.turikhay.tlauncher.ui.logger.BottomPanel;
import ru.turikhay.tlauncher.ui.logger.LoggerPopup;
import ru.turikhay.tlauncher.ui.swing.ScrollPane;
import ru.turikhay.tlauncher.ui.swing.extended.ExtendedComponentAdapter;
import ru.turikhay.tlauncher.ui.swing.extended.ExtendedTextArea;
import ru.turikhay.util.SwingUtil;

class LoggerFrame
extends JFrame
implements LocalizableComponent {
    private final Configuration config;
    private final int capacity;
    private final ExtendedTextArea textArea;
    private final ScrollPane scrollPane;
    private final BottomPanel bottomPanel;
    private boolean shouldScrollDown = true;
    private int lastWindowWidth;
    private int scrollBarValue;
    private ExtendedComponentAdapter listenerThread;

    LoggerFrame(Configuration config, int capacity) {
        this.config = config;
        this.capacity = capacity;
        this.textArea = new ExtendedTextArea();
        this.initTextArea();
        this.scrollPane = new ScrollPane(this.textArea);
        this.initScrollPane();
        this.bottomPanel = new BottomPanel();
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.scrollPane, "Center");
        this.getContentPane().add((Component)this.bottomPanel, "South");
        this.initFrame();
    }

    LoggerFrame(Configuration config) {
        this(config, 0x100000);
    }

    public void append(String text) {
        SwingUtilities.invokeLater(() -> this.syncAppend(text));
    }

    public void clear() {
        SwingUtilities.invokeLater(this::syncClear);
    }

    public void showFrame() {
        SwingUtilities.invokeLater(() -> {
            this.updateFromConfiguration();
            this.setVisible(true);
            this.scrollDown();
        });
    }

    public void disposeFrame() {
        this.listenerThread.dispose();
        SwingUtilities.invokeLater(this::dispose);
    }

    public void setFolderAction(Runnable action) {
        SwingUtilities.invokeLater(() -> this.bottomPanel.setFolder(action));
    }

    public void setSaveAction(Runnable action) {
        SwingUtilities.invokeLater(() -> this.bottomPanel.setSave(action));
    }

    public void setKillAction(Runnable action) {
        SwingUtilities.invokeLater(() -> this.bottomPanel.setKill(action));
    }

    private void updateFromConfiguration() {
        String prefix = "gui.logger.";
        int width = this.config.getInteger(prefix + "width", 670);
        int height = this.config.getInteger(prefix + "height", 500);
        int x = this.config.getInteger(prefix + "x", 0);
        int y = this.config.getInteger(prefix + "y", 0);
        this.setSize(width, height);
        this.setLocation(x, y);
    }

    private void delayedSave() {
        SwingUtilities.invokeLater(this::saveStateInfoConfiguration);
    }

    private void saveStateInfoConfiguration() {
        if (!this.isDisplayable() || !this.isVisible()) {
            return;
        }
        String prefix = "gui.logger.";
        Dimension size = this.getSize();
        Point location = this.getLocation();
        this.config.set(prefix + "width", size.width, false);
        this.config.set(prefix + "height", size.height, false);
        this.config.set(prefix + "x", location.x, false);
        this.config.set(prefix + "y", location.y, false);
    }

    private void syncAppend(String text) {
        boolean mustScrollDown;
        try {
            mustScrollDown = this.insertText(text);
        }
        catch (RuntimeException | BadLocationException ignored) {
            mustScrollDown = false;
        }
        if (mustScrollDown || this.shouldScrollDown) {
            SwingUtilities.invokeLater(this::scrollDown);
        }
    }

    private boolean insertText(String text) throws BadLocationException {
        Document document = this.textArea.getDocument();
        document.insertString(document.getLength(), text, null);
        int length = document.getLength();
        if (length >= this.capacity) {
            document.remove(0, this.capacity / 2);
            return true;
        }
        return false;
    }

    private void syncClear() {
        Document document = this.textArea.getDocument();
        try {
            document.remove(0, document.getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private void scrollDown() {
        JScrollBar vert = this.scrollPane.getVerticalScrollBar();
        vert.setValue(vert.getMaximum());
    }

    private void initTextArea() {
        this.textArea.setLineWrap(true);
        this.textArea.setEditable(false);
        this.textArea.setAutoscrolls(true);
        this.textArea.setMargin(new Insets(0, 0, 0, 0));
        this.textArea.setFont(new Font("DialogInput", 0, (int)((double)new LocalizableLabel().getFont().getSize() * 1.2)));
        this.textArea.setForeground(Color.white);
        this.textArea.setCaretColor(Color.white);
        this.textArea.setBackground(Color.black);
        this.textArea.setSelectionColor(Color.gray);
        ((DefaultCaret)this.textArea.getCaret()).setUpdatePolicy(2);
        this.textArea.addMouseListener(new LoggerPopup(this));
    }

    private void initScrollPane() {
        this.scrollPane.setBorder(null);
        this.scrollPane.setVBPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        this.initVerticalScrollbar();
    }

    private void initVerticalScrollbar() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                LoggerFrame.this.lastWindowWidth = LoggerFrame.this.getWidth();
            }
        });
        this.scrollPane.getVerticalScrollBar().addAdjustmentListener(e -> {
            if (this.getWidth() == this.lastWindowWidth) {
                BoundedRangeModel vsbModel = this.scrollPane.getVerticalScrollBar().getModel();
                int nv = e.getValue();
                if (nv < this.scrollBarValue) {
                    this.shouldScrollDown = false;
                } else if (nv == vsbModel.getMaximum() - vsbModel.getExtent()) {
                    this.shouldScrollDown = true;
                }
                this.scrollBarValue = nv;
            }
        });
    }

    private void initFrame() {
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                if (LoggerFrame.this.config.getLoggerType() == Configuration.LoggerType.GLOBAL) {
                    LoggerFrame.this.config.setLoggerType(Configuration.LoggerType.NONE);
                    if (TLauncher.getInstance().isReady() && TLauncher.getInstance().getFrame().mp.defaultScene.settingsForm.isLoaded()) {
                        TLauncher.getInstance().getFrame().mp.defaultScene.settingsForm.get().updateValues();
                    }
                }
            }
        });
        this.listenerThread = new ExtendedComponentAdapter(this){

            @Override
            public void onComponentResized(ComponentEvent e) {
                LoggerFrame.this.delayedSave();
            }

            @Override
            public void onComponentMoved(ComponentEvent e) {
                LoggerFrame.this.delayedSave();
            }
        };
        this.addComponentListener(this.listenerThread);
        SwingUtil.setFavicons(this);
        this.updateLocale();
    }

    @Override
    public void updateLocale() {
        SwingUtilities.invokeLater(() -> this.setTitle(Localizable.get("logger")));
    }
}

