/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.loc;

import java.awt.Component;
import ru.turikhay.tlauncher.ui.loc.Localizable;
import ru.turikhay.tlauncher.ui.loc.LocalizableComponent;
import ru.turikhay.tlauncher.ui.progress.ProgressBar;

public class LocalizableProgressBar
extends ProgressBar
implements LocalizableComponent {
    private static final long serialVersionUID = 7393243528402135898L;
    private String westPath;
    private String centerPath;
    private String eastPath;
    private String[] westVars;
    private String[] centerVars;
    private String[] eastVars;

    protected LocalizableProgressBar(Component parentComp) {
        super(parentComp);
    }

    protected LocalizableProgressBar() {
        this((Component)null);
    }

    public void setWestString(String path, boolean update, Object ... vars) {
        this.westPath = path;
        this.westVars = Localizable.checkVariables(vars);
        super.setWestString(Localizable.get(this.westPath, this.westVars), update);
    }

    @Override
    public void setWestString(String path, boolean update) {
        this.setWestString(path, update, Localizable.EMPTY_VARS);
    }

    public void setWestString(String path, Object ... vars) {
        this.setWestString(path, true, vars);
    }

    public void setCenterString(String path, boolean update, Object ... vars) {
        this.centerPath = path;
        this.centerVars = Localizable.checkVariables(vars);
        super.setCenterString(Localizable.get(this.centerPath, this.centerVars), update);
    }

    @Override
    public void setCenterString(String path, boolean update) {
        this.setCenterString(path, update, Localizable.EMPTY_VARS);
    }

    public void setCenterString(String path, Object ... vars) {
        this.setCenterString(path, true, vars);
    }

    public void setEastString(String path, boolean update, Object ... vars) {
        this.eastPath = path;
        this.eastVars = Localizable.checkVariables(vars);
        super.setEastString(Localizable.get(this.eastPath, this.eastVars), update);
    }

    @Override
    public void setEastString(String path, boolean update) {
        this.setEastString(path, update, Localizable.EMPTY_VARS);
    }

    public void setEastString(String path, Object ... vars) {
        this.setEastString(path, true, vars);
    }

    public void setStrings(String west, String center, String east, boolean acceptNull, boolean repaint, boolean saveVars) {
        if (acceptNull || west != null) {
            this.setWestString(west, false, saveVars ? this.westVars : Localizable.EMPTY_VARS);
        }
        if (acceptNull || center != null) {
            this.setCenterString(center, false, saveVars ? this.centerVars : Localizable.EMPTY_VARS);
        }
        if (acceptNull || east != null) {
            this.setEastString(east, false, saveVars ? this.eastVars : Localizable.EMPTY_VARS);
        }
        this.repaint();
    }

    @Override
    public void setStrings(String west, String center, String east, boolean acceptNull, boolean repaint) {
        this.setStrings(west, center, east, acceptNull, repaint, false);
    }

    @Override
    public void updateLocale() {
        this.setStrings(this.westPath, this.centerPath, this.eastPath, true, true);
    }
}

